"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class NetworkTokenCreateTypedDict(TypedDict):
    merchant_initiated: bool
    r"""Defines if the request is merchant initiated or not."""
    is_subsequent_payment: bool
    r"""Defines if the request is a subsequent of another request or not."""
    security_code: NotRequired[Nullable[str]]
    r"""The 3 or 4 digit security code often found on the card. This often referred to as the CVV or CVD."""


class NetworkTokenCreate(BaseModel):
    merchant_initiated: bool
    r"""Defines if the request is merchant initiated or not."""

    is_subsequent_payment: bool
    r"""Defines if the request is a subsequent of another request or not."""

    security_code: OptionalNullable[str] = UNSET
    r"""The 3 or 4 digit security code often found on the card. This often referred to as the CVV or CVD."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["security_code"]
        nullable_fields = ["security_code"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
