"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .auditlogaction import AuditLogAction
from .auditlogentries import AuditLogEntries, AuditLogEntriesTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import (
    FieldMetadata,
    HeaderMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListAuditLogsGlobalsTypedDict(TypedDict):
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ListAuditLogsGlobals(BaseModel):
    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""


class ListAuditLogsRequestTypedDict(TypedDict):
    cursor: NotRequired[Nullable[str]]
    r"""A pointer to the page of results to return."""
    limit: NotRequired[int]
    r"""The maximum number of items that are at returned."""
    action: NotRequired[Nullable[AuditLogAction]]
    r"""Filters the results to only the items for which the `audit-log` has an `action` that matches this value."""
    user_id: NotRequired[Nullable[str]]
    r"""Filters the results to only the items for which the `user` has an `id` that matches this value."""
    resource_type: NotRequired[Nullable[str]]
    r"""Filters the results to only the items for which the `audit-log` has a `resource` that matches this type value."""
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ListAuditLogsRequest(BaseModel):
    cursor: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""A pointer to the page of results to return."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""The maximum number of items that are at returned."""

    action: Annotated[
        Annotated[
            OptionalNullable[AuditLogAction], PlainValidator(validate_open_enum(False))
        ],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters the results to only the items for which the `audit-log` has an `action` that matches this value."""

    user_id: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters the results to only the items for which the `user` has an `id` that matches this value."""

    resource_type: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters the results to only the items for which the `audit-log` has a `resource` that matches this type value."""

    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cursor",
            "limit",
            "action",
            "user_id",
            "resource_type",
            "merchant_account_id",
        ]
        nullable_fields = ["cursor", "action", "user_id", "resource_type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAuditLogsResponseTypedDict(TypedDict):
    result: AuditLogEntriesTypedDict


class ListAuditLogsResponse(BaseModel):
    next: Callable[[], Optional[ListAuditLogsResponse]]

    result: AuditLogEntries
