"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .digitalwalletprovider import DigitalWalletProvider
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Any, Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DigitalWalletTypedDict(TypedDict):
    id: str
    r"""The ID for the digital wallet."""
    merchant_account_id: str
    r"""The ID of the merchant account this digital wallet belongs to."""
    provider: DigitalWalletProvider
    merchant_name: str
    r"""The name of the merchant the digital wallet is registered to."""
    domain_names: List[str]
    r"""The list of domain names that a digital wallet can be used on (deprecated)."""
    created_at: datetime
    r"""The date this buyer was created at."""
    updated_at: datetime
    r"""The date this buyer was last updated at."""
    type: Literal["digital-wallet"]
    r"""Always `digital-wallet`."""
    merchant_display_name: NotRequired[Nullable[str]]
    r"""The consumer facing name of the merchant."""
    merchant_url: NotRequired[Nullable[str]]
    r"""The main URL of the merchant."""
    merchant_country_code: NotRequired[Nullable[str]]
    r"""The country code where the merchant is registered."""
    active_certificate_count: NotRequired[int]
    r"""The number of active custom certificates registered for this digital wallet (Apple Pay only)."""
    pending_certificate_count: NotRequired[int]
    r"""The number of pending custom certificates registered for this digital wallet (Apple Pay only)."""
    expired_certificate_count: NotRequired[int]
    r"""The number of expired custom certificates registered for this digital wallet (Apple Pay only)."""
    fields: NotRequired[Nullable[Dict[str, Any]]]
    r"""Custom attributes for some digital wallets. Currently only used by Click to Pay."""


class DigitalWallet(BaseModel):
    id: str
    r"""The ID for the digital wallet."""

    merchant_account_id: str
    r"""The ID of the merchant account this digital wallet belongs to."""

    provider: Annotated[
        DigitalWalletProvider, PlainValidator(validate_open_enum(False))
    ]

    merchant_name: str
    r"""The name of the merchant the digital wallet is registered to."""

    domain_names: List[str]
    r"""The list of domain names that a digital wallet can be used on (deprecated)."""

    created_at: datetime
    r"""The date this buyer was created at."""

    updated_at: datetime
    r"""The date this buyer was last updated at."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["digital-wallet"]],
            AfterValidator(validate_const("digital-wallet")),
        ],
        pydantic.Field(alias="type"),
    ] = "digital-wallet"
    r"""Always `digital-wallet`."""

    merchant_display_name: OptionalNullable[str] = UNSET
    r"""The consumer facing name of the merchant."""

    merchant_url: OptionalNullable[str] = UNSET
    r"""The main URL of the merchant."""

    merchant_country_code: OptionalNullable[str] = UNSET
    r"""The country code where the merchant is registered."""

    active_certificate_count: Optional[int] = 0
    r"""The number of active custom certificates registered for this digital wallet (Apple Pay only)."""

    pending_certificate_count: Optional[int] = 0
    r"""The number of pending custom certificates registered for this digital wallet (Apple Pay only)."""

    expired_certificate_count: Optional[int] = 0
    r"""The number of expired custom certificates registered for this digital wallet (Apple Pay only)."""

    fields: OptionalNullable[Dict[str, Any]] = UNSET
    r"""Custom attributes for some digital wallets. Currently only used by Click to Pay."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "merchant_display_name",
            "merchant_url",
            "merchant_country_code",
            "active_certificate_count",
            "pending_certificate_count",
            "expired_certificate_count",
            "fields",
        ]
        nullable_fields = [
            "merchant_display_name",
            "merchant_url",
            "merchant_country_code",
            "fields",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
