"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CardPaymentMethodCreateTypedDict(TypedDict):
    expiration_date: str
    r"""The expiration date of the card, formatted `MM/YY`."""
    number: str
    r"""The 13-19 digit number for this card."""
    buyer_external_identifier: NotRequired[Nullable[str]]
    r"""The external identifier of the buyer to attach the method to."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The ID of the buyer to attach the method to."""
    external_identifier: NotRequired[Nullable[str]]
    r"""The merchant reference for this payment method."""
    card_type: NotRequired[Nullable[str]]
    r"""The type of the card used"""
    method: Literal["card"]
    r"""Always `card`"""
    security_code: NotRequired[Nullable[str]]
    r"""The 3 or 4 digit security code often found on the card. This often referred to as the CVV or CVD."""


class CardPaymentMethodCreate(BaseModel):
    expiration_date: str
    r"""The expiration date of the card, formatted `MM/YY`."""

    number: str
    r"""The 13-19 digit number for this card."""

    buyer_external_identifier: OptionalNullable[str] = UNSET
    r"""The external identifier of the buyer to attach the method to."""

    buyer_id: OptionalNullable[str] = UNSET
    r"""The ID of the buyer to attach the method to."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""The merchant reference for this payment method."""

    card_type: OptionalNullable[str] = UNSET
    r"""The type of the card used"""

    METHOD: Annotated[
        Annotated[Optional[Literal["card"]], AfterValidator(validate_const("card"))],
        pydantic.Field(alias="method"),
    ] = "card"
    r"""Always `card`"""

    security_code: OptionalNullable[str] = UNSET
    r"""The 3 or 4 digit security code often found on the card. This often referred to as the CVV or CVD."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "buyer_external_identifier",
            "buyer_id",
            "external_identifier",
            "card_type",
            "method",
            "security_code",
        ]
        nullable_fields = [
            "buyer_external_identifier",
            "buyer_id",
            "external_identifier",
            "card_type",
            "security_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
