# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.account_statements import AccountStatements
from solomonai_backend_client_sdk.models.bank_account_status import BankAccountStatus
from solomonai_backend_client_sdk.models.bank_account_type import BankAccountType
from typing import Optional, Set
from typing_extensions import Self

class StudentLoanAccount(BaseModel):
    """
    StudentLoanAccount
    """ # noqa: E501
    id: Optional[StrictStr] = None
    plaid_account_id: Optional[StrictStr] = Field(default=None, alias="plaidAccountId")
    disbursement_dates: Optional[List[StrictStr]] = Field(default=None, alias="disbursementDates")
    expected_payoff_date: Optional[StrictStr] = Field(default=None, alias="expectedPayoffDate")
    guarantor: Optional[StrictStr] = None
    interest_rate_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="interestRatePercentage")
    is_overdue: Optional[StrictBool] = Field(default=None, alias="isOverdue")
    last_payment_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="lastPaymentAmount")
    last_payment_date: Optional[StrictStr] = Field(default=None, alias="lastPaymentDate")
    last_statement_issue_date: Optional[StrictStr] = Field(default=None, alias="lastStatementIssueDate")
    loan_name: Optional[StrictStr] = Field(default=None, alias="loanName")
    loan_end_date: Optional[StrictStr] = Field(default=None, alias="loanEndDate")
    minimum_payment_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="minimumPaymentAmount")
    next_payment_due_date: Optional[StrictStr] = Field(default=None, alias="nextPaymentDueDate")
    origination_date: Optional[StrictStr] = Field(default=None, alias="originationDate")
    origination_principal_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="originationPrincipalAmount")
    outstanding_interest_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="outstandingInterestAmount")
    payment_reference_number: Optional[StrictStr] = Field(default=None, alias="paymentReferenceNumber")
    sequence_number: Optional[StrictStr] = Field(default=None, alias="sequenceNumber")
    ytd_interest_paid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ytdInterestPaid")
    ytd_principal_paid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ytdPrincipalPaid")
    loan_type: Optional[StrictStr] = Field(default=None, alias="loanType")
    pslf_status_estimated_eligibility_date: Optional[StrictStr] = Field(default=None, alias="pslfStatusEstimatedEligibilityDate")
    pslf_status_payments_made: Optional[StrictInt] = Field(default=None, alias="pslfStatusPaymentsMade")
    pslf_status_payments_remaining: Optional[StrictInt] = Field(default=None, alias="pslfStatusPaymentsRemaining")
    repayment_plan_type: Optional[StrictStr] = Field(default=None, alias="repaymentPlanType")
    repayment_plan_description: Optional[StrictStr] = Field(default=None, alias="repaymentPlanDescription")
    servicer_address_city: Optional[StrictStr] = Field(default=None, alias="servicerAddressCity")
    servicer_address_postal_code: Optional[StrictStr] = Field(default=None, alias="servicerAddressPostalCode")
    servicer_address_state: Optional[StrictStr] = Field(default=None, alias="servicerAddressState")
    servicer_address_street: Optional[StrictStr] = Field(default=None, alias="servicerAddressStreet")
    servicer_address_region: Optional[StrictStr] = Field(default=None, alias="servicerAddressRegion")
    servicer_address_country: Optional[StrictStr] = Field(default=None, alias="servicerAddressCountry")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    name: Optional[StrictStr] = None
    status: Optional[BankAccountStatus] = BankAccountStatus.UNSPECIFIED
    statements: Optional[List[AccountStatements]] = None
    plaid_account_type: Optional[StrictStr] = Field(default=None, alias="plaidAccountType")
    type: Optional[BankAccountType] = BankAccountType.UNSPECIFIED
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "plaidAccountId", "disbursementDates", "expectedPayoffDate", "guarantor", "interestRatePercentage", "isOverdue", "lastPaymentAmount", "lastPaymentDate", "lastStatementIssueDate", "loanName", "loanEndDate", "minimumPaymentAmount", "nextPaymentDueDate", "originationDate", "originationPrincipalAmount", "outstandingInterestAmount", "paymentReferenceNumber", "sequenceNumber", "ytdInterestPaid", "ytdPrincipalPaid", "loanType", "pslfStatusEstimatedEligibilityDate", "pslfStatusPaymentsMade", "pslfStatusPaymentsRemaining", "repaymentPlanType", "repaymentPlanDescription", "servicerAddressCity", "servicerAddressPostalCode", "servicerAddressState", "servicerAddressStreet", "servicerAddressRegion", "servicerAddressCountry", "userId", "name", "status", "statements", "plaidAccountType", "type", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StudentLoanAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in statements (list)
        _items = []
        if self.statements:
            for _item in self.statements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['statements'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StudentLoanAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "plaidAccountId": obj.get("plaidAccountId"),
            "disbursementDates": obj.get("disbursementDates"),
            "expectedPayoffDate": obj.get("expectedPayoffDate"),
            "guarantor": obj.get("guarantor"),
            "interestRatePercentage": obj.get("interestRatePercentage"),
            "isOverdue": obj.get("isOverdue"),
            "lastPaymentAmount": obj.get("lastPaymentAmount"),
            "lastPaymentDate": obj.get("lastPaymentDate"),
            "lastStatementIssueDate": obj.get("lastStatementIssueDate"),
            "loanName": obj.get("loanName"),
            "loanEndDate": obj.get("loanEndDate"),
            "minimumPaymentAmount": obj.get("minimumPaymentAmount"),
            "nextPaymentDueDate": obj.get("nextPaymentDueDate"),
            "originationDate": obj.get("originationDate"),
            "originationPrincipalAmount": obj.get("originationPrincipalAmount"),
            "outstandingInterestAmount": obj.get("outstandingInterestAmount"),
            "paymentReferenceNumber": obj.get("paymentReferenceNumber"),
            "sequenceNumber": obj.get("sequenceNumber"),
            "ytdInterestPaid": obj.get("ytdInterestPaid"),
            "ytdPrincipalPaid": obj.get("ytdPrincipalPaid"),
            "loanType": obj.get("loanType"),
            "pslfStatusEstimatedEligibilityDate": obj.get("pslfStatusEstimatedEligibilityDate"),
            "pslfStatusPaymentsMade": obj.get("pslfStatusPaymentsMade"),
            "pslfStatusPaymentsRemaining": obj.get("pslfStatusPaymentsRemaining"),
            "repaymentPlanType": obj.get("repaymentPlanType"),
            "repaymentPlanDescription": obj.get("repaymentPlanDescription"),
            "servicerAddressCity": obj.get("servicerAddressCity"),
            "servicerAddressPostalCode": obj.get("servicerAddressPostalCode"),
            "servicerAddressState": obj.get("servicerAddressState"),
            "servicerAddressStreet": obj.get("servicerAddressStreet"),
            "servicerAddressRegion": obj.get("servicerAddressRegion"),
            "servicerAddressCountry": obj.get("servicerAddressCountry"),
            "userId": obj.get("userId"),
            "name": obj.get("name"),
            "status": obj.get("status") if obj.get("status") is not None else BankAccountStatus.UNSPECIFIED,
            "statements": [AccountStatements.from_dict(_item) for _item in obj["statements"]] if obj.get("statements") is not None else None,
            "plaidAccountType": obj.get("plaidAccountType"),
            "type": obj.get("type") if obj.get("type") is not None else BankAccountType.UNSPECIFIED,
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


