# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.company_address import CompanyAddress
from solomonai_backend_client_sdk.models.purchase_order_line_item import PurchaseOrderLineItem
from typing import Optional, Set
from typing_extensions import Self

class PurchaseOrder(BaseModel):
    """
    The PurchaseOrder object is a record of request for a product or service between a buyer and seller.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    status: Optional[StrictStr] = None
    issue_date: Optional[datetime] = Field(default=None, description="The purchase order's issue date.", alias="issueDate")
    purchase_order_number: Optional[StrictStr] = Field(default=None, description="The human-readable number of the purchase order.", alias="purchaseOrderNumber")
    delivery_date: Optional[datetime] = Field(default=None, description="The purchase order's delivery date.", alias="deliveryDate")
    delivery_address: Optional[CompanyAddress] = Field(default=None, alias="deliveryAddress")
    customer: Optional[StrictStr] = Field(default=None, description="The contact making the purchase order.")
    vendor: Optional[StrictStr] = Field(default=None, description="The party fulfilling the purchase order.")
    memo: Optional[StrictStr] = Field(default=None, description="A memo attached to the purchase order.")
    company: Optional[StrictStr] = Field(default=None, description="The company the purchase order belongs to.")
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The purchase order's total amount.  Might be better as double.", alias="totalAmount")
    currency: Optional[StrictStr] = Field(default=None, description="The purchase order's currency.")
    exchange_rate: Optional[StrictStr] = Field(default=None, description="Assuming string, but might be better as float or double.", alias="exchangeRate")
    line_items: Optional[List[PurchaseOrderLineItem]] = Field(default=None, alias="lineItems")
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    remote_created_at: Optional[datetime] = Field(default=None, alias="remoteCreatedAt")
    remote_updated_at: Optional[datetime] = Field(default=None, alias="remoteUpdatedAt")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, alias="remoteWasDeleted")
    accounting_period: Optional[StrictStr] = Field(default=None, description="The accounting period that the PurchaseOrder was generated in.", alias="accountingPeriod")
    remote_id: Optional[StrictStr] = Field(default=None, alias="remoteId")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "mergeRecordId", "status", "issueDate", "purchaseOrderNumber", "deliveryDate", "deliveryAddress", "customer", "vendor", "memo", "company", "totalAmount", "currency", "exchangeRate", "lineItems", "trackingCategories", "remoteCreatedAt", "remoteUpdatedAt", "remoteWasDeleted", "accountingPeriod", "remoteId", "modifiedAt", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PurchaseOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of delivery_address
        if self.delivery_address:
            _dict['deliveryAddress'] = self.delivery_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item in self.line_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lineItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PurchaseOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "status": obj.get("status"),
            "issueDate": obj.get("issueDate"),
            "purchaseOrderNumber": obj.get("purchaseOrderNumber"),
            "deliveryDate": obj.get("deliveryDate"),
            "deliveryAddress": CompanyAddress.from_dict(obj["deliveryAddress"]) if obj.get("deliveryAddress") is not None else None,
            "customer": obj.get("customer"),
            "vendor": obj.get("vendor"),
            "memo": obj.get("memo"),
            "company": obj.get("company"),
            "totalAmount": obj.get("totalAmount"),
            "currency": obj.get("currency"),
            "exchangeRate": obj.get("exchangeRate"),
            "lineItems": [PurchaseOrderLineItem.from_dict(_item) for _item in obj["lineItems"]] if obj.get("lineItems") is not None else None,
            "trackingCategories": obj.get("trackingCategories"),
            "remoteCreatedAt": obj.get("remoteCreatedAt"),
            "remoteUpdatedAt": obj.get("remoteUpdatedAt"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "accountingPeriod": obj.get("accountingPeriod"),
            "remoteId": obj.get("remoteId"),
            "modifiedAt": obj.get("modifiedAt"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


