# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.any import Any
from solomonai_backend_client_sdk.models.smart_note import SmartNote
from typing import Optional, Set
from typing_extensions import Self

class PlaidAccountRecurringTransaction(BaseModel):
    """
    Message representing recurring transactions associated with a Plaid account.
    """ # noqa: E501
    account_id: Optional[StrictStr] = Field(default=None, alias="accountId")
    stream_id: Optional[StrictStr] = Field(default=None, alias="streamId")
    category_id: Optional[StrictStr] = Field(default=None, alias="categoryId")
    description: Optional[StrictStr] = None
    merchant_name: Optional[StrictStr] = Field(default=None, alias="merchantName")
    personal_finance_category_primary: Optional[StrictStr] = Field(default=None, alias="personalFinanceCategoryPrimary")
    personal_finance_category_detailed: Optional[StrictStr] = Field(default=None, alias="personalFinanceCategoryDetailed")
    first_date: Optional[datetime] = Field(default=None, alias="firstDate")
    last_date: Optional[datetime] = Field(default=None, alias="lastDate")
    frequency: Optional[StrictStr] = None
    transaction_ids: Optional[StrictStr] = Field(default=None, alias="transactionIds")
    average_amount: Optional[StrictStr] = Field(default=None, alias="averageAmount")
    average_amount_iso_currency_code: Optional[StrictStr] = Field(default=None, alias="averageAmountIsoCurrencyCode")
    last_amount: Optional[StrictStr] = Field(default=None, alias="lastAmount")
    last_amount_iso_currency_code: Optional[StrictStr] = Field(default=None, alias="lastAmountIsoCurrencyCode")
    is_active: Optional[StrictBool] = Field(default=None, alias="isActive")
    status: Optional[StrictStr] = None
    updated_time: Optional[datetime] = Field(default=None, alias="updatedTime")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    link_id: Optional[StrictStr] = Field(default=None, alias="linkId")
    id: Optional[StrictStr] = None
    flow: Optional[StrictStr] = None
    time: Optional[datetime] = Field(default=None, description="The timestamp associated with this recurring transaction.")
    additional_properties: Optional[Any] = Field(default=None, alias="additionalProperties")
    notes: Optional[List[SmartNote]] = Field(default=None, description="Notes associated with this recurring transaction.")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["accountId", "streamId", "categoryId", "description", "merchantName", "personalFinanceCategoryPrimary", "personalFinanceCategoryDetailed", "firstDate", "lastDate", "frequency", "transactionIds", "averageAmount", "averageAmountIsoCurrencyCode", "lastAmount", "lastAmountIsoCurrencyCode", "isActive", "status", "updatedTime", "userId", "linkId", "id", "flow", "time", "additionalProperties", "notes", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlaidAccountRecurringTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of additional_properties
        if self.additional_properties:
            _dict['additionalProperties'] = self.additional_properties.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item in self.notes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['notes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlaidAccountRecurringTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "streamId": obj.get("streamId"),
            "categoryId": obj.get("categoryId"),
            "description": obj.get("description"),
            "merchantName": obj.get("merchantName"),
            "personalFinanceCategoryPrimary": obj.get("personalFinanceCategoryPrimary"),
            "personalFinanceCategoryDetailed": obj.get("personalFinanceCategoryDetailed"),
            "firstDate": obj.get("firstDate"),
            "lastDate": obj.get("lastDate"),
            "frequency": obj.get("frequency"),
            "transactionIds": obj.get("transactionIds"),
            "averageAmount": obj.get("averageAmount"),
            "averageAmountIsoCurrencyCode": obj.get("averageAmountIsoCurrencyCode"),
            "lastAmount": obj.get("lastAmount"),
            "lastAmountIsoCurrencyCode": obj.get("lastAmountIsoCurrencyCode"),
            "isActive": obj.get("isActive"),
            "status": obj.get("status"),
            "updatedTime": obj.get("updatedTime"),
            "userId": obj.get("userId"),
            "linkId": obj.get("linkId"),
            "id": obj.get("id"),
            "flow": obj.get("flow"),
            "time": obj.get("time"),
            "additionalProperties": Any.from_dict(obj["additionalProperties"]) if obj.get("additionalProperties") is not None else None,
            "notes": [SmartNote.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


