# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.any import Any
from solomonai_backend_client_sdk.models.smart_note import SmartNote
from typing import Optional, Set
from typing_extensions import Self

class PlaidAccountInvestmentTransaction(BaseModel):
    """
    Message representing investment transactions associated with a Plaid account.
    """ # noqa: E501
    account_id: Optional[StrictStr] = Field(default=None, alias="accountId")
    ammount: Optional[StrictStr] = None
    investment_transaction_id: Optional[StrictStr] = Field(default=None, alias="investmentTransactionId")
    security_id: Optional[StrictStr] = Field(default=None, alias="securityId")
    current_date: Optional[StrictStr] = Field(default=None, alias="currentDate")
    name: Optional[StrictStr] = None
    quantity: Optional[Union[StrictFloat, StrictInt]] = None
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    price: Optional[Union[StrictFloat, StrictInt]] = None
    fees: Optional[Union[StrictFloat, StrictInt]] = None
    type: Optional[StrictStr] = None
    subtype: Optional[StrictStr] = None
    iso_currency_code: Optional[StrictStr] = Field(default=None, alias="isoCurrencyCode")
    unofficial_currency_code: Optional[StrictStr] = Field(default=None, alias="unofficialCurrencyCode")
    link_id: Optional[StrictStr] = Field(default=None, alias="linkId")
    id: Optional[StrictStr] = None
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    time: Optional[datetime] = None
    additional_properties: Optional[Any] = Field(default=None, alias="additionalProperties")
    notes: Optional[List[SmartNote]] = None
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["accountId", "ammount", "investmentTransactionId", "securityId", "currentDate", "name", "quantity", "amount", "price", "fees", "type", "subtype", "isoCurrencyCode", "unofficialCurrencyCode", "linkId", "id", "userId", "createdAt", "time", "additionalProperties", "notes", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlaidAccountInvestmentTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of additional_properties
        if self.additional_properties:
            _dict['additionalProperties'] = self.additional_properties.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item in self.notes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['notes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlaidAccountInvestmentTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "ammount": obj.get("ammount"),
            "investmentTransactionId": obj.get("investmentTransactionId"),
            "securityId": obj.get("securityId"),
            "currentDate": obj.get("currentDate"),
            "name": obj.get("name"),
            "quantity": obj.get("quantity"),
            "amount": obj.get("amount"),
            "price": obj.get("price"),
            "fees": obj.get("fees"),
            "type": obj.get("type"),
            "subtype": obj.get("subtype"),
            "isoCurrencyCode": obj.get("isoCurrencyCode"),
            "unofficialCurrencyCode": obj.get("unofficialCurrencyCode"),
            "linkId": obj.get("linkId"),
            "id": obj.get("id"),
            "userId": obj.get("userId"),
            "createdAt": obj.get("createdAt"),
            "time": obj.get("time"),
            "additionalProperties": Any.from_dict(obj["additionalProperties"]) if obj.get("additionalProperties") is not None else None,
            "notes": [SmartNote.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


