# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Payment(BaseModel):
    """
    The Payment object represents general payments made towards a specific transaction.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, alias="remoteId")
    transaction_date: Optional[datetime] = Field(default=None, description="The payment's transaction date.", alias="transactionDate")
    contact: Optional[StrictStr] = Field(default=None, description="The supplier, or customer involved in the payment.")
    account: Optional[StrictStr] = Field(default=None, description="The supplier’s or customer’s account in which the payment is made.")
    currency: Optional[StrictStr] = None
    exchange_rate: Optional[StrictStr] = Field(default=None, description="The payment's exchange rate.  Assuming string due to the example provided, but could be float or double.", alias="exchangeRate")
    company: Optional[StrictStr] = Field(default=None, description="The company the payment belongs to.")
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total amount of money being paid to the supplier, or customer, after taxes.  Might want to use double or a more precise type", alias="totalAmount")
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    remote_updated_at: Optional[datetime] = Field(default=None, alias="remoteUpdatedAt")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, alias="remoteWasDeleted")
    accounting_period: Optional[StrictStr] = Field(default=None, description="The accounting period that the Payment was generated in.", alias="accountingPeriod")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "transactionDate", "contact", "account", "currency", "exchangeRate", "company", "totalAmount", "trackingCategories", "remoteUpdatedAt", "remoteWasDeleted", "accountingPeriod", "modifiedAt", "mergeRecordId", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Payment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Payment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "transactionDate": obj.get("transactionDate"),
            "contact": obj.get("contact"),
            "account": obj.get("account"),
            "currency": obj.get("currency"),
            "exchangeRate": obj.get("exchangeRate"),
            "company": obj.get("company"),
            "totalAmount": obj.get("totalAmount"),
            "trackingCategories": obj.get("trackingCategories"),
            "remoteUpdatedAt": obj.get("remoteUpdatedAt"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "accountingPeriod": obj.get("accountingPeriod"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


