# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.organization_member_status import OrganizationMemberStatus
from solomonai_backend_client_sdk.models.permission_type import PermissionType
from solomonai_backend_client_sdk.models.role import Role
from typing import Optional, Set
from typing_extensions import Self

class OrgMember(BaseModel):
    """
    OrgMember
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the organization member.")
    role: Optional[Role] = None
    email: StrictStr = Field(description="Email of the member.")
    name: StrictStr = Field(description="Name of the member.")
    joined_at: Optional[datetime] = Field(default=None, description="Timestamp when the member joined.", alias="joinedAt")
    invited_by_email: Optional[StrictStr] = Field(default=None, description="email of the account that invited the member.", alias="invitedByEmail")
    status: Optional[OrganizationMemberStatus] = OrganizationMemberStatus.UNSPECIFIED
    last_access: Optional[datetime] = Field(default=None, description="Timestamp of the last access.", alias="lastAccess")
    permissions: Optional[List[PermissionType]] = Field(default=None, description="Permissions assigned to the member.")
    deleted_at: Optional[datetime] = Field(default=None, description="Timestamp when the member was soft-deleted.", alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "role", "email", "name", "joinedAt", "invitedByEmail", "status", "lastAccess", "permissions", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrgMember from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of role
        if self.role:
            _dict['role'] = self.role.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrgMember from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "role": Role.from_dict(obj["role"]) if obj.get("role") is not None else None,
            "email": obj.get("email"),
            "name": obj.get("name"),
            "joinedAt": obj.get("joinedAt"),
            "invitedByEmail": obj.get("invitedByEmail"),
            "status": obj.get("status") if obj.get("status") is not None else OrganizationMemberStatus.UNSPECIFIED,
            "lastAccess": obj.get("lastAccess"),
            "permissions": obj.get("permissions"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


