# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.account_statements import AccountStatements
from solomonai_backend_client_sdk.models.bank_account_status import BankAccountStatus
from solomonai_backend_client_sdk.models.bank_account_type import BankAccountType
from typing import Optional, Set
from typing_extensions import Self

class MortgageAccount(BaseModel):
    """
    MortgageAccount
    """ # noqa: E501
    id: Optional[StrictStr] = None
    plaid_account_id: Optional[StrictStr] = Field(default=None, alias="plaidAccountId")
    account_number: Optional[StrictStr] = Field(default=None, alias="accountNumber")
    current_late_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="currentLateFee")
    escrow_balance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="escrowBalance")
    has_pmi: Optional[StrictBool] = Field(default=None, alias="hasPmi")
    has_prepayment_penalty: Optional[StrictBool] = Field(default=None, alias="hasPrepaymentPenalty")
    last_payment_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="lastPaymentAmount")
    last_payment_date: Optional[StrictStr] = Field(default=None, alias="lastPaymentDate")
    loan_term: Optional[StrictStr] = Field(default=None, alias="loanTerm")
    loan_type_description: Optional[StrictStr] = Field(default=None, alias="loanTypeDescription")
    maturity_date: Optional[StrictStr] = Field(default=None, alias="maturityDate")
    next_monthly_payment: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="nextMonthlyPayment")
    next_payment_due_date: Optional[StrictStr] = Field(default=None, alias="nextPaymentDueDate")
    original_principal_balance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="originalPrincipalBalance")
    original_property_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="originalPropertyValue")
    outstanding_principal_balance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="outstandingPrincipalBalance")
    payment_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="paymentAmount")
    payment_date: Optional[StrictStr] = Field(default=None, alias="paymentDate")
    origination_date: Optional[StrictStr] = Field(default=None, alias="originationDate")
    origination_principal_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="originationPrincipalAmount")
    past_due_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="pastDueAmount")
    ytd_interest_paid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ytdInterestPaid")
    ytd_principal_paid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ytdPrincipalPaid")
    property_address_city: Optional[StrictStr] = Field(default=None, alias="propertyAddressCity")
    property_address_state: Optional[StrictStr] = Field(default=None, alias="propertyAddressState")
    property_address_street: Optional[StrictStr] = Field(default=None, alias="propertyAddressStreet")
    property_address_postal_code: Optional[StrictStr] = Field(default=None, alias="propertyAddressPostalCode")
    property_region: Optional[StrictStr] = Field(default=None, alias="propertyRegion")
    property_country: Optional[StrictStr] = Field(default=None, alias="propertyCountry")
    interest_rate_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="interestRatePercentage")
    interest_rate_type: Optional[StrictStr] = Field(default=None, alias="interestRateType")
    status: Optional[BankAccountStatus] = BankAccountStatus.UNSPECIFIED
    statements: Optional[List[AccountStatements]] = None
    type: Optional[BankAccountType] = BankAccountType.UNSPECIFIED
    plaid_account_type: Optional[StrictStr] = Field(default=None, alias="plaidAccountType")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "plaidAccountId", "accountNumber", "currentLateFee", "escrowBalance", "hasPmi", "hasPrepaymentPenalty", "lastPaymentAmount", "lastPaymentDate", "loanTerm", "loanTypeDescription", "maturityDate", "nextMonthlyPayment", "nextPaymentDueDate", "originalPrincipalBalance", "originalPropertyValue", "outstandingPrincipalBalance", "paymentAmount", "paymentDate", "originationDate", "originationPrincipalAmount", "pastDueAmount", "ytdInterestPaid", "ytdPrincipalPaid", "propertyAddressCity", "propertyAddressState", "propertyAddressStreet", "propertyAddressPostalCode", "propertyRegion", "propertyCountry", "interestRatePercentage", "interestRateType", "status", "statements", "type", "plaidAccountType", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MortgageAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in statements (list)
        _items = []
        if self.statements:
            for _item in self.statements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['statements'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MortgageAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "plaidAccountId": obj.get("plaidAccountId"),
            "accountNumber": obj.get("accountNumber"),
            "currentLateFee": obj.get("currentLateFee"),
            "escrowBalance": obj.get("escrowBalance"),
            "hasPmi": obj.get("hasPmi"),
            "hasPrepaymentPenalty": obj.get("hasPrepaymentPenalty"),
            "lastPaymentAmount": obj.get("lastPaymentAmount"),
            "lastPaymentDate": obj.get("lastPaymentDate"),
            "loanTerm": obj.get("loanTerm"),
            "loanTypeDescription": obj.get("loanTypeDescription"),
            "maturityDate": obj.get("maturityDate"),
            "nextMonthlyPayment": obj.get("nextMonthlyPayment"),
            "nextPaymentDueDate": obj.get("nextPaymentDueDate"),
            "originalPrincipalBalance": obj.get("originalPrincipalBalance"),
            "originalPropertyValue": obj.get("originalPropertyValue"),
            "outstandingPrincipalBalance": obj.get("outstandingPrincipalBalance"),
            "paymentAmount": obj.get("paymentAmount"),
            "paymentDate": obj.get("paymentDate"),
            "originationDate": obj.get("originationDate"),
            "originationPrincipalAmount": obj.get("originationPrincipalAmount"),
            "pastDueAmount": obj.get("pastDueAmount"),
            "ytdInterestPaid": obj.get("ytdInterestPaid"),
            "ytdPrincipalPaid": obj.get("ytdPrincipalPaid"),
            "propertyAddressCity": obj.get("propertyAddressCity"),
            "propertyAddressState": obj.get("propertyAddressState"),
            "propertyAddressStreet": obj.get("propertyAddressStreet"),
            "propertyAddressPostalCode": obj.get("propertyAddressPostalCode"),
            "propertyRegion": obj.get("propertyRegion"),
            "propertyCountry": obj.get("propertyCountry"),
            "interestRatePercentage": obj.get("interestRatePercentage"),
            "interestRateType": obj.get("interestRateType"),
            "status": obj.get("status") if obj.get("status") is not None else BankAccountStatus.UNSPECIFIED,
            "statements": [AccountStatements.from_dict(_item) for _item in obj["statements"]] if obj.get("statements") is not None else None,
            "type": obj.get("type") if obj.get("type") is not None else BankAccountType.UNSPECIFIED,
            "plaidAccountType": obj.get("plaidAccountType"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


