# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.financial_user_profile_type import FinancialUserProfileType
from typing import Optional, Set
from typing_extensions import Self

class MerchantMetricsFinancialSubProfile(BaseModel):
    """
    MerchantFinancialSubProfile This message is used to represent the financial sub profile of a merchant.
    """ # noqa: E501
    merchant_name: Optional[StrictStr] = Field(default=None, alias="merchantName")
    spent_last_week: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="spentLastWeek")
    spent_last_two_weeks: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="spentLastTwoWeeks")
    spent_last_month: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="spentLastMonth")
    spent_last_six_months: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="spentLastSixMonths")
    spent_last_year: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="spentLastYear")
    spent_last_two_years: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="spentLastTwoYears")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    month: Optional[StrictInt] = None
    profile_type: Optional[FinancialUserProfileType] = Field(default=FinancialUserProfileType.UNSPECIFIED, alias="profileType")
    __properties: ClassVar[List[str]] = ["merchantName", "spentLastWeek", "spentLastTwoWeeks", "spentLastMonth", "spentLastSixMonths", "spentLastYear", "spentLastTwoYears", "userId", "month", "profileType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MerchantMetricsFinancialSubProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MerchantMetricsFinancialSubProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "merchantName": obj.get("merchantName"),
            "spentLastWeek": obj.get("spentLastWeek"),
            "spentLastTwoWeeks": obj.get("spentLastTwoWeeks"),
            "spentLastMonth": obj.get("spentLastMonth"),
            "spentLastSixMonths": obj.get("spentLastSixMonths"),
            "spentLastYear": obj.get("spentLastYear"),
            "spentLastTwoYears": obj.get("spentLastTwoYears"),
            "userId": obj.get("userId"),
            "month": obj.get("month"),
            "profileType": obj.get("profileType") if obj.get("profileType") is not None else FinancialUserProfileType.UNSPECIFIED
        })
        return _obj


