# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.accounting_attachment import AccountingAttachment
from solomonai_backend_client_sdk.models.balance_sheet import BalanceSheet
from solomonai_backend_client_sdk.models.business_chart_of_account import BusinessChartOfAccount
from solomonai_backend_client_sdk.models.business_transaction import BusinessTransaction
from solomonai_backend_client_sdk.models.cash_flow_statement import CashFlowStatement
from solomonai_backend_client_sdk.models.company_info import CompanyInfo
from solomonai_backend_client_sdk.models.contacts import Contacts
from solomonai_backend_client_sdk.models.credit_note import CreditNote
from solomonai_backend_client_sdk.models.expense import Expense
from solomonai_backend_client_sdk.models.income_statement import IncomeStatement
from solomonai_backend_client_sdk.models.invoice import Invoice
from solomonai_backend_client_sdk.models.item import Item
from solomonai_backend_client_sdk.models.journal_entry import JournalEntry
from solomonai_backend_client_sdk.models.payment import Payment
from solomonai_backend_client_sdk.models.purchase_order import PurchaseOrder
from solomonai_backend_client_sdk.models.tax_rate import TaxRate
from solomonai_backend_client_sdk.models.vendor_credit import VendorCredit
from typing import Optional, Set
from typing_extensions import Self

class LinkedAccountingAccount(BaseModel):
    """
    LinkedAccountingAccount
    """ # noqa: E501
    id: Optional[StrictStr] = None
    attachments: Optional[List[AccountingAttachment]] = None
    company_info: Optional[List[CompanyInfo]] = Field(default=None, description="The CompanyInfo object is used to represent a company's information.", alias="companyInfo")
    purchase_orders: Optional[List[PurchaseOrder]] = Field(default=None, alias="purchaseOrders")
    balance_sheets: Optional[List[BalanceSheet]] = Field(default=None, alias="balanceSheets")
    cash_flow_statements: Optional[List[CashFlowStatement]] = Field(default=None, alias="cashFlowStatements")
    income_statements: Optional[List[IncomeStatement]] = Field(default=None, alias="incomeStatements")
    chart_of_accounts: Optional[List[BusinessChartOfAccount]] = Field(default=None, alias="chartOfAccounts")
    items: Optional[List[Item]] = None
    tax_rates: Optional[List[TaxRate]] = Field(default=None, alias="taxRates")
    contacts: Optional[List[Contacts]] = Field(default=None, description="The Contact object refers to either a supplier or a customer.")
    invoices: Optional[List[Invoice]] = None
    payments: Optional[List[Payment]] = None
    expenses: Optional[List[Expense]] = None
    journal_entries: Optional[List[JournalEntry]] = Field(default=None, alias="journalEntries")
    transactions: Optional[List[BusinessTransaction]] = None
    vendor_credits: Optional[List[VendorCredit]] = Field(default=None, alias="vendorCredits")
    credit_notes: Optional[List[CreditNote]] = Field(default=None, alias="creditNotes")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "attachments", "companyInfo", "purchaseOrders", "balanceSheets", "cashFlowStatements", "incomeStatements", "chartOfAccounts", "items", "taxRates", "contacts", "invoices", "payments", "expenses", "journalEntries", "transactions", "vendorCredits", "creditNotes", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LinkedAccountingAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in company_info (list)
        _items = []
        if self.company_info:
            for _item in self.company_info:
                if _item:
                    _items.append(_item.to_dict())
            _dict['companyInfo'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in purchase_orders (list)
        _items = []
        if self.purchase_orders:
            for _item in self.purchase_orders:
                if _item:
                    _items.append(_item.to_dict())
            _dict['purchaseOrders'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in balance_sheets (list)
        _items = []
        if self.balance_sheets:
            for _item in self.balance_sheets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['balanceSheets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cash_flow_statements (list)
        _items = []
        if self.cash_flow_statements:
            for _item in self.cash_flow_statements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cashFlowStatements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in income_statements (list)
        _items = []
        if self.income_statements:
            for _item in self.income_statements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['incomeStatements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in chart_of_accounts (list)
        _items = []
        if self.chart_of_accounts:
            for _item in self.chart_of_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['chartOfAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tax_rates (list)
        _items = []
        if self.tax_rates:
            for _item in self.tax_rates:
                if _item:
                    _items.append(_item.to_dict())
            _dict['taxRates'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in contacts (list)
        _items = []
        if self.contacts:
            for _item in self.contacts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['contacts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in invoices (list)
        _items = []
        if self.invoices:
            for _item in self.invoices:
                if _item:
                    _items.append(_item.to_dict())
            _dict['invoices'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item in self.payments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in expenses (list)
        _items = []
        if self.expenses:
            for _item in self.expenses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['expenses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in journal_entries (list)
        _items = []
        if self.journal_entries:
            for _item in self.journal_entries:
                if _item:
                    _items.append(_item.to_dict())
            _dict['journalEntries'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transactions (list)
        _items = []
        if self.transactions:
            for _item in self.transactions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vendor_credits (list)
        _items = []
        if self.vendor_credits:
            for _item in self.vendor_credits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['vendorCredits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credit_notes (list)
        _items = []
        if self.credit_notes:
            for _item in self.credit_notes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['creditNotes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LinkedAccountingAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "attachments": [AccountingAttachment.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None,
            "companyInfo": [CompanyInfo.from_dict(_item) for _item in obj["companyInfo"]] if obj.get("companyInfo") is not None else None,
            "purchaseOrders": [PurchaseOrder.from_dict(_item) for _item in obj["purchaseOrders"]] if obj.get("purchaseOrders") is not None else None,
            "balanceSheets": [BalanceSheet.from_dict(_item) for _item in obj["balanceSheets"]] if obj.get("balanceSheets") is not None else None,
            "cashFlowStatements": [CashFlowStatement.from_dict(_item) for _item in obj["cashFlowStatements"]] if obj.get("cashFlowStatements") is not None else None,
            "incomeStatements": [IncomeStatement.from_dict(_item) for _item in obj["incomeStatements"]] if obj.get("incomeStatements") is not None else None,
            "chartOfAccounts": [BusinessChartOfAccount.from_dict(_item) for _item in obj["chartOfAccounts"]] if obj.get("chartOfAccounts") is not None else None,
            "items": [Item.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "taxRates": [TaxRate.from_dict(_item) for _item in obj["taxRates"]] if obj.get("taxRates") is not None else None,
            "contacts": [Contacts.from_dict(_item) for _item in obj["contacts"]] if obj.get("contacts") is not None else None,
            "invoices": [Invoice.from_dict(_item) for _item in obj["invoices"]] if obj.get("invoices") is not None else None,
            "payments": [Payment.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "expenses": [Expense.from_dict(_item) for _item in obj["expenses"]] if obj.get("expenses") is not None else None,
            "journalEntries": [JournalEntry.from_dict(_item) for _item in obj["journalEntries"]] if obj.get("journalEntries") is not None else None,
            "transactions": [BusinessTransaction.from_dict(_item) for _item in obj["transactions"]] if obj.get("transactions") is not None else None,
            "vendorCredits": [VendorCredit.from_dict(_item) for _item in obj["vendorCredits"]] if obj.get("vendorCredits") is not None else None,
            "creditNotes": [CreditNote.from_dict(_item) for _item in obj["creditNotes"]] if obj.get("creditNotes") is not None else None,
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


