# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class JournalLine(BaseModel):
    """
    The JournalLine object is used to represent a journal entry's line items.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    account: Optional[StrictStr] = None
    net_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The value of the line item including taxes and other fees.  Might want to use double or a more precise type", alias="netAmount")
    tracking_category: Optional[StrictStr] = Field(default=None, alias="trackingCategory")
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    contact: Optional[StrictStr] = None
    company: Optional[StrictStr] = Field(default=None, description="The company the journal entry belongs to.")
    description: Optional[StrictStr] = Field(default=None, description="The line's description.")
    exchange_rate: Optional[StrictStr] = Field(default=None, description="The journal line item's exchange rate.  Assuming string due to the example provided, but could be float or double.", alias="exchangeRate")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "account", "netAmount", "trackingCategory", "trackingCategories", "contact", "company", "description", "exchangeRate", "modifiedAt", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JournalLine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JournalLine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "account": obj.get("account"),
            "netAmount": obj.get("netAmount"),
            "trackingCategory": obj.get("trackingCategory"),
            "trackingCategories": obj.get("trackingCategories"),
            "contact": obj.get("contact"),
            "company": obj.get("company"),
            "description": obj.get("description"),
            "exchangeRate": obj.get("exchangeRate"),
            "modifiedAt": obj.get("modifiedAt"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


