# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.journal_line import JournalLine
from typing import Optional, Set
from typing_extensions import Self

class JournalEntry(BaseModel):
    """
    A JournalEntry is a record of a transaction or event that is entered into a company's accounting system.  The JournalEntry common model contains records that are automatically created as a result of a certain type of transaction, like an Invoice, and records that are manually created against a company’s ledger.  The lines of a given JournalEntry object should always sum to 0. A positive net_amount means the line represents a debit and a negative net_amount represents a credit.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, alias="remoteId")
    transaction_date: Optional[datetime] = Field(default=None, description="The journal entry's transaction date.", alias="transactionDate")
    remote_created_at: Optional[datetime] = Field(default=None, description="When the third party's journal entry was created.", alias="remoteCreatedAt")
    remote_updated_at: Optional[datetime] = Field(default=None, alias="remoteUpdatedAt")
    payments: Optional[List[StrictStr]] = None
    memo: Optional[StrictStr] = Field(default=None, description="The journal entry's private note.")
    currency: Optional[StrictStr] = None
    exchange_rate: Optional[StrictStr] = Field(default=None, description="The journal entry's exchange rate.  Assuming string due to the example provided, but could be float or double.", alias="exchangeRate")
    company: Optional[StrictStr] = Field(default=None, description="The company the journal entry belongs to.")
    lines: Optional[List[JournalLine]] = Field(default=None, description="The JournalLine object is used to represent a journal entry's line items.")
    journal_number: Optional[StrictStr] = Field(default=None, description="Reference number for identifying journal entries.", alias="journalNumber")
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, alias="remoteWasDeleted")
    posting_status: Optional[StrictStr] = Field(default=None, alias="postingStatus")
    accounting_period: Optional[StrictStr] = Field(default=None, description="The accounting period that the JournalEntry was generated in.", alias="accountingPeriod")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    applied_payments: Optional[List[StrictStr]] = Field(default=None, description="A list of the Payment Applied to Lines common models related to a given Invoice, Credit Note, or Journal Entry.", alias="appliedPayments")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "transactionDate", "remoteCreatedAt", "remoteUpdatedAt", "payments", "memo", "currency", "exchangeRate", "company", "lines", "journalNumber", "trackingCategories", "remoteWasDeleted", "postingStatus", "accountingPeriod", "modifiedAt", "mergeRecordId", "appliedPayments", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JournalEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in lines (list)
        _items = []
        if self.lines:
            for _item in self.lines:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lines'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JournalEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "transactionDate": obj.get("transactionDate"),
            "remoteCreatedAt": obj.get("remoteCreatedAt"),
            "remoteUpdatedAt": obj.get("remoteUpdatedAt"),
            "payments": obj.get("payments"),
            "memo": obj.get("memo"),
            "currency": obj.get("currency"),
            "exchangeRate": obj.get("exchangeRate"),
            "company": obj.get("company"),
            "lines": [JournalLine.from_dict(_item) for _item in obj["lines"]] if obj.get("lines") is not None else None,
            "journalNumber": obj.get("journalNumber"),
            "trackingCategories": obj.get("trackingCategories"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "postingStatus": obj.get("postingStatus"),
            "accountingPeriod": obj.get("accountingPeriod"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "appliedPayments": obj.get("appliedPayments"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


