# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class InvoiceLineItem(BaseModel):
    """
    The Invoice object represents an itemized record of goods and/or services sold to a customer.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    description: Optional[StrictStr] = Field(default=None, description="The line item's description.")
    unit_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The line item's unit price.", alias="unitPrice")
    quantity: Optional[StrictInt] = Field(default=None, description="The line item's quantity.")
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The line item's total amount.", alias="totalAmount")
    currency: Optional[StrictStr] = None
    exchange_rate: Optional[StrictStr] = Field(default=None, description="The line item's exchange rate.", alias="exchangeRate")
    item: Optional[StrictStr] = None
    account: Optional[StrictStr] = None
    tracking_category: Optional[StrictStr] = Field(default=None, alias="trackingCategory")
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    company: Optional[StrictStr] = Field(default=None, description="The company the line item belongs to.")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    modified_at: Optional[datetime] = Field(default=None, description="Consider using google.protobuf.Timestamp", alias="modifiedAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "description", "unitPrice", "quantity", "totalAmount", "currency", "exchangeRate", "item", "account", "trackingCategory", "trackingCategories", "company", "mergeRecordId", "modifiedAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InvoiceLineItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InvoiceLineItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "description": obj.get("description"),
            "unitPrice": obj.get("unitPrice"),
            "quantity": obj.get("quantity"),
            "totalAmount": obj.get("totalAmount"),
            "currency": obj.get("currency"),
            "exchangeRate": obj.get("exchangeRate"),
            "item": obj.get("item"),
            "account": obj.get("account"),
            "trackingCategory": obj.get("trackingCategory"),
            "trackingCategories": obj.get("trackingCategories"),
            "company": obj.get("company"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "modifiedAt": obj.get("modifiedAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


