# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.error_response import ErrorResponse
from solomonai_backend_client_sdk.models.internal_error_code import InternalErrorCode
from solomonai_backend_client_sdk.models.operation_details import OperationDetails
from solomonai_backend_client_sdk.models.resource_utilization import ResourceUtilization
from solomonai_backend_client_sdk.models.service_status import ServiceStatus
from typing import Optional, Set
from typing_extensions import Self

class InternalErrorMessageResponse(BaseModel):
    """
    Represents internal server and system-level errors
    """ # noqa: E501
    code: Optional[InternalErrorCode] = InternalErrorCode.NO_INTERNAL_ERROR
    message: Optional[StrictStr] = None
    incident_id: Optional[StrictStr] = Field(default=None, alias="incidentId")
    service_status: Optional[ServiceStatus] = Field(default=None, alias="serviceStatus")
    resource_utilization: Optional[ResourceUtilization] = Field(default=None, alias="resourceUtilization")
    operation_details: Optional[OperationDetails] = Field(default=None, alias="operationDetails")
    error_response: Optional[ErrorResponse] = Field(default=None, alias="errorResponse")
    __properties: ClassVar[List[str]] = ["code", "message", "incidentId", "serviceStatus", "resourceUtilization", "operationDetails", "errorResponse"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InternalErrorMessageResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of service_status
        if self.service_status:
            _dict['serviceStatus'] = self.service_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resource_utilization
        if self.resource_utilization:
            _dict['resourceUtilization'] = self.resource_utilization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operation_details
        if self.operation_details:
            _dict['operationDetails'] = self.operation_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of error_response
        if self.error_response:
            _dict['errorResponse'] = self.error_response.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InternalErrorMessageResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code") if obj.get("code") is not None else InternalErrorCode.NO_INTERNAL_ERROR,
            "message": obj.get("message"),
            "incidentId": obj.get("incidentId"),
            "serviceStatus": ServiceStatus.from_dict(obj["serviceStatus"]) if obj.get("serviceStatus") is not None else None,
            "resourceUtilization": ResourceUtilization.from_dict(obj["resourceUtilization"]) if obj.get("resourceUtilization") is not None else None,
            "operationDetails": OperationDetails.from_dict(obj["operationDetails"]) if obj.get("operationDetails") is not None else None,
            "errorResponse": ErrorResponse.from_dict(obj["errorResponse"]) if obj.get("errorResponse") is not None else None
        })
        return _obj


