# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.comment_thread import CommentThread
from solomonai_backend_client_sdk.models.document_snapshot import DocumentSnapshot
from solomonai_backend_client_sdk.models.file_embeddings import FileEmbeddings
from solomonai_backend_client_sdk.models.file_sharing import FileSharing
from solomonai_backend_client_sdk.models.file_versions import FileVersions
from typing import Optional, Set
from typing_extensions import Self

class FileMetadata(BaseModel):
    """
    FileMetadata represents detailed information about a stored file. Tracks both basic file attributes and S3-specific metadata.  Key features: - Comprehensive S3 integration - Version control support - Content type handling - Access tracking - Preview generation  Storage considerations: - Files are stored in S3 with the specified key structure - Versioning is enabled when configured - Metadata is stored both in database and S3  Security features: - ACL controls - Server-side encryption - Tenant isolation
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    size: Optional[StrictStr] = None
    file_type: Optional[StrictStr] = Field(default=None, alias="fileType")
    tags: Optional[List[StrictStr]] = None
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted")
    version: Optional[StrictInt] = None
    s3_key: Optional[StrictStr] = Field(default=None, description="Full path within bucket", alias="s3Key")
    s3_bucket_name: Optional[StrictStr] = Field(default=None, alias="s3BucketName")
    s3_region: Optional[StrictStr] = Field(default=None, alias="s3Region")
    s3_version_id: Optional[StrictStr] = Field(default=None, alias="s3VersionId")
    s3_etag: Optional[StrictStr] = Field(default=None, alias="s3Etag")
    s3_content_type: Optional[StrictStr] = Field(default=None, alias="s3ContentType")
    s3_content_length: Optional[StrictStr] = Field(default=None, alias="s3ContentLength")
    s3_content_encoding: Optional[StrictStr] = Field(default=None, alias="s3ContentEncoding")
    s3_content_disposition: Optional[StrictStr] = Field(default=None, alias="s3ContentDisposition")
    s3_last_modified: Optional[datetime] = Field(default=None, alias="s3LastModified")
    s3_storage_class: Optional[StrictStr] = Field(default=None, alias="s3StorageClass")
    s3_server_side_encryption: Optional[StrictStr] = Field(default=None, alias="s3ServerSideEncryption")
    s3_acl: Optional[StrictStr] = Field(default=None, alias="s3Acl")
    s3_metadata: Optional[Dict[str, StrictStr]] = Field(default=None, alias="s3Metadata")
    version_id: Optional[StrictStr] = Field(default=None, description="Internal version ID", alias="versionId")
    upload_id: Optional[StrictStr] = Field(default=None, alias="uploadId")
    location: Optional[StrictStr] = Field(default=None, description="File location/path")
    markdown_content: Optional[StrictStr] = Field(default=None, alias="markdownContent")
    mime_type: Optional[StrictStr] = Field(default=None, alias="mimeType")
    checksum: Optional[StrictStr] = None
    preview_available: Optional[StrictBool] = Field(default=None, description="Preview status", alias="previewAvailable")
    preview_status: Optional[StrictStr] = Field(default=None, alias="previewStatus")
    thumbnail_url: Optional[StrictStr] = Field(default=None, alias="thumbnailUrl")
    last_accessed: Optional[datetime] = Field(default=None, alias="lastAccessed")
    access_count: Optional[StrictInt] = Field(default=None, alias="accessCount")
    embeddings: Optional[FileEmbeddings] = None
    versions: Optional[List[FileVersions]] = None
    comment_threads: Optional[List[CommentThread]] = Field(default=None, alias="commentThreads")
    shared_links: Optional[List[FileSharing]] = Field(default=None, alias="sharedLinks")
    snapshots: Optional[List[DocumentSnapshot]] = None
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "name", "createdAt", "updatedAt", "size", "fileType", "tags", "isDeleted", "version", "s3Key", "s3BucketName", "s3Region", "s3VersionId", "s3Etag", "s3ContentType", "s3ContentLength", "s3ContentEncoding", "s3ContentDisposition", "s3LastModified", "s3StorageClass", "s3ServerSideEncryption", "s3Acl", "s3Metadata", "versionId", "uploadId", "location", "markdownContent", "mimeType", "checksum", "previewAvailable", "previewStatus", "thumbnailUrl", "lastAccessed", "accessCount", "embeddings", "versions", "commentThreads", "sharedLinks", "snapshots", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of embeddings
        if self.embeddings:
            _dict['embeddings'] = self.embeddings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in versions (list)
        _items = []
        if self.versions:
            for _item in self.versions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['versions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in comment_threads (list)
        _items = []
        if self.comment_threads:
            for _item in self.comment_threads:
                if _item:
                    _items.append(_item.to_dict())
            _dict['commentThreads'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shared_links (list)
        _items = []
        if self.shared_links:
            for _item in self.shared_links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sharedLinks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in snapshots (list)
        _items = []
        if self.snapshots:
            for _item in self.snapshots:
                if _item:
                    _items.append(_item.to_dict())
            _dict['snapshots'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "size": obj.get("size"),
            "fileType": obj.get("fileType"),
            "tags": obj.get("tags"),
            "isDeleted": obj.get("isDeleted"),
            "version": obj.get("version"),
            "s3Key": obj.get("s3Key"),
            "s3BucketName": obj.get("s3BucketName"),
            "s3Region": obj.get("s3Region"),
            "s3VersionId": obj.get("s3VersionId"),
            "s3Etag": obj.get("s3Etag"),
            "s3ContentType": obj.get("s3ContentType"),
            "s3ContentLength": obj.get("s3ContentLength"),
            "s3ContentEncoding": obj.get("s3ContentEncoding"),
            "s3ContentDisposition": obj.get("s3ContentDisposition"),
            "s3LastModified": obj.get("s3LastModified"),
            "s3StorageClass": obj.get("s3StorageClass"),
            "s3ServerSideEncryption": obj.get("s3ServerSideEncryption"),
            "s3Acl": obj.get("s3Acl"),
            "s3Metadata": obj.get("s3Metadata"),
            "versionId": obj.get("versionId"),
            "uploadId": obj.get("uploadId"),
            "location": obj.get("location"),
            "markdownContent": obj.get("markdownContent"),
            "mimeType": obj.get("mimeType"),
            "checksum": obj.get("checksum"),
            "previewAvailable": obj.get("previewAvailable"),
            "previewStatus": obj.get("previewStatus"),
            "thumbnailUrl": obj.get("thumbnailUrl"),
            "lastAccessed": obj.get("lastAccessed"),
            "accessCount": obj.get("accessCount"),
            "embeddings": FileEmbeddings.from_dict(obj["embeddings"]) if obj.get("embeddings") is not None else None,
            "versions": [FileVersions.from_dict(_item) for _item in obj["versions"]] if obj.get("versions") is not None else None,
            "commentThreads": [CommentThread.from_dict(_item) for _item in obj["commentThreads"]] if obj.get("commentThreads") is not None else None,
            "sharedLinks": [FileSharing.from_dict(_item) for _item in obj["sharedLinks"]] if obj.get("sharedLinks") is not None else None,
            "snapshots": [DocumentSnapshot.from_dict(_item) for _item in obj["snapshots"]] if obj.get("snapshots") is not None else None,
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


