# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.employee_payroll_run import EmployeePayrollRun
from solomonai_backend_client_sdk.models.payroll_run_state import PayrollRunState
from solomonai_backend_client_sdk.models.payroll_run_type import PayrollRunType
from typing import Optional, Set
from typing_extensions import Self

class EmployerPayrollRun(BaseModel):
    """
    The EmployerPayrollRun object is used to represent a group of pay statements for a specific pay schedule.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    run_state: Optional[PayrollRunState] = Field(default=PayrollRunState.UNSPECIFIED, alias="runState")
    run_type: Optional[PayrollRunType] = Field(default=PayrollRunType.UNSPECIFIED, alias="runType")
    start_date: Optional[datetime] = Field(default=None, description="The day and time the payroll run started.", alias="startDate")
    end_date: Optional[datetime] = Field(default=None, description="The day and time the payroll run ended.", alias="endDate")
    check_date: Optional[datetime] = Field(default=None, description="The day and time the payroll run was checked.", alias="checkDate")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, alias="remoteWasDeleted")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    payroll_runs: Optional[List[EmployeePayrollRun]] = Field(default=None, alias="payrollRuns")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "runState", "runType", "startDate", "endDate", "checkDate", "remoteWasDeleted", "createdAt", "modifiedAt", "payrollRuns", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmployerPayrollRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in payroll_runs (list)
        _items = []
        if self.payroll_runs:
            for _item in self.payroll_runs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['payrollRuns'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmployerPayrollRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "runState": obj.get("runState") if obj.get("runState") is not None else PayrollRunState.UNSPECIFIED,
            "runType": obj.get("runType") if obj.get("runType") is not None else PayrollRunType.UNSPECIFIED,
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "checkDate": obj.get("checkDate"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "createdAt": obj.get("createdAt"),
            "modifiedAt": obj.get("modifiedAt"),
            "payrollRuns": [EmployeePayrollRun.from_dict(_item) for _item in obj["payrollRuns"]] if obj.get("payrollRuns") is not None else None,
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


