# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.community_profile import CommunityProfile
from solomonai_backend_client_sdk.models.topic import Topic
from solomonai_backend_client_sdk.models.user_profile import UserProfile
from typing import Optional, Set
from typing_extensions import Self

class DiscoverProfilesResponse(BaseModel):
    """
    DiscoverProfilesResponse
    """ # noqa: E501
    community_profiles: Optional[List[CommunityProfile]] = Field(default=None, alias="communityProfiles")
    user_profiles: Optional[List[UserProfile]] = Field(default=None, alias="userProfiles")
    topics: Optional[List[Topic]] = None
    __properties: ClassVar[List[str]] = ["communityProfiles", "userProfiles", "topics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DiscoverProfilesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in community_profiles (list)
        _items = []
        if self.community_profiles:
            for _item in self.community_profiles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['communityProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in user_profiles (list)
        _items = []
        if self.user_profiles:
            for _item in self.user_profiles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['userProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in topics (list)
        _items = []
        if self.topics:
            for _item in self.topics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['topics'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DiscoverProfilesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "communityProfiles": [CommunityProfile.from_dict(_item) for _item in obj["communityProfiles"]] if obj.get("communityProfiles") is not None else None,
            "userProfiles": [UserProfile.from_dict(_item) for _item in obj["userProfiles"]] if obj.get("userProfiles") is not None else None,
            "topics": [Topic.from_dict(_item) for _item in obj["topics"]] if obj.get("topics") is not None else None
        })
        return _obj


