# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.address import Address
from solomonai_backend_client_sdk.models.role import Role
from solomonai_backend_client_sdk.models.team import Team
from solomonai_backend_client_sdk.models.team_member import TeamMember
from typing import Optional, Set
from typing_extensions import Self

class CreateTenantTeamRequest(BaseModel):
    """
    CreateTenantTeamRequest
    """ # noqa: E501
    organization_id: StrictStr = Field(alias="organizationId")
    tenant_id: StrictStr = Field(alias="tenantId")
    team: Optional[Team] = None
    business_account_team_admin_id: StrictStr = Field(alias="businessAccountTeamAdminId")
    team_members: Optional[List[TeamMember]] = Field(default=None, alias="teamMembers")
    roles: Optional[List[Role]] = None
    addresses: Optional[List[Address]] = None
    __properties: ClassVar[List[str]] = ["organizationId", "tenantId", "team", "businessAccountTeamAdminId", "teamMembers", "roles", "addresses"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateTenantTeamRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of team
        if self.team:
            _dict['team'] = self.team.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in team_members (list)
        _items = []
        if self.team_members:
            for _item in self.team_members:
                if _item:
                    _items.append(_item.to_dict())
            _dict['teamMembers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in roles (list)
        _items = []
        if self.roles:
            for _item in self.roles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['roles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in addresses (list)
        _items = []
        if self.addresses:
            for _item in self.addresses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['addresses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateTenantTeamRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "organizationId": obj.get("organizationId"),
            "tenantId": obj.get("tenantId"),
            "team": Team.from_dict(obj["team"]) if obj.get("team") is not None else None,
            "businessAccountTeamAdminId": obj.get("businessAccountTeamAdminId"),
            "teamMembers": [TeamMember.from_dict(_item) for _item in obj["teamMembers"]] if obj.get("teamMembers") is not None else None,
            "roles": [Role.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None,
            "addresses": [Address.from_dict(_item) for _item in obj["addresses"]] if obj.get("addresses") is not None else None
        })
        return _obj


