# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.topic import Topic
from typing import Optional, Set
from typing_extensions import Self

class CommunityProfile(BaseModel):
    """
    CommunityProfile
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: StrictStr
    description: StrictStr
    private: StrictBool
    visible: StrictBool
    followers: StrictStr
    community_rules: StrictStr = Field(alias="communityRules")
    topics: Optional[List[Topic]] = None
    notification_feed_timeline_id: StrictStr = Field(alias="notificationFeedTimelineId")
    personal_feed_timeline_id: StrictStr = Field(alias="personalFeedTimelineId")
    news_feed_timeline_id: StrictStr = Field(alias="newsFeedTimelineId")
    profile_image_url: StrictStr = Field(alias="profileImageUrl")
    algolia_id: StrictStr = Field(alias="algoliaId")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "private", "visible", "followers", "communityRules", "topics", "notificationFeedTimelineId", "personalFeedTimelineId", "newsFeedTimelineId", "profileImageUrl", "algoliaId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommunityProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in topics (list)
        _items = []
        if self.topics:
            for _item in self.topics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['topics'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommunityProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "private": obj.get("private"),
            "visible": obj.get("visible"),
            "followers": obj.get("followers"),
            "communityRules": obj.get("communityRules"),
            "topics": [Topic.from_dict(_item) for _item in obj["topics"]] if obj.get("topics") is not None else None,
            "notificationFeedTimelineId": obj.get("notificationFeedTimelineId"),
            "personalFeedTimelineId": obj.get("personalFeedTimelineId"),
            "newsFeedTimelineId": obj.get("newsFeedTimelineId"),
            "profileImageUrl": obj.get("profileImageUrl"),
            "algoliaId": obj.get("algoliaId")
        })
        return _obj


