# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.comment1 import Comment1
from typing import Optional, Set
from typing_extensions import Self

class CommentThread(BaseModel):
    """
    CommentThread represents a thread of comments on a file. Anchored to specific positions in the document using Tiptap's node positions.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    file_id: Optional[StrictStr] = Field(default=None, alias="fileId")
    root_comment: Optional[Comment1] = Field(default=None, alias="rootComment")
    replies: Optional[List[Comment1]] = None
    status: Optional[StrictStr] = None
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    var_from: Optional[StrictInt] = Field(default=None, description="Start position of the comment anchor", alias="from")
    to: Optional[StrictInt] = None
    version_id: Optional[StrictStr] = Field(default=None, alias="versionId")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "fileId", "rootComment", "replies", "status", "createdAt", "updatedAt", "from", "to", "versionId", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommentThread from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of root_comment
        if self.root_comment:
            _dict['rootComment'] = self.root_comment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in replies (list)
        _items = []
        if self.replies:
            for _item in self.replies:
                if _item:
                    _items.append(_item.to_dict())
            _dict['replies'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommentThread from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "fileId": obj.get("fileId"),
            "rootComment": Comment1.from_dict(obj["rootComment"]) if obj.get("rootComment") is not None else None,
            "replies": [Comment1.from_dict(_item) for _item in obj["replies"]] if obj.get("replies") is not None else None,
            "status": obj.get("status"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "from": obj.get("from"),
            "to": obj.get("to"),
            "versionId": obj.get("versionId"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


