# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.transaction_line_item import TransactionLineItem
from typing import Optional, Set
from typing_extensions import Self

class BusinessTransaction(BaseModel):
    """
    * Credit Notes * Expenses * Invoices * Journal Entries * Payments * Purchase Orders * Vendor Credits
    """ # noqa: E501
    id: Optional[StrictStr] = None
    transaction_type: Optional[StrictStr] = Field(default=None, description="The type of transaction, which can by any transaction object not already included in Merge’s common model.", alias="transactionType")
    number: Optional[StrictStr] = Field(default=None, description="The transaction's number used for identifying purposes.")
    transaction_date: Optional[datetime] = Field(default=None, description="The date upon which the transaction occurred.", alias="transactionDate")
    account: Optional[StrictStr] = Field(default=None, description="The transaction's account.")
    contact: Optional[StrictStr] = Field(default=None, description="The contact to whom the transaction relates to.")
    total_amount: Optional[StrictStr] = Field(default=None, description="The total amount being paid after taxes.  Might be better as double.", alias="totalAmount")
    currency: Optional[StrictStr] = None
    exchange_rate: Optional[StrictStr] = Field(default=None, description="The transaction's exchange rate.  Assuming string, but might be better as float or double.", alias="exchangeRate")
    company: Optional[StrictStr] = Field(default=None, description="The company the transaction belongs to.")
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    line_items: Optional[List[TransactionLineItem]] = Field(default=None, alias="lineItems")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted in the third party platform.", alias="remoteWasDeleted")
    accounting_period: Optional[StrictStr] = Field(default=None, description="The accounting period that the Transaction was generated in.", alias="accountingPeriod")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    remote_id: Optional[StrictStr] = Field(default=None, alias="remoteId")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "transactionType", "number", "transactionDate", "account", "contact", "totalAmount", "currency", "exchangeRate", "company", "trackingCategories", "lineItems", "remoteWasDeleted", "accountingPeriod", "mergeRecordId", "remoteId", "modifiedAt", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusinessTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item in self.line_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lineItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusinessTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "transactionType": obj.get("transactionType"),
            "number": obj.get("number"),
            "transactionDate": obj.get("transactionDate"),
            "account": obj.get("account"),
            "contact": obj.get("contact"),
            "totalAmount": obj.get("totalAmount"),
            "currency": obj.get("currency"),
            "exchangeRate": obj.get("exchangeRate"),
            "company": obj.get("company"),
            "trackingCategories": obj.get("trackingCategories"),
            "lineItems": [TransactionLineItem.from_dict(_item) for _item in obj["lineItems"]] if obj.get("lineItems") is not None else None,
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "accountingPeriod": obj.get("accountingPeriod"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "remoteId": obj.get("remoteId"),
            "modifiedAt": obj.get("modifiedAt"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


