# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.report_item import ReportItem
from typing import Optional, Set
from typing_extensions import Self

class BalanceSheet(BaseModel):
    """
    The BalanceSheet object shows a company’s assets, liabilities, and equity. Assets should be equal to liability and equity combined.  This shows the company’s financial health at a specific point in time.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    name: Optional[StrictStr] = Field(default=None, description="The balance sheet's name.")
    currency: Optional[StrictStr] = None
    company: Optional[StrictStr] = None
    var_date: Optional[datetime] = Field(default=None, description="The balance sheet's date. The balance sheet data will  reflect the company's financial position this point in time.  Consider using google.protobuf.Timestamp", alias="date")
    net_assets: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The balance sheet's net assets.", alias="netAssets")
    assets: Optional[List[ReportItem]] = Field(default=None, description="The balance sheet's total assets.")
    liabilities: Optional[List[ReportItem]] = Field(default=None, description="The balance sheet's total liabilities.")
    equity: Optional[List[ReportItem]] = Field(default=None, description="The balance sheet's total equity.")
    remote_generated_at: Optional[datetime] = Field(default=None, description="The time that balance sheet was generated by the accounting system.  Consider using google.protobuf.Timestamp", alias="remoteGeneratedAt")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted by third party webhooks.", alias="remoteWasDeleted")
    modified_at: Optional[datetime] = Field(default=None, description="Consider using google.protobuf.Timestamp", alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "name", "currency", "company", "date", "netAssets", "assets", "liabilities", "equity", "remoteGeneratedAt", "remoteWasDeleted", "modifiedAt", "mergeRecordId", "createdAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BalanceSheet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assets (list)
        _items = []
        if self.assets:
            for _item in self.assets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['assets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in liabilities (list)
        _items = []
        if self.liabilities:
            for _item in self.liabilities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['liabilities'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in equity (list)
        _items = []
        if self.equity:
            for _item in self.equity:
                if _item:
                    _items.append(_item.to_dict())
            _dict['equity'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BalanceSheet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "name": obj.get("name"),
            "currency": obj.get("currency"),
            "company": obj.get("company"),
            "date": obj.get("date"),
            "netAssets": obj.get("netAssets"),
            "assets": [ReportItem.from_dict(_item) for _item in obj["assets"]] if obj.get("assets") is not None else None,
            "liabilities": [ReportItem.from_dict(_item) for _item in obj["liabilities"]] if obj.get("liabilities") is not None else None,
            "equity": [ReportItem.from_dict(_item) for _item in obj["equity"]] if obj.get("equity") is not None else None,
            "remoteGeneratedAt": obj.get("remoteGeneratedAt"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "createdAt": obj.get("createdAt")
        })
        return _obj


