# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.workspace import Workspace
from typing import Optional, Set
from typing_extensions import Self

class Account(BaseModel):
    """
    Account represents a user account within the workspace service. It serves as the top-level container for all user-specific workspaces and settings.  Usage example: ```go account := &Account{   Auth0UserId: \"auth0|123\",   BaseDirectory: \"/users/123\",   BucketName: \"user-123-storage\" } ```  Key features: - Unique identification via Auth0 - S3 storage configuration - Workspace management - Resource organization
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the account.")
    auth0_user_id: Optional[StrictStr] = Field(default=None, alias="auth0UserId")
    workspace: Optional[List[Workspace]] = None
    base_directory: Optional[StrictStr] = Field(default=None, alias="baseDirectory")
    bucket_name: Optional[StrictStr] = Field(default=None, alias="bucketName")
    bucket_location: Optional[StrictStr] = Field(default=None, alias="bucketLocation")
    region: Optional[StrictStr] = None
    org_id: Optional[StrictStr] = Field(default=None, alias="orgId")
    tenant_id: Optional[StrictStr] = Field(default=None, alias="tenantId")
    last_modified_at: Optional[datetime] = Field(default=None, alias="lastModifiedAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    email: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "auth0UserId", "workspace", "baseDirectory", "bucketName", "bucketLocation", "region", "orgId", "tenantId", "lastModifiedAt", "deletedAt", "createdAt", "email"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Account from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in workspace (list)
        _items = []
        if self.workspace:
            for _item in self.workspace:
                if _item:
                    _items.append(_item.to_dict())
            _dict['workspace'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Account from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "auth0UserId": obj.get("auth0UserId"),
            "workspace": [Workspace.from_dict(_item) for _item in obj["workspace"]] if obj.get("workspace") is not None else None,
            "baseDirectory": obj.get("baseDirectory"),
            "bucketName": obj.get("bucketName"),
            "bucketLocation": obj.get("bucketLocation"),
            "region": obj.get("region"),
            "orgId": obj.get("orgId"),
            "tenantId": obj.get("tenantId"),
            "lastModifiedAt": obj.get("lastModifiedAt"),
            "deletedAt": obj.get("deletedAt"),
            "createdAt": obj.get("createdAt"),
            "email": obj.get("email")
        })
        return _obj


