# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from solomonai_backend_client_sdk.models.add_default_pockets_to_bank_account_request import AddDefaultPocketsToBankAccountRequest
from solomonai_backend_client_sdk.models.add_default_pockets_to_bank_account_response import AddDefaultPocketsToBankAccountResponse
from solomonai_backend_client_sdk.models.add_note_to_financial_user_profile_request import AddNoteToFinancialUserProfileRequest
from solomonai_backend_client_sdk.models.add_note_to_financial_user_profile_response import AddNoteToFinancialUserProfileResponse
from solomonai_backend_client_sdk.models.add_note_to_recurring_transaction_request import AddNoteToRecurringTransactionRequest
from solomonai_backend_client_sdk.models.add_note_to_recurring_transaction_response import AddNoteToRecurringTransactionResponse
from solomonai_backend_client_sdk.models.add_note_to_smart_goal_request import AddNoteToSmartGoalRequest
from solomonai_backend_client_sdk.models.add_note_to_smart_goal_response import AddNoteToSmartGoalResponse
from solomonai_backend_client_sdk.models.add_note_to_transaction_request import AddNoteToTransactionRequest
from solomonai_backend_client_sdk.models.add_note_to_transaction_response import AddNoteToTransactionResponse
from solomonai_backend_client_sdk.models.add_transactions_to_manually_linked_account_request import AddTransactionsToManuallyLinkedAccountRequest
from solomonai_backend_client_sdk.models.add_transactions_to_manually_linked_account_response import AddTransactionsToManuallyLinkedAccountResponse
from solomonai_backend_client_sdk.models.bulk_update_recurring_transaction_request import BulkUpdateRecurringTransactionRequest
from solomonai_backend_client_sdk.models.bulk_update_recurring_transaction_response import BulkUpdateRecurringTransactionResponse
from solomonai_backend_client_sdk.models.bulk_update_transaction_request import BulkUpdateTransactionRequest
from solomonai_backend_client_sdk.models.bulk_update_transaction_response import BulkUpdateTransactionResponse
from solomonai_backend_client_sdk.models.check_if_quota_exceeded_response import CheckIfQuotaExceededResponse
from solomonai_backend_client_sdk.models.create_bank_account_request import CreateBankAccountRequest
from solomonai_backend_client_sdk.models.create_bank_account_response import CreateBankAccountResponse
from solomonai_backend_client_sdk.models.create_budget_request import CreateBudgetRequest
from solomonai_backend_client_sdk.models.create_budget_response import CreateBudgetResponse
from solomonai_backend_client_sdk.models.create_credit_account_request import CreateCreditAccountRequest
from solomonai_backend_client_sdk.models.create_credit_account_response import CreateCreditAccountResponse
from solomonai_backend_client_sdk.models.create_manual_link_request import CreateManualLinkRequest
from solomonai_backend_client_sdk.models.create_manual_link_response import CreateManualLinkResponse
from solomonai_backend_client_sdk.models.create_milestone_request import CreateMilestoneRequest
from solomonai_backend_client_sdk.models.create_milestone_response import CreateMilestoneResponse
from solomonai_backend_client_sdk.models.create_smart_goal_request import CreateSmartGoalRequest
from solomonai_backend_client_sdk.models.create_smart_goal_response import CreateSmartGoalResponse
from solomonai_backend_client_sdk.models.create_subscription_request import CreateSubscriptionRequest
from solomonai_backend_client_sdk.models.create_subscription_response import CreateSubscriptionResponse
from solomonai_backend_client_sdk.models.create_user_profile_request1 import CreateUserProfileRequest1
from solomonai_backend_client_sdk.models.create_user_profile_response1 import CreateUserProfileResponse1
from solomonai_backend_client_sdk.models.delete_bank_account_response import DeleteBankAccountResponse
from solomonai_backend_client_sdk.models.delete_budget_response import DeleteBudgetResponse
from solomonai_backend_client_sdk.models.delete_link_response import DeleteLinkResponse
from solomonai_backend_client_sdk.models.delete_milestone_response import DeleteMilestoneResponse
from solomonai_backend_client_sdk.models.delete_note_from_recurring_transaction_response import DeleteNoteFromRecurringTransactionResponse
from solomonai_backend_client_sdk.models.delete_note_from_smart_goal_response import DeleteNoteFromSmartGoalResponse
from solomonai_backend_client_sdk.models.delete_note_from_transaction_response import DeleteNoteFromTransactionResponse
from solomonai_backend_client_sdk.models.delete_pocket_response import DeletePocketResponse
from solomonai_backend_client_sdk.models.delete_recurring_transaction_response import DeleteRecurringTransactionResponse
from solomonai_backend_client_sdk.models.delete_smart_goal_response import DeleteSmartGoalResponse
from solomonai_backend_client_sdk.models.delete_transaction_response import DeleteTransactionResponse
from solomonai_backend_client_sdk.models.delete_user_profile_response1 import DeleteUserProfileResponse1
from solomonai_backend_client_sdk.models.get_account_balance_history_response import GetAccountBalanceHistoryResponse
from solomonai_backend_client_sdk.models.get_all_budgets_response import GetAllBudgetsResponse
from solomonai_backend_client_sdk.models.get_bank_account_response import GetBankAccountResponse
from solomonai_backend_client_sdk.models.get_budget_response import GetBudgetResponse
from solomonai_backend_client_sdk.models.get_category_metrics_financial_sub_profile_over_time_response import GetCategoryMetricsFinancialSubProfileOverTimeResponse
from solomonai_backend_client_sdk.models.get_category_monthly_transaction_count_response import GetCategoryMonthlyTransactionCountResponse
from solomonai_backend_client_sdk.models.get_debt_to_income_ratio_response import GetDebtToIncomeRatioResponse
from solomonai_backend_client_sdk.models.get_expense_metrics_financial_sub_profile_over_time_response import GetExpenseMetricsFinancialSubProfileOverTimeResponse
from solomonai_backend_client_sdk.models.get_expense_metrics_response import GetExpenseMetricsResponse
from solomonai_backend_client_sdk.models.get_financial_profile_response import GetFinancialProfileResponse
from solomonai_backend_client_sdk.models.get_forecast_response import GetForecastResponse
from solomonai_backend_client_sdk.models.get_historical_account_balance_response import GetHistoricalAccountBalanceResponse
from solomonai_backend_client_sdk.models.get_income_expense_ratio_response import GetIncomeExpenseRatioResponse
from solomonai_backend_client_sdk.models.get_income_metrics_financial_sub_profile_over_time_response import GetIncomeMetricsFinancialSubProfileOverTimeResponse
from solomonai_backend_client_sdk.models.get_income_metrics_response import GetIncomeMetricsResponse
from solomonai_backend_client_sdk.models.get_investment_acccount_response import GetInvestmentAcccountResponse
from solomonai_backend_client_sdk.models.get_liability_account_response import GetLiabilityAccountResponse
from solomonai_backend_client_sdk.models.get_link_response import GetLinkResponse
from solomonai_backend_client_sdk.models.get_links_response import GetLinksResponse
from solomonai_backend_client_sdk.models.get_location_metrics_financial_sub_profile_over_time_response import GetLocationMetricsFinancialSubProfileOverTimeResponse
from solomonai_backend_client_sdk.models.get_melody_financial_context_response import GetMelodyFinancialContextResponse
from solomonai_backend_client_sdk.models.get_merchant_metrics_financial_sub_profile_over_time_response import GetMerchantMetricsFinancialSubProfileOverTimeResponse
from solomonai_backend_client_sdk.models.get_merchant_monthly_expenditure_response import GetMerchantMonthlyExpenditureResponse
from solomonai_backend_client_sdk.models.get_milestone_response import GetMilestoneResponse
from solomonai_backend_client_sdk.models.get_milestones_by_smart_goal_id_response import GetMilestonesBySmartGoalIdResponse
from solomonai_backend_client_sdk.models.get_monthly_balance_response import GetMonthlyBalanceResponse
from solomonai_backend_client_sdk.models.get_monthly_expenditure_response import GetMonthlyExpenditureResponse
from solomonai_backend_client_sdk.models.get_monthly_income_response import GetMonthlyIncomeResponse
from solomonai_backend_client_sdk.models.get_monthly_savings_response import GetMonthlySavingsResponse
from solomonai_backend_client_sdk.models.get_monthly_total_quantity_by_security_and_user_response import GetMonthlyTotalQuantityBySecurityAndUserResponse
from solomonai_backend_client_sdk.models.get_monthly_transaction_count_response import GetMonthlyTransactionCountResponse
from solomonai_backend_client_sdk.models.get_mortgage_account_response import GetMortgageAccountResponse
from solomonai_backend_client_sdk.models.get_note_from_smart_goal_response import GetNoteFromSmartGoalResponse
from solomonai_backend_client_sdk.models.get_note_from_transaction_response import GetNoteFromTransactionResponse
from solomonai_backend_client_sdk.models.get_notes_from_financial_user_profile_response import GetNotesFromFinancialUserProfileResponse
from solomonai_backend_client_sdk.models.get_notes_from_smart_goal_response import GetNotesFromSmartGoalResponse
from solomonai_backend_client_sdk.models.get_payment_channel_financial_sub_profile_over_time_response import GetPaymentChannelFinancialSubProfileOverTimeResponse
from solomonai_backend_client_sdk.models.get_payment_channel_monthly_expenditure_response import GetPaymentChannelMonthlyExpenditureResponse
from solomonai_backend_client_sdk.models.get_pocket_response import GetPocketResponse
from solomonai_backend_client_sdk.models.get_recurring_transactions_for_user_response import GetRecurringTransactionsForUserResponse
from solomonai_backend_client_sdk.models.get_single_recurring_transaction_response import GetSingleRecurringTransactionResponse
from solomonai_backend_client_sdk.models.get_smart_goals_by_pocket_id_response import GetSmartGoalsByPocketIdResponse
from solomonai_backend_client_sdk.models.get_split_transaction_response import GetSplitTransactionResponse
from solomonai_backend_client_sdk.models.get_student_loan_account_response import GetStudentLoanAccountResponse
from solomonai_backend_client_sdk.models.get_total_investment_by_security_response import GetTotalInvestmentBySecurityResponse
from solomonai_backend_client_sdk.models.get_transaction_aggregates_response import GetTransactionAggregatesResponse
from solomonai_backend_client_sdk.models.get_transaction_response import GetTransactionResponse
from solomonai_backend_client_sdk.models.get_transactions_between_time_ranges_response import GetTransactionsBetweenTimeRangesResponse
from solomonai_backend_client_sdk.models.get_transactions_for_bank_account_response import GetTransactionsForBankAccountResponse
from solomonai_backend_client_sdk.models.get_transactions_for_past_month_response import GetTransactionsForPastMonthResponse
from solomonai_backend_client_sdk.models.get_transactions_for_past_week_response import GetTransactionsForPastWeekResponse
from solomonai_backend_client_sdk.models.get_transactions_response import GetTransactionsResponse
from solomonai_backend_client_sdk.models.get_user_account_balance_history_response import GetUserAccountBalanceHistoryResponse
from solomonai_backend_client_sdk.models.get_user_category_monthly_expenditure_response import GetUserCategoryMonthlyExpenditureResponse
from solomonai_backend_client_sdk.models.get_user_category_monthly_income_response import GetUserCategoryMonthlyIncomeResponse
from solomonai_backend_client_sdk.models.get_user_profile_response1 import GetUserProfileResponse1
from solomonai_backend_client_sdk.models.health_check_response import HealthCheckResponse
from solomonai_backend_client_sdk.models.list_recurring_transaction_notes_response import ListRecurringTransactionNotesResponse
from solomonai_backend_client_sdk.models.list_recurring_transactions_for_user_and_account_response import ListRecurringTransactionsForUserAndAccountResponse
from solomonai_backend_client_sdk.models.list_transaction_notes_response import ListTransactionNotesResponse
from solomonai_backend_client_sdk.models.list_transactions_across_all_accounts_response import ListTransactionsAcrossAllAccountsResponse
from solomonai_backend_client_sdk.models.list_transactions_response import ListTransactionsResponse
from solomonai_backend_client_sdk.models.plaid_exchange_token_request import PlaidExchangeTokenRequest
from solomonai_backend_client_sdk.models.plaid_exchange_token_response import PlaidExchangeTokenResponse
from solomonai_backend_client_sdk.models.plaid_initiate_token_exchange_request import PlaidInitiateTokenExchangeRequest
from solomonai_backend_client_sdk.models.plaid_initiate_token_exchange_response import PlaidInitiateTokenExchangeResponse
from solomonai_backend_client_sdk.models.plaid_initiate_token_update_request import PlaidInitiateTokenUpdateRequest
from solomonai_backend_client_sdk.models.plaid_initiate_token_update_response import PlaidInitiateTokenUpdateResponse
from solomonai_backend_client_sdk.models.plaid_sync_account_from_access_token_request import PlaidSyncAccountFromAccessTokenRequest
from solomonai_backend_client_sdk.models.plaid_sync_account_from_access_token_response import PlaidSyncAccountFromAccessTokenResponse
from solomonai_backend_client_sdk.models.poll_async_task_execution_status_response import PollAsyncTaskExecutionStatusResponse
from solomonai_backend_client_sdk.models.readyness_check_response2 import ReadynessCheckResponse2
from solomonai_backend_client_sdk.models.record_ask_copilot_question_request import RecordAskCopilotQuestionRequest
from solomonai_backend_client_sdk.models.record_ask_copilot_question_response import RecordAskCopilotQuestionResponse
from solomonai_backend_client_sdk.models.search_transactions_request import SearchTransactionsRequest
from solomonai_backend_client_sdk.models.search_transactions_response import SearchTransactionsResponse
from solomonai_backend_client_sdk.models.split_transaction_request import SplitTransactionRequest
from solomonai_backend_client_sdk.models.split_transaction_response import SplitTransactionResponse
from solomonai_backend_client_sdk.models.trigger_sync_request import TriggerSyncRequest
from solomonai_backend_client_sdk.models.trigger_sync_response import TriggerSyncResponse
from solomonai_backend_client_sdk.models.un_split_transactions_request import UnSplitTransactionsRequest
from solomonai_backend_client_sdk.models.un_split_transactions_response import UnSplitTransactionsResponse
from solomonai_backend_client_sdk.models.update_bank_account_request import UpdateBankAccountRequest
from solomonai_backend_client_sdk.models.update_bank_account_response import UpdateBankAccountResponse
from solomonai_backend_client_sdk.models.update_budget_request import UpdateBudgetRequest
from solomonai_backend_client_sdk.models.update_budget_response import UpdateBudgetResponse
from solomonai_backend_client_sdk.models.update_milestone_request import UpdateMilestoneRequest
from solomonai_backend_client_sdk.models.update_milestone_response import UpdateMilestoneResponse
from solomonai_backend_client_sdk.models.update_note_to_recurring_transaction_request import UpdateNoteToRecurringTransactionRequest
from solomonai_backend_client_sdk.models.update_note_to_recurring_transaction_response import UpdateNoteToRecurringTransactionResponse
from solomonai_backend_client_sdk.models.update_note_to_smart_goal_request import UpdateNoteToSmartGoalRequest
from solomonai_backend_client_sdk.models.update_note_to_smart_goal_response import UpdateNoteToSmartGoalResponse
from solomonai_backend_client_sdk.models.update_note_to_transaction_request import UpdateNoteToTransactionRequest
from solomonai_backend_client_sdk.models.update_note_to_transaction_response import UpdateNoteToTransactionResponse
from solomonai_backend_client_sdk.models.update_pocket_request import UpdatePocketRequest
from solomonai_backend_client_sdk.models.update_pocket_response import UpdatePocketResponse
from solomonai_backend_client_sdk.models.update_recurring_transaction_request import UpdateRecurringTransactionRequest
from solomonai_backend_client_sdk.models.update_recurring_transaction_response import UpdateRecurringTransactionResponse
from solomonai_backend_client_sdk.models.update_single_transaction_request import UpdateSingleTransactionRequest
from solomonai_backend_client_sdk.models.update_single_transaction_response import UpdateSingleTransactionResponse
from solomonai_backend_client_sdk.models.update_smart_goal_request import UpdateSmartGoalRequest
from solomonai_backend_client_sdk.models.update_smart_goal_response import UpdateSmartGoalResponse
from solomonai_backend_client_sdk.models.update_user_profile_request import UpdateUserProfileRequest
from solomonai_backend_client_sdk.models.update_user_profile_response import UpdateUserProfileResponse

from solomonai_backend_client_sdk.api_client import ApiClient, RequestSerialized
from solomonai_backend_client_sdk.api_response import ApiResponse
from solomonai_backend_client_sdk.rest import RESTResponseType


class FinancialServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def add_default_pockets_to_bank_account(
        self,
        add_default_pockets_to_bank_account_request: AddDefaultPocketsToBankAccountRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddDefaultPocketsToBankAccountResponse:
        """adds a default set of pockets to a specific bank account of interest

        This endpoint adds a default pocket to a specific bank account of interest

        :param add_default_pockets_to_bank_account_request: (required)
        :type add_default_pockets_to_bank_account_request: AddDefaultPocketsToBankAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_default_pockets_to_bank_account_serialize(
            add_default_pockets_to_bank_account_request=add_default_pockets_to_bank_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddDefaultPocketsToBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_default_pockets_to_bank_account_with_http_info(
        self,
        add_default_pockets_to_bank_account_request: AddDefaultPocketsToBankAccountRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddDefaultPocketsToBankAccountResponse]:
        """adds a default set of pockets to a specific bank account of interest

        This endpoint adds a default pocket to a specific bank account of interest

        :param add_default_pockets_to_bank_account_request: (required)
        :type add_default_pockets_to_bank_account_request: AddDefaultPocketsToBankAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_default_pockets_to_bank_account_serialize(
            add_default_pockets_to_bank_account_request=add_default_pockets_to_bank_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddDefaultPocketsToBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_default_pockets_to_bank_account_without_preload_content(
        self,
        add_default_pockets_to_bank_account_request: AddDefaultPocketsToBankAccountRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """adds a default set of pockets to a specific bank account of interest

        This endpoint adds a default pocket to a specific bank account of interest

        :param add_default_pockets_to_bank_account_request: (required)
        :type add_default_pockets_to_bank_account_request: AddDefaultPocketsToBankAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_default_pockets_to_bank_account_serialize(
            add_default_pockets_to_bank_account_request=add_default_pockets_to_bank_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddDefaultPocketsToBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_default_pockets_to_bank_account_serialize(
        self,
        add_default_pockets_to_bank_account_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_default_pockets_to_bank_account_request is not None:
            _body_params = add_default_pockets_to_bank_account_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/pocket/bank-account',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_note_to_financial_user_profile(
        self,
        add_note_to_financial_user_profile_request: AddNoteToFinancialUserProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddNoteToFinancialUserProfileResponse:
        """Adds a note to a business account

        This endpoint adds a note to a business account

        :param add_note_to_financial_user_profile_request: (required)
        :type add_note_to_financial_user_profile_request: AddNoteToFinancialUserProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_financial_user_profile_serialize(
            add_note_to_financial_user_profile_request=add_note_to_financial_user_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToFinancialUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_note_to_financial_user_profile_with_http_info(
        self,
        add_note_to_financial_user_profile_request: AddNoteToFinancialUserProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddNoteToFinancialUserProfileResponse]:
        """Adds a note to a business account

        This endpoint adds a note to a business account

        :param add_note_to_financial_user_profile_request: (required)
        :type add_note_to_financial_user_profile_request: AddNoteToFinancialUserProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_financial_user_profile_serialize(
            add_note_to_financial_user_profile_request=add_note_to_financial_user_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToFinancialUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_note_to_financial_user_profile_without_preload_content(
        self,
        add_note_to_financial_user_profile_request: AddNoteToFinancialUserProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Adds a note to a business account

        This endpoint adds a note to a business account

        :param add_note_to_financial_user_profile_request: (required)
        :type add_note_to_financial_user_profile_request: AddNoteToFinancialUserProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_financial_user_profile_serialize(
            add_note_to_financial_user_profile_request=add_note_to_financial_user_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToFinancialUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_note_to_financial_user_profile_serialize(
        self,
        add_note_to_financial_user_profile_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_note_to_financial_user_profile_request is not None:
            _body_params = add_note_to_financial_user_profile_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/financial-profile/business/note',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_note_to_recurring_transaction(
        self,
        add_note_to_recurring_transaction_request: AddNoteToRecurringTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddNoteToRecurringTransactionResponse:
        """adds a note to a transaction

        This endpoint adds a note to a transaction

        :param add_note_to_recurring_transaction_request: (required)
        :type add_note_to_recurring_transaction_request: AddNoteToRecurringTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_recurring_transaction_serialize(
            add_note_to_recurring_transaction_request=add_note_to_recurring_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_note_to_recurring_transaction_with_http_info(
        self,
        add_note_to_recurring_transaction_request: AddNoteToRecurringTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddNoteToRecurringTransactionResponse]:
        """adds a note to a transaction

        This endpoint adds a note to a transaction

        :param add_note_to_recurring_transaction_request: (required)
        :type add_note_to_recurring_transaction_request: AddNoteToRecurringTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_recurring_transaction_serialize(
            add_note_to_recurring_transaction_request=add_note_to_recurring_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_note_to_recurring_transaction_without_preload_content(
        self,
        add_note_to_recurring_transaction_request: AddNoteToRecurringTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """adds a note to a transaction

        This endpoint adds a note to a transaction

        :param add_note_to_recurring_transaction_request: (required)
        :type add_note_to_recurring_transaction_request: AddNoteToRecurringTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_recurring_transaction_serialize(
            add_note_to_recurring_transaction_request=add_note_to_recurring_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_note_to_recurring_transaction_serialize(
        self,
        add_note_to_recurring_transaction_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_note_to_recurring_transaction_request is not None:
            _body_params = add_note_to_recurring_transaction_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/transactions/recurring/note',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_note_to_smart_goal(
        self,
        add_note_to_smart_goal_request: AddNoteToSmartGoalRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddNoteToSmartGoalResponse:
        """adds a note to a smart goal

        This endpoint adds a note to a smart goal

        :param add_note_to_smart_goal_request: (required)
        :type add_note_to_smart_goal_request: AddNoteToSmartGoalRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_smart_goal_serialize(
            add_note_to_smart_goal_request=add_note_to_smart_goal_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_note_to_smart_goal_with_http_info(
        self,
        add_note_to_smart_goal_request: AddNoteToSmartGoalRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddNoteToSmartGoalResponse]:
        """adds a note to a smart goal

        This endpoint adds a note to a smart goal

        :param add_note_to_smart_goal_request: (required)
        :type add_note_to_smart_goal_request: AddNoteToSmartGoalRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_smart_goal_serialize(
            add_note_to_smart_goal_request=add_note_to_smart_goal_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_note_to_smart_goal_without_preload_content(
        self,
        add_note_to_smart_goal_request: AddNoteToSmartGoalRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """adds a note to a smart goal

        This endpoint adds a note to a smart goal

        :param add_note_to_smart_goal_request: (required)
        :type add_note_to_smart_goal_request: AddNoteToSmartGoalRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_smart_goal_serialize(
            add_note_to_smart_goal_request=add_note_to_smart_goal_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_note_to_smart_goal_serialize(
        self,
        add_note_to_smart_goal_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_note_to_smart_goal_request is not None:
            _body_params = add_note_to_smart_goal_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/smart-goal/note',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_note_to_transaction(
        self,
        add_note_to_transaction_request: AddNoteToTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddNoteToTransactionResponse:
        """adds a note to a transaction

        This endpoint adds a note to a transaction

        :param add_note_to_transaction_request: (required)
        :type add_note_to_transaction_request: AddNoteToTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_transaction_serialize(
            add_note_to_transaction_request=add_note_to_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_note_to_transaction_with_http_info(
        self,
        add_note_to_transaction_request: AddNoteToTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddNoteToTransactionResponse]:
        """adds a note to a transaction

        This endpoint adds a note to a transaction

        :param add_note_to_transaction_request: (required)
        :type add_note_to_transaction_request: AddNoteToTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_transaction_serialize(
            add_note_to_transaction_request=add_note_to_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_note_to_transaction_without_preload_content(
        self,
        add_note_to_transaction_request: AddNoteToTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """adds a note to a transaction

        This endpoint adds a note to a transaction

        :param add_note_to_transaction_request: (required)
        :type add_note_to_transaction_request: AddNoteToTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_note_to_transaction_serialize(
            add_note_to_transaction_request=add_note_to_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddNoteToTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_note_to_transaction_serialize(
        self,
        add_note_to_transaction_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_note_to_transaction_request is not None:
            _body_params = add_note_to_transaction_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/transactions/transaction/note',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_transactions_to_manually_linked_account(
        self,
        add_transactions_to_manually_linked_account_request: Annotated[AddTransactionsToManuallyLinkedAccountRequest, Field(description="Add transactions to an account.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddTransactionsToManuallyLinkedAccountResponse:
        """Adds transactions to a manually linked account

        This endpoint adds transactions to a manually linked account

        :param add_transactions_to_manually_linked_account_request: Add transactions to an account. (required)
        :type add_transactions_to_manually_linked_account_request: AddTransactionsToManuallyLinkedAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_transactions_to_manually_linked_account_serialize(
            add_transactions_to_manually_linked_account_request=add_transactions_to_manually_linked_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddTransactionsToManuallyLinkedAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_transactions_to_manually_linked_account_with_http_info(
        self,
        add_transactions_to_manually_linked_account_request: Annotated[AddTransactionsToManuallyLinkedAccountRequest, Field(description="Add transactions to an account.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddTransactionsToManuallyLinkedAccountResponse]:
        """Adds transactions to a manually linked account

        This endpoint adds transactions to a manually linked account

        :param add_transactions_to_manually_linked_account_request: Add transactions to an account. (required)
        :type add_transactions_to_manually_linked_account_request: AddTransactionsToManuallyLinkedAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_transactions_to_manually_linked_account_serialize(
            add_transactions_to_manually_linked_account_request=add_transactions_to_manually_linked_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddTransactionsToManuallyLinkedAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_transactions_to_manually_linked_account_without_preload_content(
        self,
        add_transactions_to_manually_linked_account_request: Annotated[AddTransactionsToManuallyLinkedAccountRequest, Field(description="Add transactions to an account.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Adds transactions to a manually linked account

        This endpoint adds transactions to a manually linked account

        :param add_transactions_to_manually_linked_account_request: Add transactions to an account. (required)
        :type add_transactions_to_manually_linked_account_request: AddTransactionsToManuallyLinkedAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_transactions_to_manually_linked_account_serialize(
            add_transactions_to_manually_linked_account_request=add_transactions_to_manually_linked_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddTransactionsToManuallyLinkedAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_transactions_to_manually_linked_account_serialize(
        self,
        add_transactions_to_manually_linked_account_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_transactions_to_manually_linked_account_request is not None:
            _body_params = add_transactions_to_manually_linked_account_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/manual-linked-account/transactions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def ask_copilot_question(
        self,
        record_ask_copilot_question_request: RecordAskCopilotQuestionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RecordAskCopilotQuestionResponse:
        """Ask a question to copilot

        This endpoint checks if a user can ask his/her copilot a question

        :param record_ask_copilot_question_request: (required)
        :type record_ask_copilot_question_request: RecordAskCopilotQuestionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ask_copilot_question_serialize(
            record_ask_copilot_question_request=record_ask_copilot_question_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecordAskCopilotQuestionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def ask_copilot_question_with_http_info(
        self,
        record_ask_copilot_question_request: RecordAskCopilotQuestionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RecordAskCopilotQuestionResponse]:
        """Ask a question to copilot

        This endpoint checks if a user can ask his/her copilot a question

        :param record_ask_copilot_question_request: (required)
        :type record_ask_copilot_question_request: RecordAskCopilotQuestionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ask_copilot_question_serialize(
            record_ask_copilot_question_request=record_ask_copilot_question_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecordAskCopilotQuestionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def ask_copilot_question_without_preload_content(
        self,
        record_ask_copilot_question_request: RecordAskCopilotQuestionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Ask a question to copilot

        This endpoint checks if a user can ask his/her copilot a question

        :param record_ask_copilot_question_request: (required)
        :type record_ask_copilot_question_request: RecordAskCopilotQuestionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ask_copilot_question_serialize(
            record_ask_copilot_question_request=record_ask_copilot_question_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecordAskCopilotQuestionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ask_copilot_question_serialize(
        self,
        record_ask_copilot_question_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if record_ask_copilot_question_request is not None:
            _body_params = record_ask_copilot_question_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/copilot/quota/question',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def bulk_update_recurring_transaction(
        self,
        bulk_update_recurring_transaction_request: BulkUpdateRecurringTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BulkUpdateRecurringTransactionResponse:
        """update a transaction

        This endpoint updates a set of transactions

        :param bulk_update_recurring_transaction_request: (required)
        :type bulk_update_recurring_transaction_request: BulkUpdateRecurringTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_update_recurring_transaction_serialize(
            bulk_update_recurring_transaction_request=bulk_update_recurring_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkUpdateRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def bulk_update_recurring_transaction_with_http_info(
        self,
        bulk_update_recurring_transaction_request: BulkUpdateRecurringTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BulkUpdateRecurringTransactionResponse]:
        """update a transaction

        This endpoint updates a set of transactions

        :param bulk_update_recurring_transaction_request: (required)
        :type bulk_update_recurring_transaction_request: BulkUpdateRecurringTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_update_recurring_transaction_serialize(
            bulk_update_recurring_transaction_request=bulk_update_recurring_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkUpdateRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def bulk_update_recurring_transaction_without_preload_content(
        self,
        bulk_update_recurring_transaction_request: BulkUpdateRecurringTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update a transaction

        This endpoint updates a set of transactions

        :param bulk_update_recurring_transaction_request: (required)
        :type bulk_update_recurring_transaction_request: BulkUpdateRecurringTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_update_recurring_transaction_serialize(
            bulk_update_recurring_transaction_request=bulk_update_recurring_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkUpdateRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _bulk_update_recurring_transaction_serialize(
        self,
        bulk_update_recurring_transaction_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_update_recurring_transaction_request is not None:
            _body_params = bulk_update_recurring_transaction_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/financial-microservice/api/v1/transactions/recurring/bulk',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def bulk_update_transaction(
        self,
        bulk_update_transaction_request: BulkUpdateTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BulkUpdateTransactionResponse:
        """update a transaction

        This endpoint updates a set of transactions

        :param bulk_update_transaction_request: (required)
        :type bulk_update_transaction_request: BulkUpdateTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_update_transaction_serialize(
            bulk_update_transaction_request=bulk_update_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkUpdateTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def bulk_update_transaction_with_http_info(
        self,
        bulk_update_transaction_request: BulkUpdateTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BulkUpdateTransactionResponse]:
        """update a transaction

        This endpoint updates a set of transactions

        :param bulk_update_transaction_request: (required)
        :type bulk_update_transaction_request: BulkUpdateTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_update_transaction_serialize(
            bulk_update_transaction_request=bulk_update_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkUpdateTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def bulk_update_transaction_without_preload_content(
        self,
        bulk_update_transaction_request: BulkUpdateTransactionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update a transaction

        This endpoint updates a set of transactions

        :param bulk_update_transaction_request: (required)
        :type bulk_update_transaction_request: BulkUpdateTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_update_transaction_serialize(
            bulk_update_transaction_request=bulk_update_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkUpdateTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _bulk_update_transaction_serialize(
        self,
        bulk_update_transaction_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_update_transaction_request is not None:
            _body_params = bulk_update_transaction_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/financial-microservice/api/v1/transactions/transaction/bulk',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def check_if_quota_exceeded(
        self,
        user_id: Annotated[StrictStr, Field(description="the account id associated with the user")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CheckIfQuotaExceededResponse:
        """Checks if the question quota has been exceeded

        This endpoint checks if a user has exceeded his/her copilot question quota

        :param user_id: the account id associated with the user (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_if_quota_exceeded_serialize(
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckIfQuotaExceededResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def check_if_quota_exceeded_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the account id associated with the user")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CheckIfQuotaExceededResponse]:
        """Checks if the question quota has been exceeded

        This endpoint checks if a user has exceeded his/her copilot question quota

        :param user_id: the account id associated with the user (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_if_quota_exceeded_serialize(
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckIfQuotaExceededResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def check_if_quota_exceeded_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the account id associated with the user")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Checks if the question quota has been exceeded

        This endpoint checks if a user has exceeded his/her copilot question quota

        :param user_id: the account id associated with the user (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_if_quota_exceeded_serialize(
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckIfQuotaExceededResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _check_if_quota_exceeded_serialize(
        self,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/copilot/quota/exceeded/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_bank_account(
        self,
        create_bank_account_request: CreateBankAccountRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateBankAccountResponse:
        """create a bank account for a given user profile

        This endpoint creates a bank account for a given user profile

        :param create_bank_account_request: (required)
        :type create_bank_account_request: CreateBankAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_bank_account_serialize(
            create_bank_account_request=create_bank_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_bank_account_with_http_info(
        self,
        create_bank_account_request: CreateBankAccountRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateBankAccountResponse]:
        """create a bank account for a given user profile

        This endpoint creates a bank account for a given user profile

        :param create_bank_account_request: (required)
        :type create_bank_account_request: CreateBankAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_bank_account_serialize(
            create_bank_account_request=create_bank_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_bank_account_without_preload_content(
        self,
        create_bank_account_request: CreateBankAccountRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create a bank account for a given user profile

        This endpoint creates a bank account for a given user profile

        :param create_bank_account_request: (required)
        :type create_bank_account_request: CreateBankAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_bank_account_serialize(
            create_bank_account_request=create_bank_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_bank_account_serialize(
        self,
        create_bank_account_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_bank_account_request is not None:
            _body_params = create_bank_account_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/bank-account/profile',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_budget(
        self,
        create_budget_request: CreateBudgetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateBudgetResponse:
        """create a budget

        This endpoint creates a budget

        :param create_budget_request: (required)
        :type create_budget_request: CreateBudgetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_budget_serialize(
            create_budget_request=create_budget_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBudgetResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_budget_with_http_info(
        self,
        create_budget_request: CreateBudgetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateBudgetResponse]:
        """create a budget

        This endpoint creates a budget

        :param create_budget_request: (required)
        :type create_budget_request: CreateBudgetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_budget_serialize(
            create_budget_request=create_budget_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBudgetResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_budget_without_preload_content(
        self,
        create_budget_request: CreateBudgetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create a budget

        This endpoint creates a budget

        :param create_budget_request: (required)
        :type create_budget_request: CreateBudgetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_budget_serialize(
            create_budget_request=create_budget_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBudgetResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_budget_serialize(
        self,
        create_budget_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_budget_request is not None:
            _body_params = create_budget_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/budget',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_credit_account(
        self,
        create_credit_account_request: CreateCreditAccountRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateCreditAccountResponse:
        """create a credit account for a given user profile

        This endpoint creates a credit account for a given user profile

        :param create_credit_account_request: (required)
        :type create_credit_account_request: CreateCreditAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_credit_account_serialize(
            create_credit_account_request=create_credit_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCreditAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_credit_account_with_http_info(
        self,
        create_credit_account_request: CreateCreditAccountRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateCreditAccountResponse]:
        """create a credit account for a given user profile

        This endpoint creates a credit account for a given user profile

        :param create_credit_account_request: (required)
        :type create_credit_account_request: CreateCreditAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_credit_account_serialize(
            create_credit_account_request=create_credit_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCreditAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_credit_account_without_preload_content(
        self,
        create_credit_account_request: CreateCreditAccountRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create a credit account for a given user profile

        This endpoint creates a credit account for a given user profile

        :param create_credit_account_request: (required)
        :type create_credit_account_request: CreateCreditAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_credit_account_serialize(
            create_credit_account_request=create_credit_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCreditAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_credit_account_serialize(
        self,
        create_credit_account_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_credit_account_request is not None:
            _body_params = create_credit_account_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/credit-account/profile',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_link(
        self,
        create_manual_link_request: CreateManualLinkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateManualLinkResponse:
        """create link

        This endpoint creates a link

        :param create_manual_link_request: (required)
        :type create_manual_link_request: CreateManualLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_link_serialize(
            create_manual_link_request=create_manual_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateManualLinkResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_link_with_http_info(
        self,
        create_manual_link_request: CreateManualLinkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateManualLinkResponse]:
        """create link

        This endpoint creates a link

        :param create_manual_link_request: (required)
        :type create_manual_link_request: CreateManualLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_link_serialize(
            create_manual_link_request=create_manual_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateManualLinkResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_link_without_preload_content(
        self,
        create_manual_link_request: CreateManualLinkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create link

        This endpoint creates a link

        :param create_manual_link_request: (required)
        :type create_manual_link_request: CreateManualLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_link_serialize(
            create_manual_link_request=create_manual_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateManualLinkResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_link_serialize(
        self,
        create_manual_link_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_manual_link_request is not None:
            _body_params = create_manual_link_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/link',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_milestone(
        self,
        create_milestone_request: CreateMilestoneRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateMilestoneResponse:
        """create a milestone

        This endpoint creates a milestone

        :param create_milestone_request: (required)
        :type create_milestone_request: CreateMilestoneRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_milestone_serialize(
            create_milestone_request=create_milestone_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateMilestoneResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_milestone_with_http_info(
        self,
        create_milestone_request: CreateMilestoneRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateMilestoneResponse]:
        """create a milestone

        This endpoint creates a milestone

        :param create_milestone_request: (required)
        :type create_milestone_request: CreateMilestoneRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_milestone_serialize(
            create_milestone_request=create_milestone_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateMilestoneResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_milestone_without_preload_content(
        self,
        create_milestone_request: CreateMilestoneRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create a milestone

        This endpoint creates a milestone

        :param create_milestone_request: (required)
        :type create_milestone_request: CreateMilestoneRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_milestone_serialize(
            create_milestone_request=create_milestone_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateMilestoneResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_milestone_serialize(
        self,
        create_milestone_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_milestone_request is not None:
            _body_params = create_milestone_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/milestone',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_smart_goal(
        self,
        create_smart_goal_request: CreateSmartGoalRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateSmartGoalResponse:
        """create a smart goal

        This endpoint creates a smart goal

        :param create_smart_goal_request: (required)
        :type create_smart_goal_request: CreateSmartGoalRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_smart_goal_serialize(
            create_smart_goal_request=create_smart_goal_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_smart_goal_with_http_info(
        self,
        create_smart_goal_request: CreateSmartGoalRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateSmartGoalResponse]:
        """create a smart goal

        This endpoint creates a smart goal

        :param create_smart_goal_request: (required)
        :type create_smart_goal_request: CreateSmartGoalRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_smart_goal_serialize(
            create_smart_goal_request=create_smart_goal_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_smart_goal_without_preload_content(
        self,
        create_smart_goal_request: CreateSmartGoalRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create a smart goal

        This endpoint creates a smart goal

        :param create_smart_goal_request: (required)
        :type create_smart_goal_request: CreateSmartGoalRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_smart_goal_serialize(
            create_smart_goal_request=create_smart_goal_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_smart_goal_serialize(
        self,
        create_smart_goal_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_smart_goal_request is not None:
            _body_params = create_smart_goal_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/smart-goal',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_subscription(
        self,
        create_subscription_request: CreateSubscriptionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateSubscriptionResponse:
        """Creates a new subscription for a given customer against stripe

        This endpoint enabled a user to create a new subscription against stripe

        :param create_subscription_request: (required)
        :type create_subscription_request: CreateSubscriptionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_subscription_serialize(
            create_subscription_request=create_subscription_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSubscriptionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_subscription_with_http_info(
        self,
        create_subscription_request: CreateSubscriptionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateSubscriptionResponse]:
        """Creates a new subscription for a given customer against stripe

        This endpoint enabled a user to create a new subscription against stripe

        :param create_subscription_request: (required)
        :type create_subscription_request: CreateSubscriptionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_subscription_serialize(
            create_subscription_request=create_subscription_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSubscriptionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_subscription_without_preload_content(
        self,
        create_subscription_request: CreateSubscriptionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a new subscription for a given customer against stripe

        This endpoint enabled a user to create a new subscription against stripe

        :param create_subscription_request: (required)
        :type create_subscription_request: CreateSubscriptionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_subscription_serialize(
            create_subscription_request=create_subscription_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSubscriptionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_subscription_serialize(
        self,
        create_subscription_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_subscription_request is not None:
            _body_params = create_subscription_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/stripe/subscription',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_user_profile1(
        self,
        create_user_profile_request1: Annotated[CreateUserProfileRequest1, Field(description="CreateUserProfileRequest represents the request object for creating a user profile in the financial service. This message encapsulates the essential information needed to establish a new financial user profile, including identification, contact details, and the type of financial profile.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateUserProfileResponse1:
        """create a user profile

        This endpoint performs an a creation operation of a user profile based on the provided parametersThis operation is implemented as a distributed transactions as this operation can span multiple services

        :param create_user_profile_request1: CreateUserProfileRequest represents the request object for creating a user profile in the financial service. This message encapsulates the essential information needed to establish a new financial user profile, including identification, contact details, and the type of financial profile. (required)
        :type create_user_profile_request1: CreateUserProfileRequest1
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_profile1_serialize(
            create_user_profile_request1=create_user_profile_request1,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserProfileResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_user_profile1_with_http_info(
        self,
        create_user_profile_request1: Annotated[CreateUserProfileRequest1, Field(description="CreateUserProfileRequest represents the request object for creating a user profile in the financial service. This message encapsulates the essential information needed to establish a new financial user profile, including identification, contact details, and the type of financial profile.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateUserProfileResponse1]:
        """create a user profile

        This endpoint performs an a creation operation of a user profile based on the provided parametersThis operation is implemented as a distributed transactions as this operation can span multiple services

        :param create_user_profile_request1: CreateUserProfileRequest represents the request object for creating a user profile in the financial service. This message encapsulates the essential information needed to establish a new financial user profile, including identification, contact details, and the type of financial profile. (required)
        :type create_user_profile_request1: CreateUserProfileRequest1
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_profile1_serialize(
            create_user_profile_request1=create_user_profile_request1,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserProfileResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_user_profile1_without_preload_content(
        self,
        create_user_profile_request1: Annotated[CreateUserProfileRequest1, Field(description="CreateUserProfileRequest represents the request object for creating a user profile in the financial service. This message encapsulates the essential information needed to establish a new financial user profile, including identification, contact details, and the type of financial profile.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create a user profile

        This endpoint performs an a creation operation of a user profile based on the provided parametersThis operation is implemented as a distributed transactions as this operation can span multiple services

        :param create_user_profile_request1: CreateUserProfileRequest represents the request object for creating a user profile in the financial service. This message encapsulates the essential information needed to establish a new financial user profile, including identification, contact details, and the type of financial profile. (required)
        :type create_user_profile_request1: CreateUserProfileRequest1
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_profile1_serialize(
            create_user_profile_request1=create_user_profile_request1,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserProfileResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_user_profile1_serialize(
        self,
        create_user_profile_request1,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_user_profile_request1 is not None:
            _body_params = create_user_profile_request1


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/financial-microservice/api/v1/profile',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_budget(
        self,
        budget_id: Annotated[StrictStr, Field(description="The budget id Validations: - budget_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteBudgetResponse:
        """delete a budget

        This endpoint deletes a budget

        :param budget_id: The budget id Validations: - budget_id must be greater than 0 (required)
        :type budget_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_budget_serialize(
            budget_id=budget_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteBudgetResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_budget_with_http_info(
        self,
        budget_id: Annotated[StrictStr, Field(description="The budget id Validations: - budget_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteBudgetResponse]:
        """delete a budget

        This endpoint deletes a budget

        :param budget_id: The budget id Validations: - budget_id must be greater than 0 (required)
        :type budget_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_budget_serialize(
            budget_id=budget_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteBudgetResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_budget_without_preload_content(
        self,
        budget_id: Annotated[StrictStr, Field(description="The budget id Validations: - budget_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete a budget

        This endpoint deletes a budget

        :param budget_id: The budget id Validations: - budget_id must be greater than 0 (required)
        :type budget_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_budget_serialize(
            budget_id=budget_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteBudgetResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_budget_serialize(
        self,
        budget_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if budget_id is not None:
            _path_params['budgetId'] = budget_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/budget/{budgetId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_link(
        self,
        link_id: Annotated[StrictStr, Field(description="The link id Validations: - link_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteLinkResponse:
        """delete link by id

        This endpoint deletes the link if the link exists

        :param link_id: The link id Validations: - link_id must be greater than 0 (required)
        :type link_id: str
        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_link_serialize(
            link_id=link_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteLinkResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_link_with_http_info(
        self,
        link_id: Annotated[StrictStr, Field(description="The link id Validations: - link_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteLinkResponse]:
        """delete link by id

        This endpoint deletes the link if the link exists

        :param link_id: The link id Validations: - link_id must be greater than 0 (required)
        :type link_id: str
        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_link_serialize(
            link_id=link_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteLinkResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_link_without_preload_content(
        self,
        link_id: Annotated[StrictStr, Field(description="The link id Validations: - link_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete link by id

        This endpoint deletes the link if the link exists

        :param link_id: The link id Validations: - link_id must be greater than 0 (required)
        :type link_id: str
        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_link_serialize(
            link_id=link_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteLinkResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_link_serialize(
        self,
        link_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if link_id is not None:
            _path_params['linkId'] = link_id
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/link/{linkId}/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_milestone(
        self,
        milestone_id: Annotated[StrictStr, Field(description="The milestone id Validations: - milestone_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteMilestoneResponse:
        """delete a milestone

        This endpoint deletes a milestone

        :param milestone_id: The milestone id Validations: - milestone_id must be greater than 0 (required)
        :type milestone_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_milestone_serialize(
            milestone_id=milestone_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteMilestoneResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_milestone_with_http_info(
        self,
        milestone_id: Annotated[StrictStr, Field(description="The milestone id Validations: - milestone_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteMilestoneResponse]:
        """delete a milestone

        This endpoint deletes a milestone

        :param milestone_id: The milestone id Validations: - milestone_id must be greater than 0 (required)
        :type milestone_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_milestone_serialize(
            milestone_id=milestone_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteMilestoneResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_milestone_without_preload_content(
        self,
        milestone_id: Annotated[StrictStr, Field(description="The milestone id Validations: - milestone_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete a milestone

        This endpoint deletes a milestone

        :param milestone_id: The milestone id Validations: - milestone_id must be greater than 0 (required)
        :type milestone_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_milestone_serialize(
            milestone_id=milestone_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteMilestoneResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_milestone_serialize(
        self,
        milestone_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if milestone_id is not None:
            _path_params['milestoneId'] = milestone_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/milestone/{milestoneId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_note_from_recurring_transaction(
        self,
        transaction_id: Annotated[StrictStr, Field(description="The transaction id Validations: - transaction_id must be greater than 0")],
        note_id: Annotated[StrictStr, Field(description="The note id Validations: - note_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteNoteFromRecurringTransactionResponse:
        """deletes a note from a transaction

        This endpoint deletes a note from a transaction

        :param transaction_id: The transaction id Validations: - transaction_id must be greater than 0 (required)
        :type transaction_id: str
        :param note_id: The note id Validations: - note_id must be greater than 0 (required)
        :type note_id: str
        :param user_id: The user id (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_from_recurring_transaction_serialize(
            transaction_id=transaction_id,
            note_id=note_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteFromRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_note_from_recurring_transaction_with_http_info(
        self,
        transaction_id: Annotated[StrictStr, Field(description="The transaction id Validations: - transaction_id must be greater than 0")],
        note_id: Annotated[StrictStr, Field(description="The note id Validations: - note_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteNoteFromRecurringTransactionResponse]:
        """deletes a note from a transaction

        This endpoint deletes a note from a transaction

        :param transaction_id: The transaction id Validations: - transaction_id must be greater than 0 (required)
        :type transaction_id: str
        :param note_id: The note id Validations: - note_id must be greater than 0 (required)
        :type note_id: str
        :param user_id: The user id (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_from_recurring_transaction_serialize(
            transaction_id=transaction_id,
            note_id=note_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteFromRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_note_from_recurring_transaction_without_preload_content(
        self,
        transaction_id: Annotated[StrictStr, Field(description="The transaction id Validations: - transaction_id must be greater than 0")],
        note_id: Annotated[StrictStr, Field(description="The note id Validations: - note_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """deletes a note from a transaction

        This endpoint deletes a note from a transaction

        :param transaction_id: The transaction id Validations: - transaction_id must be greater than 0 (required)
        :type transaction_id: str
        :param note_id: The note id Validations: - note_id must be greater than 0 (required)
        :type note_id: str
        :param user_id: The user id (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_from_recurring_transaction_serialize(
            transaction_id=transaction_id,
            note_id=note_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteFromRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_note_from_recurring_transaction_serialize(
        self,
        transaction_id,
        note_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if transaction_id is not None:
            _path_params['transactionId'] = transaction_id
        if note_id is not None:
            _path_params['noteId'] = note_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/transactions/recurring/{transactionId}/note/{noteId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_note_from_smart_goal(
        self,
        note_id: Annotated[StrictStr, Field(description="The note id Validations: - note_id must be greater than 0")],
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id")],
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteNoteFromSmartGoalResponse:
        """deletes a note from a smart goal

        This endpoint deletes a note from a smart goal

        :param note_id: The note id Validations: - note_id must be greater than 0 (required)
        :type note_id: str
        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: The user id (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_from_smart_goal_serialize(
            note_id=note_id,
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteFromSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_note_from_smart_goal_with_http_info(
        self,
        note_id: Annotated[StrictStr, Field(description="The note id Validations: - note_id must be greater than 0")],
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id")],
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteNoteFromSmartGoalResponse]:
        """deletes a note from a smart goal

        This endpoint deletes a note from a smart goal

        :param note_id: The note id Validations: - note_id must be greater than 0 (required)
        :type note_id: str
        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: The user id (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_from_smart_goal_serialize(
            note_id=note_id,
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteFromSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_note_from_smart_goal_without_preload_content(
        self,
        note_id: Annotated[StrictStr, Field(description="The note id Validations: - note_id must be greater than 0")],
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id")],
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """deletes a note from a smart goal

        This endpoint deletes a note from a smart goal

        :param note_id: The note id Validations: - note_id must be greater than 0 (required)
        :type note_id: str
        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: The user id (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_from_smart_goal_serialize(
            note_id=note_id,
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteFromSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_note_from_smart_goal_serialize(
        self,
        note_id,
        smart_goal_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if note_id is not None:
            _path_params['noteId'] = note_id
        # process the query parameters
        if smart_goal_id is not None:
            
            _query_params.append(('smartGoalId', smart_goal_id))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/smart-goal/note/{noteId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_note_from_transaction(
        self,
        transaction_id: Annotated[StrictStr, Field(description="The transaction id Validations: - transaction_id must be greater than 0")],
        note_id: Annotated[StrictStr, Field(description="The note id Validations: - note_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteNoteFromTransactionResponse:
        """deletes a note from a transaction

        This endpoint deletes a note from a transaction

        :param transaction_id: The transaction id Validations: - transaction_id must be greater than 0 (required)
        :type transaction_id: str
        :param note_id: The note id Validations: - note_id must be greater than 0 (required)
        :type note_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_from_transaction_serialize(
            transaction_id=transaction_id,
            note_id=note_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteFromTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_note_from_transaction_with_http_info(
        self,
        transaction_id: Annotated[StrictStr, Field(description="The transaction id Validations: - transaction_id must be greater than 0")],
        note_id: Annotated[StrictStr, Field(description="The note id Validations: - note_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteNoteFromTransactionResponse]:
        """deletes a note from a transaction

        This endpoint deletes a note from a transaction

        :param transaction_id: The transaction id Validations: - transaction_id must be greater than 0 (required)
        :type transaction_id: str
        :param note_id: The note id Validations: - note_id must be greater than 0 (required)
        :type note_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_from_transaction_serialize(
            transaction_id=transaction_id,
            note_id=note_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteFromTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_note_from_transaction_without_preload_content(
        self,
        transaction_id: Annotated[StrictStr, Field(description="The transaction id Validations: - transaction_id must be greater than 0")],
        note_id: Annotated[StrictStr, Field(description="The note id Validations: - note_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """deletes a note from a transaction

        This endpoint deletes a note from a transaction

        :param transaction_id: The transaction id Validations: - transaction_id must be greater than 0 (required)
        :type transaction_id: str
        :param note_id: The note id Validations: - note_id must be greater than 0 (required)
        :type note_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_from_transaction_serialize(
            transaction_id=transaction_id,
            note_id=note_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteFromTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_note_from_transaction_serialize(
        self,
        transaction_id,
        note_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if transaction_id is not None:
            _path_params['transactionId'] = transaction_id
        if note_id is not None:
            _path_params['noteId'] = note_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/transactions/transaction/{transactionId}/note/{noteId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_pocket(
        self,
        pocket_id: Annotated[StrictStr, Field(description="The pocket id Validations: - pocket_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeletePocketResponse:
        """deletes a pocket

        This endpoint deletes a pocket

        :param pocket_id: The pocket id Validations: - pocket_id must be greater than 0 (required)
        :type pocket_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_pocket_serialize(
            pocket_id=pocket_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePocketResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_pocket_with_http_info(
        self,
        pocket_id: Annotated[StrictStr, Field(description="The pocket id Validations: - pocket_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeletePocketResponse]:
        """deletes a pocket

        This endpoint deletes a pocket

        :param pocket_id: The pocket id Validations: - pocket_id must be greater than 0 (required)
        :type pocket_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_pocket_serialize(
            pocket_id=pocket_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePocketResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_pocket_without_preload_content(
        self,
        pocket_id: Annotated[StrictStr, Field(description="The pocket id Validations: - pocket_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """deletes a pocket

        This endpoint deletes a pocket

        :param pocket_id: The pocket id Validations: - pocket_id must be greater than 0 (required)
        :type pocket_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_pocket_serialize(
            pocket_id=pocket_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePocketResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_pocket_serialize(
        self,
        pocket_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pocket_id is not None:
            _path_params['pocketId'] = pocket_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/pocket/{pocketId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_smart_goal(
        self,
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteSmartGoalResponse:
        """delete a smart goal

        This endpoint deletes a smart goal

        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_smart_goal_serialize(
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_smart_goal_with_http_info(
        self,
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteSmartGoalResponse]:
        """delete a smart goal

        This endpoint deletes a smart goal

        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_smart_goal_serialize(
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_smart_goal_without_preload_content(
        self,
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete a smart goal

        This endpoint deletes a smart goal

        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_smart_goal_serialize(
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteSmartGoalResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_smart_goal_serialize(
        self,
        smart_goal_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if smart_goal_id is not None:
            _path_params['smartGoalId'] = smart_goal_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/smart-goal/{smartGoalId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_transaction(
        self,
        transaction_id: Annotated[StrictStr, Field(description="the transaction of interest we aim to delete")],
        user_id: Annotated[StrictStr, Field(description="The user id")],
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteRecurringTransactionResponse:
        """deletes a transaction by id

        This endpoint deletes a specific transaction based on the transaction id

        :param transaction_id: the transaction of interest we aim to delete (required)
        :type transaction_id: str
        :param user_id: The user id (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_transaction_serialize(
            transaction_id=transaction_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_transaction_with_http_info(
        self,
        transaction_id: Annotated[StrictStr, Field(description="the transaction of interest we aim to delete")],
        user_id: Annotated[StrictStr, Field(description="The user id")],
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteRecurringTransactionResponse]:
        """deletes a transaction by id

        This endpoint deletes a specific transaction based on the transaction id

        :param transaction_id: the transaction of interest we aim to delete (required)
        :type transaction_id: str
        :param user_id: The user id (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_transaction_serialize(
            transaction_id=transaction_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_transaction_without_preload_content(
        self,
        transaction_id: Annotated[StrictStr, Field(description="the transaction of interest we aim to delete")],
        user_id: Annotated[StrictStr, Field(description="The user id")],
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """deletes a transaction by id

        This endpoint deletes a specific transaction based on the transaction id

        :param transaction_id: the transaction of interest we aim to delete (required)
        :type transaction_id: str
        :param user_id: The user id (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_transaction_serialize(
            transaction_id=transaction_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteRecurringTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_transaction_serialize(
        self,
        transaction_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if transaction_id is not None:
            _path_params['transactionId'] = transaction_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/transactions/recurring/{transactionId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_transaction1(
        self,
        transaction_id: Annotated[StrictStr, Field(description="the transaction of interest we aim to delete")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteTransactionResponse:
        """deletes a transaction by id

        This endpoint deletes a specific transaction based on the transaction id

        :param transaction_id: the transaction of interest we aim to delete (required)
        :type transaction_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_transaction1_serialize(
            transaction_id=transaction_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_transaction1_with_http_info(
        self,
        transaction_id: Annotated[StrictStr, Field(description="the transaction of interest we aim to delete")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteTransactionResponse]:
        """deletes a transaction by id

        This endpoint deletes a specific transaction based on the transaction id

        :param transaction_id: the transaction of interest we aim to delete (required)
        :type transaction_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_transaction1_serialize(
            transaction_id=transaction_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_transaction1_without_preload_content(
        self,
        transaction_id: Annotated[StrictStr, Field(description="the transaction of interest we aim to delete")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """deletes a transaction by id

        This endpoint deletes a specific transaction based on the transaction id

        :param transaction_id: the transaction of interest we aim to delete (required)
        :type transaction_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_transaction1_serialize(
            transaction_id=transaction_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTransactionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_transaction1_serialize(
        self,
        transaction_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if transaction_id is not None:
            _path_params['transactionId'] = transaction_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/transactions/transaction/{transactionId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_user_profile1(
        self,
        bank_account_id: Annotated[StrictStr, Field(description="The bank account id Validations: - bank_account_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteBankAccountResponse:
        """deletes a bank account for a given user profile

        This endpoint performs a delete operation on a user profile based on the provided parametersThis deletion operation spans multiple services (plaid) as user details are stored across a suite of our backend servicesThe operation itself is an atomic one of nature. Either all services successfully delete the recod or we fail the requestDivergent state is not expected to be encountered with this endpoint.

        :param bank_account_id: The bank account id Validations: - bank_account_id must be greater than 0 (required)
        :type bank_account_id: str
        :param user_id: The account ID associated with the user Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_profile1_serialize(
            bank_account_id=bank_account_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_user_profile1_with_http_info(
        self,
        bank_account_id: Annotated[StrictStr, Field(description="The bank account id Validations: - bank_account_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteBankAccountResponse]:
        """deletes a bank account for a given user profile

        This endpoint performs a delete operation on a user profile based on the provided parametersThis deletion operation spans multiple services (plaid) as user details are stored across a suite of our backend servicesThe operation itself is an atomic one of nature. Either all services successfully delete the recod or we fail the requestDivergent state is not expected to be encountered with this endpoint.

        :param bank_account_id: The bank account id Validations: - bank_account_id must be greater than 0 (required)
        :type bank_account_id: str
        :param user_id: The account ID associated with the user Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_profile1_serialize(
            bank_account_id=bank_account_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_user_profile1_without_preload_content(
        self,
        bank_account_id: Annotated[StrictStr, Field(description="The bank account id Validations: - bank_account_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """deletes a bank account for a given user profile

        This endpoint performs a delete operation on a user profile based on the provided parametersThis deletion operation spans multiple services (plaid) as user details are stored across a suite of our backend servicesThe operation itself is an atomic one of nature. Either all services successfully delete the recod or we fail the requestDivergent state is not expected to be encountered with this endpoint.

        :param bank_account_id: The bank account id Validations: - bank_account_id must be greater than 0 (required)
        :type bank_account_id: str
        :param user_id: The account ID associated with the user Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_profile1_serialize(
            bank_account_id=bank_account_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_user_profile1_serialize(
        self,
        bank_account_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if bank_account_id is not None:
            _path_params['bankAccountId'] = bank_account_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/bank-account/{bankAccountId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_user_profile2(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user. NOTE: This user_id is the simfiny backend platform wide user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteUserProfileResponse1:
        """deletes a user profile

        This endpoint performs a delete operation on a user profile based on the provided parameters

        :param user_id: The account ID associated with the user. NOTE: This user_id is the simfiny backend platform wide user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_profile2_serialize(
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteUserProfileResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_user_profile2_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user. NOTE: This user_id is the simfiny backend platform wide user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteUserProfileResponse1]:
        """deletes a user profile

        This endpoint performs a delete operation on a user profile based on the provided parameters

        :param user_id: The account ID associated with the user. NOTE: This user_id is the simfiny backend platform wide user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_profile2_serialize(
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteUserProfileResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_user_profile2_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user. NOTE: This user_id is the simfiny backend platform wide user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """deletes a user profile

        This endpoint performs a delete operation on a user profile based on the provided parameters

        :param user_id: The account ID associated with the user. NOTE: This user_id is the simfiny backend platform wide user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_profile2_serialize(
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteUserProfileResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_user_profile2_serialize(
        self,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/financial-microservice/api/v1/profile/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_account_balance(
        self,
        user_id: StrictStr,
        plaid_account_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetHistoricalAccountBalanceResponse:
        """gets account balance of an account

        This endpoint returns the historical balance for a given account

        :param user_id: (required)
        :type user_id: str
        :param plaid_account_id: (required)
        :type plaid_account_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_account_balance_serialize(
            user_id=user_id,
            plaid_account_id=plaid_account_id,
            org_id=org_id,
            tenant_id=tenant_id,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetHistoricalAccountBalanceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_account_balance_with_http_info(
        self,
        user_id: StrictStr,
        plaid_account_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetHistoricalAccountBalanceResponse]:
        """gets account balance of an account

        This endpoint returns the historical balance for a given account

        :param user_id: (required)
        :type user_id: str
        :param plaid_account_id: (required)
        :type plaid_account_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_account_balance_serialize(
            user_id=user_id,
            plaid_account_id=plaid_account_id,
            org_id=org_id,
            tenant_id=tenant_id,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetHistoricalAccountBalanceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_account_balance_without_preload_content(
        self,
        user_id: StrictStr,
        plaid_account_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """gets account balance of an account

        This endpoint returns the historical balance for a given account

        :param user_id: (required)
        :type user_id: str
        :param plaid_account_id: (required)
        :type plaid_account_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_account_balance_serialize(
            user_id=user_id,
            plaid_account_id=plaid_account_id,
            org_id=org_id,
            tenant_id=tenant_id,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetHistoricalAccountBalanceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_account_balance_serialize(
        self,
        user_id,
        plaid_account_id,
        org_id,
        tenant_id,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if plaid_account_id is not None:
            _path_params['plaidAccountId'] = plaid_account_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/historical-account-balance/user/{userId}/plaid-account-id/{plaidAccountId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_account_balance_history(
        self,
        plaid_account_id: Annotated[StrictStr, Field(description="Account ID")],
        page_number: StrictStr,
        page_size: Annotated[StrictStr, Field(description="Number of items to return per page.")],
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetAccountBalanceHistoryResponse:
        """Returns the account balance history for an account

        This API could accept account_id as input parameters and return the account balance history for that account.

        :param plaid_account_id: Account ID (required)
        :type plaid_account_id: str
        :param page_number: (required)
        :type page_number: str
        :param page_size: Number of items to return per page. (required)
        :type page_size: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_account_balance_history_serialize(
            plaid_account_id=plaid_account_id,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAccountBalanceHistoryResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_account_balance_history_with_http_info(
        self,
        plaid_account_id: Annotated[StrictStr, Field(description="Account ID")],
        page_number: StrictStr,
        page_size: Annotated[StrictStr, Field(description="Number of items to return per page.")],
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetAccountBalanceHistoryResponse]:
        """Returns the account balance history for an account

        This API could accept account_id as input parameters and return the account balance history for that account.

        :param plaid_account_id: Account ID (required)
        :type plaid_account_id: str
        :param page_number: (required)
        :type page_number: str
        :param page_size: Number of items to return per page. (required)
        :type page_size: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_account_balance_history_serialize(
            plaid_account_id=plaid_account_id,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAccountBalanceHistoryResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_account_balance_history_without_preload_content(
        self,
        plaid_account_id: Annotated[StrictStr, Field(description="Account ID")],
        page_number: StrictStr,
        page_size: Annotated[StrictStr, Field(description="Number of items to return per page.")],
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Returns the account balance history for an account

        This API could accept account_id as input parameters and return the account balance history for that account.

        :param plaid_account_id: Account ID (required)
        :type plaid_account_id: str
        :param page_number: (required)
        :type page_number: str
        :param page_size: Number of items to return per page. (required)
        :type page_size: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_account_balance_history_serialize(
            plaid_account_id=plaid_account_id,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAccountBalanceHistoryResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_account_balance_history_serialize(
        self,
        plaid_account_id,
        page_number,
        page_size,
        profile_type,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if plaid_account_id is not None:
            _path_params['plaidAccountId'] = plaid_account_id
        if page_number is not None:
            _path_params['pageNumber'] = page_number
        if page_size is not None:
            _path_params['pageSize'] = page_size
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/balance-history/account/{plaidAccountId}/pagenumber/{pageNumber}/pagesize/{pageSize}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_all_budgets(
        self,
        pocket_id: Annotated[StrictStr, Field(description="The pocket account id Validations: - pocket_account_id must be greater than 0")],
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        milestone_id: Annotated[StrictStr, Field(description="The milestone id Validations: - milestone_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetAllBudgetsResponse:
        """get all budgets

        This endpoint returns all budgets

        :param pocket_id: The pocket account id Validations: - pocket_account_id must be greater than 0 (required)
        :type pocket_id: str
        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param milestone_id: The milestone id Validations: - milestone_id must be greater than 0 (required)
        :type milestone_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_all_budgets_serialize(
            pocket_id=pocket_id,
            smart_goal_id=smart_goal_id,
            milestone_id=milestone_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAllBudgetsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_all_budgets_with_http_info(
        self,
        pocket_id: Annotated[StrictStr, Field(description="The pocket account id Validations: - pocket_account_id must be greater than 0")],
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        milestone_id: Annotated[StrictStr, Field(description="The milestone id Validations: - milestone_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetAllBudgetsResponse]:
        """get all budgets

        This endpoint returns all budgets

        :param pocket_id: The pocket account id Validations: - pocket_account_id must be greater than 0 (required)
        :type pocket_id: str
        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param milestone_id: The milestone id Validations: - milestone_id must be greater than 0 (required)
        :type milestone_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_all_budgets_serialize(
            pocket_id=pocket_id,
            smart_goal_id=smart_goal_id,
            milestone_id=milestone_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAllBudgetsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_all_budgets_without_preload_content(
        self,
        pocket_id: Annotated[StrictStr, Field(description="The pocket account id Validations: - pocket_account_id must be greater than 0")],
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        milestone_id: Annotated[StrictStr, Field(description="The milestone id Validations: - milestone_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get all budgets

        This endpoint returns all budgets

        :param pocket_id: The pocket account id Validations: - pocket_account_id must be greater than 0 (required)
        :type pocket_id: str
        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param milestone_id: The milestone id Validations: - milestone_id must be greater than 0 (required)
        :type milestone_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_all_budgets_serialize(
            pocket_id=pocket_id,
            smart_goal_id=smart_goal_id,
            milestone_id=milestone_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAllBudgetsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_all_budgets_serialize(
        self,
        pocket_id,
        smart_goal_id,
        milestone_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if pocket_id is not None:
            
            _query_params.append(('pocketId', pocket_id))
            
        if smart_goal_id is not None:
            
            _query_params.append(('smartGoalId', smart_goal_id))
            
        if milestone_id is not None:
            
            _query_params.append(('milestoneId', milestone_id))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/budget',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_bank_account(
        self,
        bank_account_id: Annotated[StrictStr, Field(description="The bank account id Validations: - bank_account_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBankAccountResponse:
        """get a bank account for a given user profile

        This endpoint returns the bank account if the user record id and bank account id exists example: /api/v1/bank-account?user_id=xxxxxx&&bank_account_id=xxxxxxx

        :param bank_account_id: The bank account id Validations: - bank_account_id must be greater than 0 (required)
        :type bank_account_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_bank_account_serialize(
            bank_account_id=bank_account_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_bank_account_with_http_info(
        self,
        bank_account_id: Annotated[StrictStr, Field(description="The bank account id Validations: - bank_account_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBankAccountResponse]:
        """get a bank account for a given user profile

        This endpoint returns the bank account if the user record id and bank account id exists example: /api/v1/bank-account?user_id=xxxxxx&&bank_account_id=xxxxxxx

        :param bank_account_id: The bank account id Validations: - bank_account_id must be greater than 0 (required)
        :type bank_account_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_bank_account_serialize(
            bank_account_id=bank_account_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_bank_account_without_preload_content(
        self,
        bank_account_id: Annotated[StrictStr, Field(description="The bank account id Validations: - bank_account_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get a bank account for a given user profile

        This endpoint returns the bank account if the user record id and bank account id exists example: /api/v1/bank-account?user_id=xxxxxx&&bank_account_id=xxxxxxx

        :param bank_account_id: The bank account id Validations: - bank_account_id must be greater than 0 (required)
        :type bank_account_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_bank_account_serialize(
            bank_account_id=bank_account_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBankAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_bank_account_serialize(
        self,
        bank_account_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if bank_account_id is not None:
            _path_params['bankAccountId'] = bank_account_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/bank-account/{bankAccountId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_budget(
        self,
        budget_id: Annotated[StrictStr, Field(description="The budget id Validations: - budget_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBudgetResponse:
        """get budget by id

        This endpoint returns the budget if the budget exists

        :param budget_id: The budget id Validations: - budget_id must be greater than 0 (required)
        :type budget_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_budget_serialize(
            budget_id=budget_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBudgetResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_budget_with_http_info(
        self,
        budget_id: Annotated[StrictStr, Field(description="The budget id Validations: - budget_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBudgetResponse]:
        """get budget by id

        This endpoint returns the budget if the budget exists

        :param budget_id: The budget id Validations: - budget_id must be greater than 0 (required)
        :type budget_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_budget_serialize(
            budget_id=budget_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBudgetResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_budget_without_preload_content(
        self,
        budget_id: Annotated[StrictStr, Field(description="The budget id Validations: - budget_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get budget by id

        This endpoint returns the budget if the budget exists

        :param budget_id: The budget id Validations: - budget_id must be greater than 0 (required)
        :type budget_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_budget_serialize(
            budget_id=budget_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBudgetResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_budget_serialize(
        self,
        budget_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if budget_id is not None:
            _path_params['budgetId'] = budget_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/budget/{budgetId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_category_metrics_financial_sub_profile_over_time(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        personal_finance_category_primary: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCategoryMetricsFinancialSubProfileOverTimeResponse:
        """Gets category metrics for a financial sub profile over time

        This endpoint gets category metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param personal_finance_category_primary:
        :type personal_finance_category_primary: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_category_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            personal_finance_category_primary=personal_finance_category_primary,
            month=month,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCategoryMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_category_metrics_financial_sub_profile_over_time_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        personal_finance_category_primary: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCategoryMetricsFinancialSubProfileOverTimeResponse]:
        """Gets category metrics for a financial sub profile over time

        This endpoint gets category metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param personal_finance_category_primary:
        :type personal_finance_category_primary: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_category_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            personal_finance_category_primary=personal_finance_category_primary,
            month=month,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCategoryMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_category_metrics_financial_sub_profile_over_time_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        personal_finance_category_primary: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets category metrics for a financial sub profile over time

        This endpoint gets category metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param personal_finance_category_primary:
        :type personal_finance_category_primary: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_category_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            personal_finance_category_primary=personal_finance_category_primary,
            month=month,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCategoryMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_category_metrics_financial_sub_profile_over_time_serialize(
        self,
        org_id,
        tenant_id,
        user_id,
        profile_type,
        personal_finance_category_primary,
        month,
        page_number,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if personal_finance_category_primary is not None:
            
            _query_params.append(('personalFinanceCategoryPrimary', personal_finance_category_primary))
            
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/financial-profile/category-metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_category_monthly_transaction_count(
        self,
        user_id: Annotated[StrictStr, Field(description="has to be present and defined")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        personal_finance_category_primary: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCategoryMonthlyTransactionCountResponse:
        """Get monthly transaction count by user, month, and category


        :param user_id: has to be present and defined (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param personal_finance_category_primary: optional
        :type personal_finance_category_primary: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_category_monthly_transaction_count_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            personal_finance_category_primary=personal_finance_category_primary,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCategoryMonthlyTransactionCountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_category_monthly_transaction_count_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="has to be present and defined")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        personal_finance_category_primary: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCategoryMonthlyTransactionCountResponse]:
        """Get monthly transaction count by user, month, and category


        :param user_id: has to be present and defined (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param personal_finance_category_primary: optional
        :type personal_finance_category_primary: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_category_monthly_transaction_count_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            personal_finance_category_primary=personal_finance_category_primary,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCategoryMonthlyTransactionCountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_category_monthly_transaction_count_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="has to be present and defined")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        personal_finance_category_primary: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get monthly transaction count by user, month, and category


        :param user_id: has to be present and defined (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param personal_finance_category_primary: optional
        :type personal_finance_category_primary: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_category_monthly_transaction_count_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            personal_finance_category_primary=personal_finance_category_primary,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCategoryMonthlyTransactionCountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_category_monthly_transaction_count_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        personal_finance_category_primary,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if personal_finance_category_primary is not None:
            
            _query_params.append(('personalFinanceCategoryPrimary', personal_finance_category_primary))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/category-monthly-transaction-count/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_debt_to_income_ratio(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetDebtToIncomeRatioResponse:
        """Get Debt-to-Income ratio by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_debt_to_income_ratio_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetDebtToIncomeRatioResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_debt_to_income_ratio_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetDebtToIncomeRatioResponse]:
        """Get Debt-to-Income ratio by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_debt_to_income_ratio_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetDebtToIncomeRatioResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_debt_to_income_ratio_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Debt-to-Income ratio by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_debt_to_income_ratio_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetDebtToIncomeRatioResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_debt_to_income_ratio_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/debt-to-income-ratio/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_expense_metrics(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optonal")] = None,
        personal_finance_category_primary: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetExpenseMetricsResponse:
        """Get Expense Metrics by user, month and category


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optonal
        :type month: int
        :param personal_finance_category_primary: optional
        :type personal_finance_category_primary: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_expense_metrics_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            personal_finance_category_primary=personal_finance_category_primary,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetExpenseMetricsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_expense_metrics_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optonal")] = None,
        personal_finance_category_primary: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetExpenseMetricsResponse]:
        """Get Expense Metrics by user, month and category


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optonal
        :type month: int
        :param personal_finance_category_primary: optional
        :type personal_finance_category_primary: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_expense_metrics_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            personal_finance_category_primary=personal_finance_category_primary,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetExpenseMetricsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_expense_metrics_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optonal")] = None,
        personal_finance_category_primary: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Expense Metrics by user, month and category


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optonal
        :type month: int
        :param personal_finance_category_primary: optional
        :type personal_finance_category_primary: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_expense_metrics_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            personal_finance_category_primary=personal_finance_category_primary,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetExpenseMetricsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_expense_metrics_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        personal_finance_category_primary,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if personal_finance_category_primary is not None:
            
            _query_params.append(('personalFinanceCategoryPrimary', personal_finance_category_primary))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/expenses/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_expense_metrics_financial_sub_profile_over_time(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetExpenseMetricsFinancialSubProfileOverTimeResponse:
        """Gets expense metrics for a financial sub profile over time

        This endpoint gets expense metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_expense_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetExpenseMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_expense_metrics_financial_sub_profile_over_time_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetExpenseMetricsFinancialSubProfileOverTimeResponse]:
        """Gets expense metrics for a financial sub profile over time

        This endpoint gets expense metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_expense_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetExpenseMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_expense_metrics_financial_sub_profile_over_time_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets expense metrics for a financial sub profile over time

        This endpoint gets expense metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_expense_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetExpenseMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_expense_metrics_financial_sub_profile_over_time_serialize(
        self,
        org_id,
        tenant_id,
        user_id,
        profile_type,
        month,
        page_number,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/financial-profile/expense-metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_financial_profile(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetFinancialProfileResponse:
        """Get Financial Profile by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_financial_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFinancialProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_financial_profile_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetFinancialProfileResponse]:
        """Get Financial Profile by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_financial_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFinancialProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_financial_profile_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Financial Profile by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_financial_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFinancialProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_financial_profile_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/finance-profile/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_forecast(
        self,
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetForecastResponse:
        """get forecast by id

        This endpoint returns the forecast if the forecast exists

        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_forecast_serialize(
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetForecastResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_forecast_with_http_info(
        self,
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetForecastResponse]:
        """get forecast by id

        This endpoint returns the forecast if the forecast exists

        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_forecast_serialize(
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetForecastResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_forecast_without_preload_content(
        self,
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get forecast by id

        This endpoint returns the forecast if the forecast exists

        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_forecast_serialize(
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetForecastResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_forecast_serialize(
        self,
        smart_goal_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if smart_goal_id is not None:
            _path_params['smartGoalId'] = smart_goal_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/forecast/{smartGoalId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_income_expense_ratio(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetIncomeExpenseRatioResponse:
        """Get Income Expense Ratio by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_income_expense_ratio_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIncomeExpenseRatioResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_income_expense_ratio_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetIncomeExpenseRatioResponse]:
        """Get Income Expense Ratio by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_income_expense_ratio_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIncomeExpenseRatioResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_income_expense_ratio_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Income Expense Ratio by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_income_expense_ratio_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIncomeExpenseRatioResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_income_expense_ratio_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/income-expense-ratio/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_income_metrics(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        personal_finance_category_primary: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetIncomeMetricsResponse:
        """Get Income Metrics by user, month and category


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param personal_finance_category_primary: optional
        :type personal_finance_category_primary: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_income_metrics_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            personal_finance_category_primary=personal_finance_category_primary,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIncomeMetricsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_income_metrics_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        personal_finance_category_primary: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetIncomeMetricsResponse]:
        """Get Income Metrics by user, month and category


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param personal_finance_category_primary: optional
        :type personal_finance_category_primary: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_income_metrics_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            personal_finance_category_primary=personal_finance_category_primary,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIncomeMetricsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_income_metrics_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        personal_finance_category_primary: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Income Metrics by user, month and category


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param personal_finance_category_primary: optional
        :type personal_finance_category_primary: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_income_metrics_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            personal_finance_category_primary=personal_finance_category_primary,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIncomeMetricsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_income_metrics_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        personal_finance_category_primary,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if personal_finance_category_primary is not None:
            
            _query_params.append(('personalFinanceCategoryPrimary', personal_finance_category_primary))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/income/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_income_metrics_financial_sub_profile_over_time(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetIncomeMetricsFinancialSubProfileOverTimeResponse:
        """Gets income metrics for a financial sub profile over time

        This endpoint gets expense metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_income_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIncomeMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_income_metrics_financial_sub_profile_over_time_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetIncomeMetricsFinancialSubProfileOverTimeResponse]:
        """Gets income metrics for a financial sub profile over time

        This endpoint gets expense metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_income_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIncomeMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_income_metrics_financial_sub_profile_over_time_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets income metrics for a financial sub profile over time

        This endpoint gets expense metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_income_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetIncomeMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_income_metrics_financial_sub_profile_over_time_serialize(
        self,
        org_id,
        tenant_id,
        user_id,
        profile_type,
        month,
        page_number,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/financial-profile/income-metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_investment_account(
        self,
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        investment_account_id: Annotated[StrictStr, Field(description="The investment account id Validations: - investment_account_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetInvestmentAcccountResponse:
        """get investment account by id

        This endpoint returns the investment account if the investment account exists

        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param investment_account_id: The investment account id Validations: - investment_account_id must be greater than 0 (required)
        :type investment_account_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_investment_account_serialize(
            user_id=user_id,
            investment_account_id=investment_account_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInvestmentAcccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_investment_account_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        investment_account_id: Annotated[StrictStr, Field(description="The investment account id Validations: - investment_account_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetInvestmentAcccountResponse]:
        """get investment account by id

        This endpoint returns the investment account if the investment account exists

        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param investment_account_id: The investment account id Validations: - investment_account_id must be greater than 0 (required)
        :type investment_account_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_investment_account_serialize(
            user_id=user_id,
            investment_account_id=investment_account_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInvestmentAcccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_investment_account_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        investment_account_id: Annotated[StrictStr, Field(description="The investment account id Validations: - investment_account_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get investment account by id

        This endpoint returns the investment account if the investment account exists

        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param investment_account_id: The investment account id Validations: - investment_account_id must be greater than 0 (required)
        :type investment_account_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_investment_account_serialize(
            user_id=user_id,
            investment_account_id=investment_account_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInvestmentAcccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_investment_account_serialize(
        self,
        user_id,
        investment_account_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if investment_account_id is not None:
            _path_params['investmentAccountId'] = investment_account_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/account/{userId}/investment/{investmentAccountId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_liability_account(
        self,
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        liability_account_id: Annotated[StrictStr, Field(description="The liability account id Validations: - liability_account_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetLiabilityAccountResponse:
        """get liability account by id

        This endpoint returns the liability account if the liability account exists

        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param liability_account_id: The liability account id Validations: - liability_account_id must be greater than 0 (required)
        :type liability_account_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_liability_account_serialize(
            user_id=user_id,
            liability_account_id=liability_account_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLiabilityAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_liability_account_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        liability_account_id: Annotated[StrictStr, Field(description="The liability account id Validations: - liability_account_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetLiabilityAccountResponse]:
        """get liability account by id

        This endpoint returns the liability account if the liability account exists

        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param liability_account_id: The liability account id Validations: - liability_account_id must be greater than 0 (required)
        :type liability_account_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_liability_account_serialize(
            user_id=user_id,
            liability_account_id=liability_account_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLiabilityAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_liability_account_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        liability_account_id: Annotated[StrictStr, Field(description="The liability account id Validations: - liability_account_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get liability account by id

        This endpoint returns the liability account if the liability account exists

        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param liability_account_id: The liability account id Validations: - liability_account_id must be greater than 0 (required)
        :type liability_account_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_liability_account_serialize(
            user_id=user_id,
            liability_account_id=liability_account_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLiabilityAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_liability_account_serialize(
        self,
        user_id,
        liability_account_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if liability_account_id is not None:
            _path_params['liabilityAccountId'] = liability_account_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/account/{userId}/liability/{liabilityAccountId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_link(
        self,
        link_id: Annotated[StrictStr, Field(description="The link id Validations: - link_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetLinkResponse:
        """get link by id

        This endpoint returns the link if the link exists

        :param link_id: The link id Validations: - link_id must be greater than 0 (required)
        :type link_id: str
        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_link_serialize(
            link_id=link_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLinkResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_link_with_http_info(
        self,
        link_id: Annotated[StrictStr, Field(description="The link id Validations: - link_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetLinkResponse]:
        """get link by id

        This endpoint returns the link if the link exists

        :param link_id: The link id Validations: - link_id must be greater than 0 (required)
        :type link_id: str
        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_link_serialize(
            link_id=link_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLinkResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_link_without_preload_content(
        self,
        link_id: Annotated[StrictStr, Field(description="The link id Validations: - link_id must be greater than 0")],
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get link by id

        This endpoint returns the link if the link exists

        :param link_id: The link id Validations: - link_id must be greater than 0 (required)
        :type link_id: str
        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_link_serialize(
            link_id=link_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLinkResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_link_serialize(
        self,
        link_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if link_id is not None:
            _path_params['linkId'] = link_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/link/{linkId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_links(
        self,
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetLinksResponse:
        """get links

        This endpoint returns the links

        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_links_serialize(
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLinksResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_links_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetLinksResponse]:
        """get links

        This endpoint returns the links

        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_links_serialize(
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLinksResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_links_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="The user id Validations: - user_id must be greater than 0")],
        profile_type: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get links

        This endpoint returns the links

        :param user_id: The user id Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_links_serialize(
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLinksResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_links_serialize(
        self,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/links/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_location_metrics_financial_sub_profile_over_time(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        location_city: Optional[StrictStr] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetLocationMetricsFinancialSubProfileOverTimeResponse:
        """Gets income metrics for a financial sub profile over time

        This endpoint gets location metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param location_city:
        :type location_city: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_location_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            location_city=location_city,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLocationMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_location_metrics_financial_sub_profile_over_time_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        location_city: Optional[StrictStr] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetLocationMetricsFinancialSubProfileOverTimeResponse]:
        """Gets income metrics for a financial sub profile over time

        This endpoint gets location metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param location_city:
        :type location_city: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_location_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            location_city=location_city,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLocationMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_location_metrics_financial_sub_profile_over_time_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        location_city: Optional[StrictStr] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets income metrics for a financial sub profile over time

        This endpoint gets location metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param location_city:
        :type location_city: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_location_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            location_city=location_city,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetLocationMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_location_metrics_financial_sub_profile_over_time_serialize(
        self,
        org_id,
        tenant_id,
        user_id,
        profile_type,
        month,
        location_city,
        page_number,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if month is not None:
            
            _query_params.append(('month', month))
            
        if location_city is not None:
            
            _query_params.append(('locationCity', location_city))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/financial-profile/location-metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_melody_financial_context(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMelodyFinancialContextResponse:
        """Get Melody Financial Context


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_melody_financial_context_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMelodyFinancialContextResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_melody_financial_context_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMelodyFinancialContextResponse]:
        """Get Melody Financial Context


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_melody_financial_context_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMelodyFinancialContextResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_melody_financial_context_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Melody Financial Context


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_melody_financial_context_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMelodyFinancialContextResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_melody_financial_context_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/melody-financial-context/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_merchant_metrics_financial_sub_profile_over_time(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        merchant_name: Optional[StrictStr] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMerchantMetricsFinancialSubProfileOverTimeResponse:
        """Gets merchant metrics for a financial sub profile over time

        This endpoint gets merchant metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param merchant_name:
        :type merchant_name: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchant_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            merchant_name=merchant_name,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMerchantMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_merchant_metrics_financial_sub_profile_over_time_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        merchant_name: Optional[StrictStr] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMerchantMetricsFinancialSubProfileOverTimeResponse]:
        """Gets merchant metrics for a financial sub profile over time

        This endpoint gets merchant metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param merchant_name:
        :type merchant_name: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchant_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            merchant_name=merchant_name,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMerchantMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_merchant_metrics_financial_sub_profile_over_time_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        user_id: Optional[StrictStr] = None,
        profile_type: Optional[StrictStr] = None,
        month: Optional[StrictInt] = None,
        merchant_name: Optional[StrictStr] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets merchant metrics for a financial sub profile over time

        This endpoint gets merchant metrics for a financial sub profile over time

        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param user_id:
        :type user_id: str
        :param profile_type:
        :type profile_type: str
        :param month:
        :type month: int
        :param merchant_name:
        :type merchant_name: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchant_metrics_financial_sub_profile_over_time_serialize(
            org_id=org_id,
            tenant_id=tenant_id,
            user_id=user_id,
            profile_type=profile_type,
            month=month,
            merchant_name=merchant_name,
            page_number=page_number,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMerchantMetricsFinancialSubProfileOverTimeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_merchant_metrics_financial_sub_profile_over_time_serialize(
        self,
        org_id,
        tenant_id,
        user_id,
        profile_type,
        month,
        merchant_name,
        page_number,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if month is not None:
            
            _query_params.append(('month', month))
            
        if merchant_name is not None:
            
            _query_params.append(('merchantName', merchant_name))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/financial-profile/merchant-metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_merchant_monthly_expenditure(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        merchant_name: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMerchantMonthlyExpenditureResponse:
        """Get Merchant Monthly Expenditure by user, month and merchant name


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param merchant_name: optional
        :type merchant_name: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchant_monthly_expenditure_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            merchant_name=merchant_name,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMerchantMonthlyExpenditureResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_merchant_monthly_expenditure_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        merchant_name: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMerchantMonthlyExpenditureResponse]:
        """Get Merchant Monthly Expenditure by user, month and merchant name


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param merchant_name: optional
        :type merchant_name: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchant_monthly_expenditure_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            merchant_name=merchant_name,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMerchantMonthlyExpenditureResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_merchant_monthly_expenditure_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        merchant_name: Annotated[Optional[StrictStr], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Merchant Monthly Expenditure by user, month and merchant name


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param merchant_name: optional
        :type merchant_name: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchant_monthly_expenditure_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            merchant_name=merchant_name,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMerchantMonthlyExpenditureResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_merchant_monthly_expenditure_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        merchant_name,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if merchant_name is not None:
            
            _query_params.append(('merchantName', merchant_name))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/merchant-monthly-expenditure/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_milestone(
        self,
        milestone_id: Annotated[StrictStr, Field(description="The milestone id Validations: - milestone_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMilestoneResponse:
        """get milestone by id

        This endpoint returns the milestone if the milestone exists

        :param milestone_id: The milestone id Validations: - milestone_id must be greater than 0 (required)
        :type milestone_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestone_serialize(
            milestone_id=milestone_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestoneResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_milestone_with_http_info(
        self,
        milestone_id: Annotated[StrictStr, Field(description="The milestone id Validations: - milestone_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMilestoneResponse]:
        """get milestone by id

        This endpoint returns the milestone if the milestone exists

        :param milestone_id: The milestone id Validations: - milestone_id must be greater than 0 (required)
        :type milestone_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestone_serialize(
            milestone_id=milestone_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestoneResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_milestone_without_preload_content(
        self,
        milestone_id: Annotated[StrictStr, Field(description="The milestone id Validations: - milestone_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get milestone by id

        This endpoint returns the milestone if the milestone exists

        :param milestone_id: The milestone id Validations: - milestone_id must be greater than 0 (required)
        :type milestone_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestone_serialize(
            milestone_id=milestone_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestoneResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_milestone_serialize(
        self,
        milestone_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if milestone_id is not None:
            _path_params['milestoneId'] = milestone_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/milestone/{milestoneId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_milestones(
        self,
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMilestonesBySmartGoalIdResponse:
        """get milestones by smart goal id

        This endpoint returns the milestones if the smart goal exists

        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestones_serialize(
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestonesBySmartGoalIdResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_milestones_with_http_info(
        self,
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMilestonesBySmartGoalIdResponse]:
        """get milestones by smart goal id

        This endpoint returns the milestones if the smart goal exists

        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestones_serialize(
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestonesBySmartGoalIdResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_milestones_without_preload_content(
        self,
        smart_goal_id: Annotated[StrictStr, Field(description="The smart goal id Validations: - smart_goal_id must be greater than 0")],
        user_id: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="Type of financial user profile")],
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get milestones by smart goal id

        This endpoint returns the milestones if the smart goal exists

        :param smart_goal_id: The smart goal id Validations: - smart_goal_id must be greater than 0 (required)
        :type smart_goal_id: str
        :param user_id: (required)
        :type user_id: str
        :param profile_type: Type of financial user profile (required)
        :type profile_type: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestones_serialize(
            smart_goal_id=smart_goal_id,
            user_id=user_id,
            profile_type=profile_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestonesBySmartGoalIdResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_milestones_serialize(
        self,
        smart_goal_id,
        user_id,
        profile_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if smart_goal_id is not None:
            _path_params['smartGoalId'] = smart_goal_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/milestone/smart-goal/{smartGoalId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_monthly_balance(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMonthlyBalanceResponse:
        """Get Monthly Balance by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_balance_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyBalanceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_monthly_balance_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMonthlyBalanceResponse]:
        """Get Monthly Balance by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_balance_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyBalanceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_monthly_balance_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Annotated[Optional[StrictInt], Field(description="optional")] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Monthly Balance by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month: optional
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_balance_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyBalanceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_monthly_balance_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/monthly-balance/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_monthly_expenditure(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMonthlyExpenditureResponse:
        """Get Monthly Expenditure by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_expenditure_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyExpenditureResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_monthly_expenditure_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMonthlyExpenditureResponse]:
        """Get Monthly Expenditure by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_expenditure_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyExpenditureResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_monthly_expenditure_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Monthly Expenditure by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_expenditure_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyExpenditureResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_monthly_expenditure_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/monthly-expenditure/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_monthly_income(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMonthlyIncomeResponse:
        """Get Monthly Income by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_income_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyIncomeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_monthly_income_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMonthlyIncomeResponse]:
        """Get Monthly Income by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_income_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyIncomeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_monthly_income_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Monthly Income by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_income_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyIncomeResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_monthly_income_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/monthly-income/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_monthly_savings(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMonthlySavingsResponse:
        """Get Monthly Savings by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_savings_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlySavingsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_monthly_savings_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMonthlySavingsResponse]:
        """Get Monthly Savings by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_savings_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlySavingsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_monthly_savings_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Monthly Savings by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_savings_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlySavingsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_monthly_savings_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/monthly-savings/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_monthly_total_quantity_by_security_and_user(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        security_id: Optional[StrictStr] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMonthlyTotalQuantityBySecurityAndUserResponse:
        """Get Monthly Total Quantity of Security by user, month and security


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param security_id:
        :type security_id: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_total_quantity_by_security_and_user_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            security_id=security_id,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyTotalQuantityBySecurityAndUserResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_monthly_total_quantity_by_security_and_user_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        security_id: Optional[StrictStr] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMonthlyTotalQuantityBySecurityAndUserResponse]:
        """Get Monthly Total Quantity of Security by user, month and security


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param security_id:
        :type security_id: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_total_quantity_by_security_and_user_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            security_id=security_id,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyTotalQuantityBySecurityAndUserResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_monthly_total_quantity_by_security_and_user_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        security_id: Optional[StrictStr] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Monthly Total Quantity of Security by user, month and security


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param security_id:
        :type security_id: str
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_total_quantity_by_security_and_user_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            security_id=security_id,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyTotalQuantityBySecurityAndUserResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_monthly_total_quantity_by_security_and_user_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        month,
        security_id,
        page_number,
        page_size,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if month is not None:
            
            _query_params.append(('month', month))
            
        if security_id is not None:
            
            _query_params.append(('securityId', security_id))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/financial-microservice/api/v1/analytics/monthly-total-quantity-by-security-and-user/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_monthly_transaction_count(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMonthlyTransactionCountResponse:
        """Get Monthly Transaction Count by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_transaction_count_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyTransactionCountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_monthly_transaction_count_with_http_info(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMonthlyTransactionCountResponse]:
        """Get Monthly Transaction Count by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_transaction_count_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyTransactionCountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_monthly_transaction_count_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization identifier for multi-org support")],
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier for multi-tenancy support")],
        month: Optional[StrictInt] = None,
        page_number: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of items to return per page.")] = None,
        profile_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Monthly Transaction Count by user and month


        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization identifier for multi-org support (required)
        :type org_id: str
        :param tenant_id: Tenant identifier for multi-tenancy support (required)
        :type tenant_id: str
        :param month:
        :type month: int
        :param page_number:
        :type page_number: str
        :param page_size: Number of items to return per page.
        :type page_size: str
        :param profile_type:
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_monthly_transaction_count_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            month=month,
            page_number=page_number,
            page_size=page_size,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMonthlyTransactionCountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
     