# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = 'django-simple-pwa'
copyright = '2021, Nima Esmaeili'
author = 'Nima Esmaeili'

# The full version, including alpha/beta/rc tags
release = '2021'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'fa'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']


html_css_files = [
	'css/custom.css',
	'fonts/css/sahel.css',
	
]

html_font_files = [
	'fonts/sahel/Sahel-Black-FD.eot',
	'fonts/sahel/Sahel-Black-FD.ttf',
	'fonts/sahel/Sahel-Black-FD.woff',
	'fonts/sahel/Sahel-Black-FD.woff2',

	'fonts/sahel/Sahel-Bold-FD.eot',
	'fonts/sahel/Sahel-Bold-FD.ttf',
	'fonts/sahel/Sahel-Bold-FD.woff',
	'fonts/sahel/Sahel-Bold-FD.woff2',

	'fonts/sahel/Sahel-FD.eot',
	'fonts/sahel/Sahel-FD.ttf',
	'fonts/sahel/Sahel-FD.woff',
	'fonts/sahel/Sahel-FD.woff2',

	'fonts/sahel/Sahel-Light-FD.eot',
	'fonts/sahel/Sahel-Light-FD.ttf',
	'fonts/sahel/Sahel-Light-FD.woff',
	'fonts/sahel/Sahel-Light-FD.woff2',

	'fonts/sahel/Sahel-SemiBold-FD.eot',
	'fonts/sahel/Sahel-SemiBold-FD.ttf',
	'fonts/sahel/Sahel-SemiBold-FD.woff',
	'fonts/sahel/Sahel-SemiBold-FD.woff2',
	
]



extensions = [
	'sphinx.ext.autosectionlabel',
	
]