"""Support for KNX scenes."""
from typing import Any

from xknx.devices import Scene as XknxScene

from openpeerpower.components.scene import Scene

from .const import DOMAIN
from .knx_entity import KnxEntity


async def async_setup_platform(opp, config, async_add_entities, discovery_info=None):
    """Set up the scenes for KNX platform."""
    entities = []
    for device in opp.data[DOMAIN].xknx.devices:
        if isinstance(device, XknxScene):
            entities.append(KNXScene(device))
    async_add_entities(entities)


class KNXScene(KnxEntity, Scene):
    """Representation of a KNX scene."""

    def __init__(self, device: XknxScene):
        """Init KNX scene."""
        super().__init__(device)

    async def async_activate(self, **kwargs: Any) -> None:
        """Activate the scene."""
        await self._device.run()
