"""Config flow for AWS component."""

from openpeerpower import config_entries

from .const import DOMAIN


@config_entries.HANDLERS.register(DOMAIN)
class AWSFlowHandler(config_entries.ConfigFlow):
    """Handle a config flow."""

    VERSION = 1
    CONNECTION_CLASS = config_entries.CONN_CLASS_CLOUD_PUSH

    async def async_step_import(self, user_input):
        """Import a config entry."""
        if self._async_current_entries():
            return self.async_abort(reason="single_instance_allowed")

        return self.async_create_entry(title="configuration.yaml", data=user_input)
