##
# File:    BirdSchemaDef.py
# Author:  J. Westbrook
# Date:    04-Jan-2013
# Version: 0.001 Initial version
#
# Updates:
##
"""
Database schema defintions for Bird PRD/FAMILY reference data.

"""
__docformat__ = "restructuredtext en"
__author__    = "John Westbrook"
__email__     = "jwest@rcsb.rutgers.edu"
__license__   = "Creative Commons Attribution 3.0 Unported"
__version__   = "V0.001"

import sys
from wwpdb.utils.db.SchemaDefBase import SchemaDefBase


class BirdSchemaDef(SchemaDefBase):
    """ A data class containing schema definitions for deposition related messages.
    """
    _databaseName="prdv4"
    _schemaDefDict ={
        'PDBX_FAMILY_PRD_AUDIT': {'ATTRIBUTES': {'ACTION_TYPE': 'action_type',
                                          'ANNOTATOR': 'annotator',
                                          'DATE': 'date',
                                          'DB_ID': 'db_id',
                                          'DETAILS': 'details',
                                          'FAMILY_PRD_ID': 'family_prd_id',
                                          'PROCESSING_SITE': 'processing_site'},
                           'ATTRIBUTE_INFO': {'ACTION_TYPE': {'NULLABLE': False,
                                                              'ORDER': 7,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                              'ANNOTATOR': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                              'DATE': {'NULLABLE': False,
                                                       'ORDER': 3,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'DATETIME',
                                                       'WIDTH': 15},
                                              'DB_ID': {'NULLABLE': False,
                                                        'ORDER': 1,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                              'DETAILS': {'NULLABLE': True,
                                                          'ORDER': 6,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                              'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                              'PROCESSING_SITE': {'NULLABLE': True,
                                                                  'ORDER': 5,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ACTION_TYPE': ('pdbx_family_prd_audit', 'action_type', None, None),
                                             'ANNOTATOR': ('pdbx_family_prd_audit', 'annotator', None, None),
                                             'DATE': ('pdbx_family_prd_audit', 'date', None, None),
                                             'DB_ID': (None, None, 'datablockid()', None),
                                             'DETAILS': ('pdbx_family_prd_audit', 'details', None, None),
                                             'FAMILY_PRD_ID': ('pdbx_family_prd_audit', 'family_prd_id', None, None),
                                             'PROCESSING_SITE': ('pdbx_family_prd_audit',
                                                                 'processing_site',
                                                                 None,
                                                                 None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID', 'DATE', 'ACTION_TYPE'),
                                              'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'pdbx_family_prd_audit': {'ATTRIBUTES': ('family_prd_id',
                                                                                          'date',
                                                                                          'action_type'),
                                                                           'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                           'TABLE_ID': 'PDBX_FAMILY_PRD_AUDIT',
                           'TABLE_NAME': 'pdbx_family_prd_audit',
                           'TABLE_TYPE': 'transactional'},
 'PDBX_PRD_AUDIT': {'ATTRIBUTES': {'ACTION_TYPE': 'action_type',
                                   'ANNOTATOR': 'annotator',
                                   'DATE': 'date',
                                   'DB_ID': 'db_id',
                                   'DETAILS': 'details',
                                   'PRD_ID': 'prd_id',
                                   'PROCESSING_SITE': 'processing_site'},
                    'ATTRIBUTE_INFO': {'ACTION_TYPE': {'NULLABLE': False,
                                                       'ORDER': 7,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 80},
                                       'ANNOTATOR': {'NULLABLE': True,
                                                     'ORDER': 4,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                       'DATE': {'NULLABLE': False,
                                                'ORDER': 3,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'DATETIME',
                                                'WIDTH': 15},
                                       'DB_ID': {'NULLABLE': False,
                                                 'ORDER': 1,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': True,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 10},
                                       'DETAILS': {'NULLABLE': True,
                                                   'ORDER': 6,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'VARCHAR',
                                                   'WIDTH': 200},
                                       'PRD_ID': {'NULLABLE': False,
                                                  'ORDER': 2,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': True,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 10},
                                       'PROCESSING_SITE': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10}},
                    'ATTRIBUTE_MAP': {'ACTION_TYPE': ('pdbx_prd_audit', 'action_type', None, None),
                                      'ANNOTATOR': ('pdbx_prd_audit', 'annotator', None, None),
                                      'DATE': ('pdbx_prd_audit', 'date', None, None),
                                      'DB_ID': (None, None, 'datablockid()', None),
                                      'DETAILS': ('pdbx_prd_audit', 'details', None, None),
                                      'PRD_ID': ('pdbx_prd_audit', 'prd_id', None, None),
                                      'PROCESSING_SITE': ('pdbx_prd_audit', 'processing_site', None, None)},
                    'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'DATE', 'ACTION_TYPE'), 'TYPE': 'UNIQUE'},
                                's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                    'MAP_MERGE_INDICES': {'pdbx_prd_audit': {'ATTRIBUTES': ('prd_id', 'date', 'action_type'),
                                                             'TYPE': 'EQUI-JOIN'}},
                    'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                    'TABLE_ID': 'PDBX_PRD_AUDIT',
                    'TABLE_NAME': 'pdbx_prd_audit',
                    'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_LINK': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                               'ATOM_ID_2': 'atom_id_2',
                                               'COMPONENT_1': 'component_1',
                                               'COMPONENT_2': 'component_2',
                                               'COMP_ID_1': 'comp_id_1',
                                               'COMP_ID_2': 'comp_id_2',
                                               'DB_ID': 'db_id',
                                               'DETAILS': 'details',
                                               'ENTITY_SEQ_NUM_1': 'entity_seq_num_1',
                                               'ENTITY_SEQ_NUM_2': 'entity_seq_num_2',
                                               'LINK_CLASS': 'link_class',
                                               'LINK_ID': 'link_id',
                                               'NONPOLY_RES_NUM_1': 'nonpoly_res_num_1',
                                               'NONPOLY_RES_NUM_2': 'nonpoly_res_num_2',
                                               'PRD_ID': 'prd_id',
                                               'REF_ENTITY_ID_1': 'ref_entity_id_1',
                                               'REF_ENTITY_ID_2': 'ref_entity_id_2',
                                               'VALUE_ORDER': 'value_order'},
                                'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': True,
                                                                 'ORDER': 11,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 6},
                                                   'ATOM_ID_2': {'NULLABLE': True,
                                                                 'ORDER': 12,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                   'COMPONENT_1': {'NULLABLE': True,
                                                                   'ORDER': 14,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                                   'COMPONENT_2': {'NULLABLE': True,
                                                                   'ORDER': 15,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                                   'COMP_ID_1': {'NULLABLE': True,
                                                                 'ORDER': 9,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                   'COMP_ID_2': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                   'DB_ID': {'NULLABLE': False,
                                                             'ORDER': 1,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                                   'DETAILS': {'NULLABLE': True,
                                                               'ORDER': 4,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                   'ENTITY_SEQ_NUM_1': {'NULLABLE': True,
                                                                        'ORDER': 7,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': 10},
                                                   'ENTITY_SEQ_NUM_2': {'NULLABLE': True,
                                                                        'ORDER': 8,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': 10},
                                                   'LINK_CLASS': {'NULLABLE': True,
                                                                  'ORDER': 18,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                   'LINK_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                                   'NONPOLY_RES_NUM_1': {'NULLABLE': True,
                                                                         'ORDER': 16,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                   'NONPOLY_RES_NUM_2': {'NULLABLE': True,
                                                                         'ORDER': 17,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                   'PRD_ID': {'NULLABLE': False,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                                   'REF_ENTITY_ID_1': {'NULLABLE': True,
                                                                       'ORDER': 5,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                   'REF_ENTITY_ID_2': {'NULLABLE': True,
                                                                       'ORDER': 6,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                   'VALUE_ORDER': {'NULLABLE': True,
                                                                   'ORDER': 13,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'ATOM_ID_1': ('pdbx_reference_entity_link',
                                                                'atom_id_1',
                                                                None,
                                                                None),
                                                  'ATOM_ID_2': ('pdbx_reference_entity_link',
                                                                'atom_id_2',
                                                                None,
                                                                None),
                                                  'COMPONENT_1': ('pdbx_reference_entity_link',
                                                                  'component_1',
                                                                  None,
                                                                  None),
                                                  'COMPONENT_2': ('pdbx_reference_entity_link',
                                                                  'component_2',
                                                                  None,
                                                                  None),
                                                  'COMP_ID_1': ('pdbx_reference_entity_link',
                                                                'comp_id_1',
                                                                None,
                                                                None),
                                                  'COMP_ID_2': ('pdbx_reference_entity_link',
                                                                'comp_id_2',
                                                                None,
                                                                None),
                                                  'DB_ID': (None, None, 'datablockid()', None),
                                                  'DETAILS': ('pdbx_reference_entity_link', 'details', None, None),
                                                  'ENTITY_SEQ_NUM_1': ('pdbx_reference_entity_link',
                                                                       'entity_seq_num_1',
                                                                       None,
                                                                       None),
                                                  'ENTITY_SEQ_NUM_2': ('pdbx_reference_entity_link',
                                                                       'entity_seq_num_2',
                                                                       None,
                                                                       None),
                                                  'LINK_CLASS': ('pdbx_reference_entity_link',
                                                                 'link_class',
                                                                 None,
                                                                 None),
                                                  'LINK_ID': ('pdbx_reference_entity_link', 'link_id', None, None),
                                                  'NONPOLY_RES_NUM_1': ('pdbx_reference_entity_link',
                                                                        'nonpoly_res_num_1',
                                                                        None,
                                                                        None),
                                                  'NONPOLY_RES_NUM_2': ('pdbx_reference_entity_link',
                                                                        'nonpoly_res_num_2',
                                                                        None,
                                                                        None),
                                                  'PRD_ID': ('pdbx_reference_entity_link', 'prd_id', None, None),
                                                  'REF_ENTITY_ID_1': ('pdbx_reference_entity_link',
                                                                      'ref_entity_id_1',
                                                                      None,
                                                                      None),
                                                  'REF_ENTITY_ID_2': ('pdbx_reference_entity_link',
                                                                      'ref_entity_id_2',
                                                                      None,
                                                                      None),
                                                  'VALUE_ORDER': ('pdbx_reference_entity_link',
                                                                  'value_order',
                                                                  None,
                                                                  None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'LINK_ID', 'PRD_ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'pdbx_reference_entity_link': {'ATTRIBUTES': ('link_id',
                                                                                                    'prd_id'),
                                                                                     'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                'TABLE_ID': 'PDBX_REFERENCE_ENTITY_LINK',
                                'TABLE_NAME': 'pdbx_reference_entity_link',
                                'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_LIST': {'ATTRIBUTES': {'COMPONENT_ID': 'component_id',
                                               'DB_ID': 'db_id',
                                               'DETAILS': 'details',
                                               'PRD_ID': 'prd_id',
                                               'REF_ENTITY_ID': 'ref_entity_id',
                                               'TYPE': 'type'},
                                'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                                    'ORDER': 6,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                                   'DB_ID': {'NULLABLE': False,
                                                             'ORDER': 1,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                                   'DETAILS': {'NULLABLE': True,
                                                               'ORDER': 5,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                   'PRD_ID': {'NULLABLE': False,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                                   'REF_ENTITY_ID': {'NULLABLE': False,
                                                                     'ORDER': 3,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                   'TYPE': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80}},
                                'ATTRIBUTE_MAP': {'COMPONENT_ID': ('pdbx_reference_entity_list',
                                                                   'component_id',
                                                                   None,
                                                                   None),
                                                  'DB_ID': (None, None, 'datablockid()', None),
                                                  'DETAILS': ('pdbx_reference_entity_list', 'details', None, None),
                                                  'PRD_ID': ('pdbx_reference_entity_list', 'prd_id', None, None),
                                                  'REF_ENTITY_ID': ('pdbx_reference_entity_list',
                                                                    'ref_entity_id',
                                                                    None,
                                                                    None),
                                                  'TYPE': ('pdbx_reference_entity_list', 'type', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                  'PRD_ID',
                                                                  'REF_ENTITY_ID',
                                                                  'COMPONENT_ID'),
                                                   'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'pdbx_reference_entity_list': {'ATTRIBUTES': ('prd_id',
                                                                                                    'ref_entity_id',
                                                                                                    'component_id'),
                                                                                     'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                'TABLE_ID': 'PDBX_REFERENCE_ENTITY_LIST',
                                'TABLE_NAME': 'pdbx_reference_entity_list',
                                'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_NONPOLY': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                  'DB_ID': 'db_id',
                                                  'DETAILS': 'details',
                                                  'NAME': 'name',
                                                  'PRD_ID': 'prd_id',
                                                  'REF_ENTITY_ID': 'ref_entity_id'},
                                   'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                       'ORDER': 6,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                      'DB_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                      'DETAILS': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                      'NAME': {'NULLABLE': True,
                                                               'ORDER': 5,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 255},
                                                      'PRD_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                      'REF_ENTITY_ID': {'NULLABLE': False,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10}},
                                   'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_entity_nonpoly',
                                                                      'chem_comp_id',
                                                                      None,
                                                                      None),
                                                     'DB_ID': (None, None, 'datablockid()', None),
                                                     'DETAILS': ('pdbx_reference_entity_nonpoly',
                                                                 'details',
                                                                 None,
                                                                 None),
                                                     'NAME': ('pdbx_reference_entity_nonpoly', 'name', None, None),
                                                     'PRD_ID': ('pdbx_reference_entity_nonpoly',
                                                                'prd_id',
                                                                None,
                                                                None),
                                                     'REF_ENTITY_ID': ('pdbx_reference_entity_nonpoly',
                                                                       'ref_entity_id',
                                                                       None,
                                                                       None)},
                                   'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'REF_ENTITY_ID'),
                                                      'TYPE': 'UNIQUE'},
                                               's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                   'MAP_MERGE_INDICES': {'pdbx_reference_entity_nonpoly': {'ATTRIBUTES': ('prd_id',
                                                                                                          'ref_entity_id'),
                                                                                           'TYPE': 'EQUI-JOIN'}},
                                   'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                   'TABLE_ID': 'PDBX_REFERENCE_ENTITY_NONPOLY',
                                   'TABLE_NAME': 'pdbx_reference_entity_nonpoly',
                                   'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_POLY': {'ATTRIBUTES': {'DB_CODE': 'db_code',
                                               'DB_ID': 'db_id',
                                               'DB_NAME': 'db_name',
                                               'PRD_ID': 'prd_id',
                                               'REF_ENTITY_ID': 'ref_entity_id',
                                               'TYPE': 'type'},
                                'ATTRIBUTE_INFO': {'DB_CODE': {'NULLABLE': True,
                                                               'ORDER': 5,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                   'DB_ID': {'NULLABLE': False,
                                                             'ORDER': 1,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                                   'DB_NAME': {'NULLABLE': True,
                                                               'ORDER': 6,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                   'PRD_ID': {'NULLABLE': False,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                                   'REF_ENTITY_ID': {'NULLABLE': False,
                                                                     'ORDER': 3,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                   'TYPE': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80}},
                                'ATTRIBUTE_MAP': {'DB_CODE': ('pdbx_reference_entity_poly', 'db_code', None, None),
                                                  'DB_ID': (None, None, 'datablockid()', None),
                                                  'DB_NAME': ('pdbx_reference_entity_poly', 'db_name', None, None),
                                                  'PRD_ID': ('pdbx_reference_entity_poly', 'prd_id', None, None),
                                                  'REF_ENTITY_ID': ('pdbx_reference_entity_poly',
                                                                    'ref_entity_id',
                                                                    None,
                                                                    None),
                                                  'TYPE': ('pdbx_reference_entity_poly', 'type', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'REF_ENTITY_ID'),
                                                   'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'pdbx_reference_entity_poly': {'ATTRIBUTES': ('prd_id',
                                                                                                    'ref_entity_id'),
                                                                                     'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                'TABLE_ID': 'PDBX_REFERENCE_ENTITY_POLY',
                                'TABLE_NAME': 'pdbx_reference_entity_poly',
                                'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_POLY_LINK': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                                    'ATOM_ID_2': 'atom_id_2',
                                                    'COMPONENT_ID': 'component_id',
                                                    'COMP_ID_1': 'comp_id_1',
                                                    'COMP_ID_2': 'comp_id_2',
                                                    'DB_ID': 'db_id',
                                                    'DETAILS': 'details',
                                                    'ENTITY_SEQ_NUM_1': 'entity_seq_num_1',
                                                    'ENTITY_SEQ_NUM_2': 'entity_seq_num_2',
                                                    'INSERT_CODE_1': 'insert_code_1',
                                                    'INSERT_CODE_2': 'insert_code_2',
                                                    'LINK_ID': 'link_id',
                                                    'PRD_ID': 'prd_id',
                                                    'REF_ENTITY_ID': 'ref_entity_id',
                                                    'VALUE_ORDER': 'value_order'},
                                     'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': True,
                                                                      'ORDER': 11,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 6},
                                                        'ATOM_ID_2': {'NULLABLE': True,
                                                                      'ORDER': 12,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                        'COMPONENT_ID': {'NULLABLE': False,
                                                                         'ORDER': 6,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'INT',
                                                                         'WIDTH': 10},
                                                        'COMP_ID_1': {'NULLABLE': True,
                                                                      'ORDER': 9,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                        'COMP_ID_2': {'NULLABLE': True,
                                                                      'ORDER': 10,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                        'DB_ID': {'NULLABLE': False,
                                                                  'ORDER': 1,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                        'DETAILS': {'NULLABLE': True,
                                                                    'ORDER': 4,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                                        'ENTITY_SEQ_NUM_1': {'NULLABLE': True,
                                                                             'ORDER': 7,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'INT',
                                                                             'WIDTH': 10},
                                                        'ENTITY_SEQ_NUM_2': {'NULLABLE': True,
                                                                             'ORDER': 8,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'INT',
                                                                             'WIDTH': 10},
                                                        'INSERT_CODE_1': {'NULLABLE': True,
                                                                          'ORDER': 13,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                        'INSERT_CODE_2': {'NULLABLE': True,
                                                                          'ORDER': 14,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                        'LINK_ID': {'NULLABLE': False,
                                                                    'ORDER': 2,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                                        'PRD_ID': {'NULLABLE': False,
                                                                   'ORDER': 3,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                        'REF_ENTITY_ID': {'NULLABLE': False,
                                                                          'ORDER': 5,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                        'VALUE_ORDER': {'NULLABLE': True,
                                                                        'ORDER': 15,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10}},
                                     'ATTRIBUTE_MAP': {'ATOM_ID_1': ('pdbx_reference_entity_poly_link',
                                                                     'atom_id_1',
                                                                     None,
                                                                     None),
                                                       'ATOM_ID_2': ('pdbx_reference_entity_poly_link',
                                                                     'atom_id_2',
                                                                     None,
                                                                     None),
                                                       'COMPONENT_ID': ('pdbx_reference_entity_poly_link',
                                                                        'component_id',
                                                                        None,
                                                                        None),
                                                       'COMP_ID_1': ('pdbx_reference_entity_poly_link',
                                                                     'comp_id_1',
                                                                     None,
                                                                     None),
                                                       'COMP_ID_2': ('pdbx_reference_entity_poly_link',
                                                                     'comp_id_2',
                                                                     None,
                                                                     None),
                                                       'DB_ID': (None, None, 'datablockid()', None),
                                                       'DETAILS': ('pdbx_reference_entity_poly_link',
                                                                   'details',
                                                                   None,
                                                                   None),
                                                       'ENTITY_SEQ_NUM_1': ('pdbx_reference_entity_poly_link',
                                                                            'entity_seq_num_1',
                                                                            None,
                                                                            None),
                                                       'ENTITY_SEQ_NUM_2': ('pdbx_reference_entity_poly_link',
                                                                            'entity_seq_num_2',
                                                                            None,
                                                                            None),
                                                       'INSERT_CODE_1': ('pdbx_reference_entity_poly_link',
                                                                         'insert_code_1',
                                                                         None,
                                                                         None),
                                                       'INSERT_CODE_2': ('pdbx_reference_entity_poly_link',
                                                                         'insert_code_2',
                                                                         None,
                                                                         None),
                                                       'LINK_ID': ('pdbx_reference_entity_poly_link',
                                                                   'link_id',
                                                                   None,
                                                                   None),
                                                       'PRD_ID': ('pdbx_reference_entity_poly_link',
                                                                  'prd_id',
                                                                  None,
                                                                  None),
                                                       'REF_ENTITY_ID': ('pdbx_reference_entity_poly_link',
                                                                         'ref_entity_id',
                                                                         None,
                                                                         None),
                                                       'VALUE_ORDER': ('pdbx_reference_entity_poly_link',
                                                                       'value_order',
                                                                       None,
                                                                       None)},
                                     'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                       'LINK_ID',
                                                                       'PRD_ID',
                                                                       'REF_ENTITY_ID',
                                                                       'COMPONENT_ID'),
                                                        'TYPE': 'UNIQUE'},
                                                 's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                     'MAP_MERGE_INDICES': {'pdbx_reference_entity_poly_link': {'ATTRIBUTES': ('link_id',
                                                                                                              'prd_id',
                                                                                                              'ref_entity_id',
                                                                                                              'component_id'),
                                                                                               'TYPE': 'EQUI-JOIN'}},
                                     'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                     'TABLE_ID': 'PDBX_REFERENCE_ENTITY_POLY_LINK',
                                     'TABLE_NAME': 'pdbx_reference_entity_poly_link',
                                     'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_POLY_SEQ': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                   'HETERO': 'hetero',
                                                   'MON_ID': 'mon_id',
                                                   'NUM': 'num',
                                                   'OBSERVED': 'observed',
                                                   'PARENT_MON_ID': 'parent_mon_id',
                                                   'PRD_ID': 'prd_id',
                                                   'REF_ENTITY_ID': 'ref_entity_id'},
                                    'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                       'HETERO': {'NULLABLE': False,
                                                                  'ORDER': 8,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                       'MON_ID': {'NULLABLE': False,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                       'NUM': {'NULLABLE': False,
                                                               'ORDER': 6,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                                       'OBSERVED': {'NULLABLE': True,
                                                                    'ORDER': 7,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                       'PARENT_MON_ID': {'NULLABLE': True,
                                                                         'ORDER': 5,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                       'PRD_ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                       'REF_ENTITY_ID': {'NULLABLE': False,
                                                                         'ORDER': 3,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10}},
                                    'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                      'HETERO': ('pdbx_reference_entity_poly_seq',
                                                                 'hetero',
                                                                 None,
                                                                 None),
                                                      'MON_ID': ('pdbx_reference_entity_poly_seq',
                                                                 'mon_id',
                                                                 None,
                                                                 None),
                                                      'NUM': ('pdbx_reference_entity_poly_seq', 'num', None, None),
                                                      'OBSERVED': ('pdbx_reference_entity_poly_seq',
                                                                   'observed',
                                                                   None,
                                                                   None),
                                                      'PARENT_MON_ID': ('pdbx_reference_entity_poly_seq',
                                                                        'parent_mon_id',
                                                                        None,
                                                                        None),
                                                      'PRD_ID': ('pdbx_reference_entity_poly_seq',
                                                                 'prd_id',
                                                                 None,
                                                                 None),
                                                      'REF_ENTITY_ID': ('pdbx_reference_entity_poly_seq',
                                                                        'ref_entity_id',
                                                                        None,
                                                                        None)},
                                    'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                      'PRD_ID',
                                                                      'REF_ENTITY_ID',
                                                                      'MON_ID',
                                                                      'NUM',
                                                                      'HETERO'),
                                                       'TYPE': 'UNIQUE'},
                                                's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                    'MAP_MERGE_INDICES': {'pdbx_reference_entity_poly_seq': {'ATTRIBUTES': ('prd_id',
                                                                                                            'ref_entity_id',
                                                                                                            'mon_id',
                                                                                                            'num',
                                                                                                            'hetero'),
                                                                                             'TYPE': 'EQUI-JOIN'}},
                                    'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                    'TABLE_ID': 'PDBX_REFERENCE_ENTITY_POLY_SEQ',
                                    'TABLE_NAME': 'pdbx_reference_entity_poly_seq',
                                    'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_SEQUENCE': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                   'NRP_FLAG': 'NRP_flag',
                                                   'ONE_LETTER_CODES': 'one_letter_codes',
                                                   'PRD_ID': 'prd_id',
                                                   'REF_ENTITY_ID': 'ref_entity_id',
                                                   'TYPE': 'type'},
                                    'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                       'NRP_FLAG': {'NULLABLE': True,
                                                                    'ORDER': 5,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                       'ONE_LETTER_CODES': {'NULLABLE': True,
                                                                            'ORDER': 6,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 80},
                                                       'PRD_ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                       'REF_ENTITY_ID': {'NULLABLE': False,
                                                                         'ORDER': 3,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                       'TYPE': {'NULLABLE': True,
                                                                'ORDER': 4,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80}},
                                    'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                      'NRP_FLAG': ('pdbx_reference_entity_sequence',
                                                                   'NRP_flag',
                                                                   None,
                                                                   None),
                                                      'ONE_LETTER_CODES': ('pdbx_reference_entity_sequence',
                                                                           'one_letter_codes',
                                                                           None,
                                                                           None),
                                                      'PRD_ID': ('pdbx_reference_entity_sequence',
                                                                 'prd_id',
                                                                 None,
                                                                 None),
                                                      'REF_ENTITY_ID': ('pdbx_reference_entity_sequence',
                                                                        'ref_entity_id',
                                                                        None,
                                                                        None),
                                                      'TYPE': ('pdbx_reference_entity_sequence', 'type', None, None)},
                                    'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'REF_ENTITY_ID'),
                                                       'TYPE': 'UNIQUE'},
                                                's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                    'MAP_MERGE_INDICES': {'pdbx_reference_entity_sequence': {'ATTRIBUTES': ('prd_id',
                                                                                                            'ref_entity_id'),
                                                                                             'TYPE': 'EQUI-JOIN'}},
                                    'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                    'TABLE_ID': 'PDBX_REFERENCE_ENTITY_SEQUENCE',
                                    'TABLE_NAME': 'pdbx_reference_entity_sequence',
                                    'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_SEQUENCE_LIST': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                        'PRD_ID': 'prd_id',
                                                        'REF_ENTITY_ID': 'ref_entity_id',
                                                        'THREE_LETTER_CODES': 'three_letter_codes',
                                                        'V_ID': 'v_id'},
                                         'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                      'ORDER': 1,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                            'PRD_ID': {'NULLABLE': False,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                            'REF_ENTITY_ID': {'NULLABLE': False,
                                                                              'ORDER': 3,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': True,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 10},
                                                            'THREE_LETTER_CODES': {'NULLABLE': True,
                                                                                   'ORDER': 5,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'VARCHAR',
                                                                                   'WIDTH': 512},
                                                            'V_ID': {'NULLABLE': False,
                                                                     'ORDER': 4,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10}},
                                         'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                           'PRD_ID': ('pdbx_reference_entity_sequence_list',
                                                                      'prd_id',
                                                                      None,
                                                                      None),
                                                           'REF_ENTITY_ID': ('pdbx_reference_entity_sequence_list',
                                                                             'ref_entity_id',
                                                                             None,
                                                                             None),
                                                           'THREE_LETTER_CODES': ('pdbx_reference_entity_sequence_list',
                                                                                  'three_letter_codes',
                                                                                  None,
                                                                                  None),
                                                           'V_ID': ('pdbx_reference_entity_sequence_list',
                                                                    'v_id',
                                                                    None,
                                                                    None)},
                                         'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                           'PRD_ID',
                                                                           'REF_ENTITY_ID',
                                                                           'V_ID'),
                                                            'TYPE': 'UNIQUE'},
                                                     's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                         'MAP_MERGE_INDICES': {'pdbx_reference_entity_sequence_list': {'ATTRIBUTES': ('prd_id',
                                                                                                                      'ref_entity_id',
                                                                                                                      'v_id'),
                                                                                                       'TYPE': 'EQUI-JOIN'}},
                                         'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                         'TABLE_ID': 'PDBX_REFERENCE_ENTITY_SEQUENCE_LIST',
                                         'TABLE_NAME': 'pdbx_reference_entity_sequence_list',
                                         'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_SRC_NAT': {'ATTRIBUTES': {'ATCC': 'atcc',
                                                  'DB_CODE': 'db_code',
                                                  'DB_ID': 'db_id',
                                                  'DB_NAME': 'db_name',
                                                  'ORDINAL': 'ordinal',
                                                  'ORGANISM_SCIENTIFIC': 'organism_scientific',
                                                  'PRD_ID': 'prd_id',
                                                  'REF_ENTITY_ID': 'ref_entity_id',
                                                  'SOURCE': 'source',
                                                  'SOURCE_ID': 'source_id',
                                                  'STRAIN': 'strain',
                                                  'TAXID': 'taxid'},
                                   'ATTRIBUTE_INFO': {'ATCC': {'NULLABLE': True,
                                                               'ORDER': 8,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                      'DB_CODE': {'NULLABLE': True,
                                                                  'ORDER': 9,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                      'DB_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                      'DB_NAME': {'NULLABLE': True,
                                                                  'ORDER': 10,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                      'ORDINAL': {'NULLABLE': False,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                                      'ORGANISM_SCIENTIFIC': {'NULLABLE': True,
                                                                              'ORDER': 5,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 200},
                                                      'PRD_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                      'REF_ENTITY_ID': {'NULLABLE': False,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                      'SOURCE': {'NULLABLE': True,
                                                                 'ORDER': 11,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                      'SOURCE_ID': {'NULLABLE': True,
                                                                    'ORDER': 12,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                                      'STRAIN': {'NULLABLE': True,
                                                                 'ORDER': 6,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                      'TAXID': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200}},
                                   'ATTRIBUTE_MAP': {'ATCC': ('pdbx_reference_entity_src_nat', 'atcc', None, None),
                                                     'DB_CODE': ('pdbx_reference_entity_src_nat',
                                                                 'db_code',
                                                                 None,
                                                                 None),
                                                     'DB_ID': (None, None, 'datablockid()', None),
                                                     'DB_NAME': ('pdbx_reference_entity_src_nat',
                                                                 'db_name',
                                                                 None,
                                                                 None),
                                                     'ORDINAL': ('pdbx_reference_entity_src_nat',
                                                                 'ordinal',
                                                                 None,
                                                                 None),
                                                     'ORGANISM_SCIENTIFIC': ('pdbx_reference_entity_src_nat',
                                                                             'organism_scientific',
                                                                             None,
                                                                             None),
                                                     'PRD_ID': ('pdbx_reference_entity_src_nat',
                                                                'prd_id',
                                                                None,
                                                                None),
                                                     'REF_ENTITY_ID': ('pdbx_reference_entity_src_nat',
                                                                       'ref_entity_id',
                                                                       None,
                                                                       None),
                                                     'SOURCE': ('pdbx_reference_entity_src_nat',
                                                                'source',
                                                                None,
                                                                None),
                                                     'SOURCE_ID': ('pdbx_reference_entity_src_nat',
                                                                   'source_id',
                                                                   None,
                                                                   None),
                                                     'STRAIN': ('pdbx_reference_entity_src_nat',
                                                                'strain',
                                                                None,
                                                                None),
                                                     'TAXID': ('pdbx_reference_entity_src_nat', 'taxid', None, None)},
                                   'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'REF_ENTITY_ID', 'ORDINAL'),
                                                      'TYPE': 'UNIQUE'},
                                               's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                   'MAP_MERGE_INDICES': {'pdbx_reference_entity_src_nat': {'ATTRIBUTES': ('prd_id',
                                                                                                          'ref_entity_id',
                                                                                                          'ordinal'),
                                                                                           'TYPE': 'EQUI-JOIN'}},
                                   'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                   'TABLE_ID': 'PDBX_REFERENCE_ENTITY_SRC_NAT',
                                   'TABLE_NAME': 'pdbx_reference_entity_src_nat',
                                   'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_ENTITY_SUBCOMPONENTS': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                        'DB_ID': 'db_id',
                                                        'PRD_ID': 'prd_id',
                                                        'SEQ': 'seq'},
                                         'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                             'ORDER': 4,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 10},
                                                            'DB_ID': {'NULLABLE': False,
                                                                      'ORDER': 1,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                            'PRD_ID': {'NULLABLE': False,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                            'SEQ': {'NULLABLE': False,
                                                                    'ORDER': 3,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200}},
                                         'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_entity_subcomponents',
                                                                            'chem_comp_id',
                                                                            None,
                                                                            None),
                                                           'DB_ID': (None, None, 'datablockid()', None),
                                                           'PRD_ID': ('pdbx_reference_entity_subcomponents',
                                                                      'prd_id',
                                                                      None,
                                                                      None),
                                                           'SEQ': ('pdbx_reference_entity_subcomponents',
                                                                   'seq',
                                                                   None,
                                                                   None)},
                                         'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'SEQ'),
                                                            'TYPE': 'UNIQUE'},
                                                     's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                         'MAP_MERGE_INDICES': {'pdbx_reference_entity_subcomponents': {'ATTRIBUTES': ('prd_id',
                                                                                                                      'seq'),
                                                                                                       'TYPE': 'EQUI-JOIN'}},
                                         'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                         'TABLE_ID': 'PDBX_REFERENCE_ENTITY_SUBCOMPONENTS',
                                         'TABLE_NAME': 'pdbx_reference_entity_subcomponents',
                                         'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_MOLECULE': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                            'CLASS': 'class',
                                            'CLASS_EVIDENCE_CODE': 'class_evidence_code',
                                            'COMPOUND_DETAILS': 'compound_details',
                                            'DB_ID': 'db_id',
                                            'DESCRIPTION': 'description',
                                            'FORMULA': 'formula',
                                            'FORMULA_WEIGHT': 'formula_weight',
                                            'NAME': 'name',
                                            'PRD_ID': 'prd_id',
                                            'RELEASE_STATUS': 'release_status',
                                            'REPLACED_BY': 'replaced_by',
                                            'REPLACES': 'replaces',
                                            'REPRESENTATIVE_PDB_ID_CODE': 'representative_PDB_id_code',
                                            'REPRESENT_AS': 'represent_as',
                                            'TYPE': 'type',
                                            'TYPE_EVIDENCE_CODE': 'type_evidence_code'},
                             'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                 'ORDER': 11,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                'CLASS': {'NULLABLE': True,
                                                          'ORDER': 7,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                                'CLASS_EVIDENCE_CODE': {'NULLABLE': True,
                                                                        'ORDER': 8,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                                'COMPOUND_DETAILS': {'NULLABLE': True,
                                                                     'ORDER': 12,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 4095},
                                                'DB_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                                'DESCRIPTION': {'NULLABLE': True,
                                                                'ORDER': 13,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 4095},
                                                'FORMULA': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                                'FORMULA_WEIGHT': {'NULLABLE': True,
                                                                   'ORDER': 3,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                'NAME': {'NULLABLE': True,
                                                         'ORDER': 9,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 1023},
                                                'PRD_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                                'RELEASE_STATUS': {'NULLABLE': True,
                                                                   'ORDER': 15,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 80},
                                                'REPLACED_BY': {'NULLABLE': True,
                                                                'ORDER': 17,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                                'REPLACES': {'NULLABLE': True,
                                                             'ORDER': 16,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                                'REPRESENTATIVE_PDB_ID_CODE': {'NULLABLE': True,
                                                                               'ORDER': 14,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 10},
                                                'REPRESENT_AS': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                                'TYPE': {'NULLABLE': True,
                                                         'ORDER': 5,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 80},
                                                'TYPE_EVIDENCE_CODE': {'NULLABLE': True,
                                                                       'ORDER': 6,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200}},
                             'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_molecule',
                                                                'chem_comp_id',
                                                                None,
                                                                None),
                                               'CLASS': ('pdbx_reference_molecule', 'class', None, None),
                                               'CLASS_EVIDENCE_CODE': ('pdbx_reference_molecule',
                                                                       'class_evidence_code',
                                                                       None,
                                                                       None),
                                               'COMPOUND_DETAILS': ('pdbx_reference_molecule',
                                                                    'compound_details',
                                                                    None,
                                                                    None),
                                               'DB_ID': (None, None, 'datablockid()', None),
                                               'DESCRIPTION': ('pdbx_reference_molecule', 'description', None, None),
                                               'FORMULA': ('pdbx_reference_molecule', 'formula', None, None),
                                               'FORMULA_WEIGHT': ('pdbx_reference_molecule',
                                                                  'formula_weight',
                                                                  None,
                                                                  None),
                                               'NAME': ('pdbx_reference_molecule', 'name', None, None),
                                               'PRD_ID': ('pdbx_reference_molecule', 'prd_id', None, None),
                                               'RELEASE_STATUS': ('pdbx_reference_molecule',
                                                                  'release_status',
                                                                  None,
                                                                  None),
                                               'REPLACED_BY': ('pdbx_reference_molecule', 'replaced_by', None, None),
                                               'REPLACES': ('pdbx_reference_molecule', 'replaces', None, None),
                                               'REPRESENTATIVE_PDB_ID_CODE': ('pdbx_reference_molecule',
                                                                              'representative_PDB_id_code',
                                                                              None,
                                                                              None),
                                               'REPRESENT_AS': ('pdbx_reference_molecule',
                                                                'represent_as',
                                                                None,
                                                                None),
                                               'TYPE': ('pdbx_reference_molecule', 'type', None, None),
                                               'TYPE_EVIDENCE_CODE': ('pdbx_reference_molecule',
                                                                      'type_evidence_code',
                                                                      None,
                                                                      None)},
                             'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID'), 'TYPE': 'UNIQUE'},
                                         's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                             'MAP_MERGE_INDICES': {'pdbx_reference_molecule': {'ATTRIBUTES': ('prd_id',),
                                                                               'TYPE': 'EQUI-JOIN'}},
                             'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                             'TABLE_ID': 'PDBX_REFERENCE_MOLECULE',
                             'TABLE_NAME': 'pdbx_reference_molecule',
                             'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_MOLECULE_ANNOTATION': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                       'DB_ID': 'db_id',
                                                       'FAMILY_PRD_ID': 'family_prd_id',
                                                       'ORDINAL': 'ordinal',
                                                       'PRD_ID': 'prd_id',
                                                       'SOURCE': 'source',
                                                       'SUPPORT': 'support',
                                                       'TEXT': 'text',
                                                       'TYPE': 'type'},
                                        'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                            'ORDER': 9,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                                           'DB_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                           'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                             'ORDER': 2,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': True,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 10},
                                                           'ORDINAL': {'NULLABLE': False,
                                                                       'ORDER': 4,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': 10},
                                                           'PRD_ID': {'NULLABLE': True,
                                                                      'ORDER': 3,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                           'SOURCE': {'NULLABLE': True,
                                                                      'ORDER': 8,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                                           'SUPPORT': {'NULLABLE': True,
                                                                       'ORDER': 7,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                                           'TEXT': {'NULLABLE': True,
                                                                    'ORDER': 5,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 4095},
                                                           'TYPE': {'NULLABLE': True,
                                                                    'ORDER': 6,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80}},
                                        'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_molecule_annotation',
                                                                           'chem_comp_id',
                                                                           None,
                                                                           None),
                                                          'DB_ID': (None, None, 'datablockid()', None),
                                                          'FAMILY_PRD_ID': ('pdbx_reference_molecule_annotation',
                                                                            'family_prd_id',
                                                                            None,
                                                                            None),
                                                          'ORDINAL': ('pdbx_reference_molecule_annotation',
                                                                      'ordinal',
                                                                      None,
                                                                      None),
                                                          'PRD_ID': ('pdbx_reference_molecule_annotation',
                                                                     'prd_id',
                                                                     None,
                                                                     None),
                                                          'SOURCE': ('pdbx_reference_molecule_annotation',
                                                                     'source',
                                                                     None,
                                                                     None),
                                                          'SUPPORT': ('pdbx_reference_molecule_annotation',
                                                                      'support',
                                                                      None,
                                                                      None),
                                                          'TEXT': ('pdbx_reference_molecule_annotation',
                                                                   'text',
                                                                   None,
                                                                   None),
                                                          'TYPE': ('pdbx_reference_molecule_annotation',
                                                                   'type',
                                                                   None,
                                                                   None)},
                                        'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID', 'ORDINAL'),
                                                           'TYPE': 'UNIQUE'},
                                                    's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                        'MAP_MERGE_INDICES': {'pdbx_reference_molecule_annotation': {'ATTRIBUTES': ('family_prd_id',
                                                                                                                    'ordinal'),
                                                                                                     'TYPE': 'EQUI-JOIN'}},
                                        'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                        'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_ANNOTATION',
                                        'TABLE_NAME': 'pdbx_reference_molecule_annotation',
                                        'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_MOLECULE_DETAILS': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                    'FAMILY_PRD_ID': 'family_prd_id',
                                                    'ORDINAL': 'ordinal',
                                                    'PRD_ID': 'prd_id',
                                                    'SOURCE': 'source',
                                                    'SOURCE_ID': 'source_id',
                                                    'TEXT': 'text'},
                                     'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                  'ORDER': 1,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                        'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                          'ORDER': 2,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                        'ORDINAL': {'NULLABLE': False,
                                                                    'ORDER': 4,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                                        'PRD_ID': {'NULLABLE': True,
                                                                   'ORDER': 3,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                        'SOURCE': {'NULLABLE': True,
                                                                   'ORDER': 5,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                                        'SOURCE_ID': {'NULLABLE': True,
                                                                      'ORDER': 6,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                                        'TEXT': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 30000}},
                                     'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                       'FAMILY_PRD_ID': ('pdbx_reference_molecule_details',
                                                                         'family_prd_id',
                                                                         None,
                                                                         None),
                                                       'ORDINAL': ('pdbx_reference_molecule_details',
                                                                   'ordinal',
                                                                   None,
                                                                   None),
                                                       'PRD_ID': ('pdbx_reference_molecule_details',
                                                                  'prd_id',
                                                                  None,
                                                                  None),
                                                       'SOURCE': ('pdbx_reference_molecule_details',
                                                                  'source',
                                                                  None,
                                                                  None),
                                                       'SOURCE_ID': ('pdbx_reference_molecule_details',
                                                                     'source_id',
                                                                     None,
                                                                     None),
                                                       'TEXT': ('pdbx_reference_molecule_details',
                                                                'text',
                                                                None,
                                                                None)},
                                     'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID', 'ORDINAL'),
                                                        'TYPE': 'UNIQUE'},
                                                 's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                     'MAP_MERGE_INDICES': {'pdbx_reference_molecule_details': {'ATTRIBUTES': ('family_prd_id',
                                                                                                              'ordinal'),
                                                                                               'TYPE': 'EQUI-JOIN'}},
                                     'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                     'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_DETAILS',
                                     'TABLE_NAME': 'pdbx_reference_molecule_details',
                                     'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_MOLECULE_FAMILY': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                   'FAMILY_PRD_ID': 'family_prd_id',
                                                   'NAME': 'name',
                                                   'RELEASE_STATUS': 'release_status',
                                                   'REPLACED_BY': 'replaced_by',
                                                   'REPLACES': 'replaces'},
                                    'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                       'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                         'ORDER': 2,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                       'NAME': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                                       'RELEASE_STATUS': {'NULLABLE': True,
                                                                          'ORDER': 4,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 80},
                                                       'REPLACED_BY': {'NULLABLE': True,
                                                                       'ORDER': 6,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80},
                                                       'REPLACES': {'NULLABLE': True,
                                                                    'ORDER': 5,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80}},
                                    'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                      'FAMILY_PRD_ID': ('pdbx_reference_molecule_family',
                                                                        'family_prd_id',
                                                                        None,
                                                                        None),
                                                      'NAME': ('pdbx_reference_molecule_family', 'name', None, None),
                                                      'RELEASE_STATUS': ('pdbx_reference_molecule_family',
                                                                         'release_status',
                                                                         None,
                                                                         None),
                                                      'REPLACED_BY': ('pdbx_reference_molecule_family',
                                                                      'replaced_by',
                                                                      None,
                                                                      None),
                                                      'REPLACES': ('pdbx_reference_molecule_family',
                                                                   'replaces',
                                                                   None,
                                                                   None)},
                                    'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID'), 'TYPE': 'UNIQUE'},
                                                's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                    'MAP_MERGE_INDICES': {'pdbx_reference_molecule_family': {'ATTRIBUTES': ('family_prd_id',),
                                                                                             'TYPE': 'EQUI-JOIN'}},
                                    'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                    'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_FAMILY',
                                    'TABLE_NAME': 'pdbx_reference_molecule_family',
                                    'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_MOLECULE_FEATURES': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                     'DB_ID': 'db_id',
                                                     'FAMILY_PRD_ID': 'family_prd_id',
                                                     'ORDINAL': 'ordinal',
                                                     'PRD_ID': 'prd_id',
                                                     'SOURCE': 'source',
                                                     'SOURCE_ORDINAL': 'source_ordinal',
                                                     'TYPE': 'type',
                                                     'VALUE': 'value'},
                                      'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                          'ORDER': 9,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                         'DB_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                         'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                           'ORDER': 2,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 10},
                                                         'ORDINAL': {'NULLABLE': False,
                                                                     'ORDER': 4,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': 10},
                                                         'PRD_ID': {'NULLABLE': False,
                                                                    'ORDER': 3,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                         'SOURCE': {'NULLABLE': True,
                                                                    'ORDER': 8,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80},
                                                         'SOURCE_ORDINAL': {'NULLABLE': True,
                                                                            'ORDER': 5,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'INT',
                                                                            'WIDTH': 10},
                                                         'TYPE': {'NULLABLE': True,
                                                                  'ORDER': 6,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 80},
                                                         'VALUE': {'NULLABLE': True,
                                                                   'ORDER': 7,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 1023}},
                                      'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_molecule_features',
                                                                         'chem_comp_id',
                                                                         None,
                                                                         None),
                                                        'DB_ID': (None, None, 'datablockid()', None),
                                                        'FAMILY_PRD_ID': ('pdbx_reference_molecule_features',
                                                                          'family_prd_id',
                                                                          None,
                                                                          None),
                                                        'ORDINAL': ('pdbx_reference_molecule_features',
                                                                    'ordinal',
                                                                    None,
                                                                    None),
                                                        'PRD_ID': ('pdbx_reference_molecule_features',
                                                                   'prd_id',
                                                                   None,
                                                                   None),
                                                        'SOURCE': ('pdbx_reference_molecule_features',
                                                                   'source',
                                                                   None,
                                                                   None),
                                                        'SOURCE_ORDINAL': ('pdbx_reference_molecule_features',
                                                                           'source_ordinal',
                                                                           None,
                                                                           None),
                                                        'TYPE': ('pdbx_reference_molecule_features',
                                                                 'type',
                                                                 None,
                                                                 None),
                                                        'VALUE': ('pdbx_reference_molecule_features',
                                                                  'value',
                                                                  None,
                                                                  None)},
                                      'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                        'FAMILY_PRD_ID',
                                                                        'PRD_ID',
                                                                        'ORDINAL'),
                                                         'TYPE': 'UNIQUE'},
                                                  's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                      'MAP_MERGE_INDICES': {'pdbx_reference_molecule_features': {'ATTRIBUTES': ('family_prd_id',
                                                                                                                'prd_id',
                                                                                                                'ordinal'),
                                                                                                 'TYPE': 'EQUI-JOIN'}},
                                      'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                      'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_FEATURES',
                                      'TABLE_NAME': 'pdbx_reference_molecule_features',
                                      'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_MOLECULE_LIST': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                 'FAMILY_PRD_ID': 'family_prd_id',
                                                 'PRD_ID': 'prd_id'},
                                  'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                     'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                       'ORDER': 3,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                     'PRD_ID': {'NULLABLE': False,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10}},
                                  'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                    'FAMILY_PRD_ID': ('pdbx_reference_molecule_list',
                                                                      'family_prd_id',
                                                                      None,
                                                                      None),
                                                    'PRD_ID': ('pdbx_reference_molecule_list', 'prd_id', None, None)},
                                  'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'FAMILY_PRD_ID'),
                                                     'TYPE': 'UNIQUE'},
                                              's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                  'MAP_MERGE_INDICES': {'pdbx_reference_molecule_list': {'ATTRIBUTES': ('prd_id',
                                                                                                        'family_prd_id'),
                                                                                         'TYPE': 'EQUI-JOIN'}},
                                  'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                  'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_LIST',
                                  'TABLE_NAME': 'pdbx_reference_molecule_list',
                                  'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_MOLECULE_RELATED_STRUCTURES': {'ATTRIBUTES': {'CITATION_ID': 'citation_id',
                                                               'DB_ACCESSION': 'db_accession',
                                                               'DB_CODE': 'db_code',
                                                               'DB_ID': 'db_id',
                                                               'DB_NAME': 'db_name',
                                                               'FAMILY_PRD_ID': 'family_prd_id',
                                                               'FORMULA': 'formula',
                                                               'NAME': 'name',
                                                               'ORDINAL': 'ordinal'},
                                                'ATTRIBUTE_INFO': {'CITATION_ID': {'NULLABLE': True,
                                                                                   'ORDER': 9,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'VARCHAR',
                                                                                   'WIDTH': 10},
                                                                   'DB_ACCESSION': {'NULLABLE': True,
                                                                                    'ORDER': 6,
                                                                                    'PRECISION': 0,
                                                                                    'PRIMARY_KEY': False,
                                                                                    'SQL_TYPE': 'VARCHAR',
                                                                                    'WIDTH': 200},
                                                                   'DB_CODE': {'NULLABLE': True,
                                                                               'ORDER': 5,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 200},
                                                                   'DB_ID': {'NULLABLE': False,
                                                                             'ORDER': 1,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': True,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 10},
                                                                   'DB_NAME': {'NULLABLE': True,
                                                                               'ORDER': 4,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 200},
                                                                   'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                                     'ORDER': 2,
                                                                                     'PRECISION': 0,
                                                                                     'PRIMARY_KEY': True,
                                                                                     'SQL_TYPE': 'VARCHAR',
                                                                                     'WIDTH': 10},
                                                                   'FORMULA': {'NULLABLE': True,
                                                                               'ORDER': 8,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 200},
                                                                   'NAME': {'NULLABLE': True,
                                                                            'ORDER': 7,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 511},
                                                                   'ORDINAL': {'NULLABLE': False,
                                                                               'ORDER': 3,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': True,
                                                                               'SQL_TYPE': 'INT',
                                                                               'WIDTH': 10}},
                                                'ATTRIBUTE_MAP': {'CITATION_ID': ('pdbx_reference_molecule_related_structures',
                                                                                  'citation_id',
                                                                                  None,
                                                                                  None),
                                                                  'DB_ACCESSION': ('pdbx_reference_molecule_related_structures',
                                                                                   'db_accession',
                                                                                   None,
                                                                                   None),
                                                                  'DB_CODE': ('pdbx_reference_molecule_related_structures',
                                                                              'db_code',
                                                                              None,
                                                                              None),
                                                                  'DB_ID': (None, None, 'datablockid()', None),
                                                                  'DB_NAME': ('pdbx_reference_molecule_related_structures',
                                                                              'db_name',
                                                                              None,
                                                                              None),
                                                                  'FAMILY_PRD_ID': ('pdbx_reference_molecule_related_structures',
                                                                                    'family_prd_id',
                                                                                    None,
                                                                                    None),
                                                                  'FORMULA': ('pdbx_reference_molecule_related_structures',
                                                                              'formula',
                                                                              None,
                                                                              None),
                                                                  'NAME': ('pdbx_reference_molecule_related_structures',
                                                                           'name',
                                                                           None,
                                                                           None),
                                                                  'ORDINAL': ('pdbx_reference_molecule_related_structures',
                                                                              'ordinal',
                                                                              None,
                                                                              None)},
                                                'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                                  'FAMILY_PRD_ID',
                                                                                  'ORDINAL'),
                                                                   'TYPE': 'UNIQUE'},
                                                            's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                                'MAP_MERGE_INDICES': {'pdbx_reference_molecule_related_structures': {'ATTRIBUTES': ('family_prd_id',
                                                                                                                                    'ordinal'),
                                                                                                                     'TYPE': 'EQUI-JOIN'}},
                                                'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                                'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_RELATED_STRUCTURES',
                                                'TABLE_NAME': 'pdbx_reference_molecule_related_structures',
                                                'TABLE_TYPE': 'transactional'},
 'PDBX_REFERENCE_MOLECULE_SYNONYMS': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                     'DB_ID': 'db_id',
                                                     'FAMILY_PRD_ID': 'family_prd_id',
                                                     'NAME': 'name',
                                                     'ORDINAL': 'ordinal',
                                                     'PRD_ID': 'prd_id',
                                                     'SOURCE': 'source'},
                                      'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                          'ORDER': 7,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                         'DB_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                         'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                           'ORDER': 2,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 10},
                                                         'NAME': {'NULLABLE': True,
                                                                  'ORDER': 5,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 1023},
                                                         'ORDINAL': {'NULLABLE': False,
                                                                     'ORDER': 4,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': 10},
                                                         'PRD_ID': {'NULLABLE': False,
                                                                    'ORDER': 3,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                         'SOURCE': {'NULLABLE': True,
                                                                    'ORDER': 6,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200}},
                                      'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_molecule_synonyms',
                                                                         'chem_comp_id',
                                                                         None,
                                                                         None),
                                                        'DB_ID': (None, None, 'datablockid()', None),
                                                        'FAMILY_PRD_ID': ('pdbx_reference_molecule_synonyms',
                                                                          'family_prd_id',
                                                                          None,
                                                                          None),
                                                        'NAME': ('pdbx_reference_molecule_synonyms',
                                                                 'name',
                                                                 None,
                                                                 None),
                                                        'ORDINAL': ('pdbx_reference_molecule_synonyms',
                                                                    'ordinal',
                                                                    None,
                                                                    None),
                                                        'PRD_ID': ('pdbx_reference_molecule_synonyms',
                                                                   'prd_id',
                                                                   None,
                                                                   None),
                                                        'SOURCE': ('pdbx_reference_molecule_synonyms',
                                                                   'source',
                                                                   None,
                                                                   None)},
                                      'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                        'FAMILY_PRD_ID',
                                                                        'PRD_ID',
                                                                        'ORDINAL'),
                                                         'TYPE': 'UNIQUE'},
                                                  's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                      'MAP_MERGE_INDICES': {'pdbx_reference_molecule_synonyms': {'ATTRIBUTES': ('family_prd_id',
                                                                                                                'prd_id',
                                                                                                                'ordinal'),
                                                                                                 'TYPE': 'EQUI-JOIN'}},
                                      'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                      'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_SYNONYMS',
                                      'TABLE_NAME': 'pdbx_reference_molecule_synonyms',
                                      'TABLE_TYPE': 'transactional'}}

    def __init__(self,verbose=True,log=sys.stderr):
        super(BirdSchemaDef,self).__init__(databaseName=BirdSchemaDef._databaseName,schemaDefDict=BirdSchemaDef._schemaDefDict,
                                           verbose=verbose,log=log)
        self.__verbose=verbose
        self.__lfh=log
        

if __name__ == "__main__":
    bsd=BirdSchemaDef()
    tableIdList=bsd.getTableIdList()

    for tableId in tableIdList:
        aIdL=bsd.getAttributeIdList(tableId)
        tObj=bsd.getTable(tableId)
        attributeIdList=tObj.getAttributeIdList()
        attributeNameList=tObj.getAttributeNameList()        
        sys.stdout.write("Ordered attribute Id   list %s\n" % (str(attributeIdList)))
        sys.stdout.write("Ordered attribute name list %s\n" % (str(attributeNameList)))        
        #
        mAL=tObj.getMapAttributeNameList()
        sys.stdout.write("Ordered mapped attribute name list %s\n" % (str(mAL)))

        mAL=tObj.getMapAttributeIdList()
        sys.stdout.write("Ordered mapped attribute id   list %s\n" % (str(mAL)))        

        cL=tObj.getMapInstanceCategoryList()
        sys.stdout.write("Mapped category list %s\n" % (str(cL)))
        for c in cL:
            aL=tObj.getMapInstanceAttributeList(c)
            sys.stdout.write("Mapped attribute list in %s :  %s\n" % (c,str(aL)))
            

