"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualServiceProvider = exports.VirtualService = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const mesh_1 = require("./mesh");
const utils_1 = require("./private/utils");
/**
 * VirtualService represents a service inside an AppMesh
 *
 * It routes traffic either to a Virtual Node or to a Virtual Router.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html
 */
class VirtualService extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.virtualServiceName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_VirtualServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const providerConfig = props.virtualServiceProvider.bind(this);
        this.mesh = providerConfig.mesh;
        const svc = new appmesh_generated_1.CfnVirtualService(this, 'Resource', {
            meshName: this.mesh.meshName,
            meshOwner: utils_1.renderMeshOwner(this.env.account, this.mesh.env.account),
            virtualServiceName: this.physicalName,
            spec: {
                provider: providerConfig.virtualNodeProvider || providerConfig.virtualRouterProvider
                    ? {
                        virtualNode: providerConfig.virtualNodeProvider,
                        virtualRouter: providerConfig.virtualRouterProvider,
                    }
                    : undefined,
            },
        });
        this.virtualServiceName = this.getResourceNameAttribute(svc.attrVirtualServiceName);
        this.virtualServiceArn = this.getResourceArnAttribute(svc.ref, {
            service: 'appmesh',
            resource: `mesh/${this.mesh.meshName}/virtualService`,
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing VirtualService given an ARN
     */
    static fromVirtualServiceArn(scope, id, virtualServiceArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.virtualServiceArn = virtualServiceArn;
                this.parsedArn = cdk.Fn.split('/', cdk.Stack.of(scope).splitArn(virtualServiceArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName);
                this.virtualServiceName = cdk.Fn.select(2, this.parsedArn);
                this.mesh = mesh_1.Mesh.fromMeshName(this, 'Mesh', cdk.Fn.select(0, this.parsedArn));
            }
        }(scope, id);
    }
    /**
     * Import an existing VirtualService given its attributes
     */
    static fromVirtualServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_VirtualServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVirtualServiceAttributes);
            }
            throw error;
        }
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.virtualServiceName = attrs.virtualServiceName;
                this.mesh = attrs.mesh;
                this.virtualServiceArn = cdk.Stack.of(this).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.mesh.meshName}/virtualService`,
                    resourceName: this.virtualServiceName,
                });
            }
        }(scope, id);
    }
}
exports.VirtualService = VirtualService;
_a = JSII_RTTI_SYMBOL_1;
VirtualService[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualService", version: "1.153.1" };
/**
 * Represents the properties needed to define the provider for a VirtualService
 */
class VirtualServiceProvider {
    /**
     * Returns a VirtualNode based Provider for a VirtualService
     */
    static virtualNode(virtualNode) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_IVirtualNode(virtualNode);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.virtualNode);
            }
            throw error;
        }
        return new VirtualServiceProviderImpl(virtualNode, undefined);
    }
    /**
     * Returns a VirtualRouter based Provider for a VirtualService
     */
    static virtualRouter(virtualRouter) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_IVirtualRouter(virtualRouter);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.virtualRouter);
            }
            throw error;
        }
        return new VirtualServiceProviderImpl(undefined, virtualRouter);
    }
    /**
     * Returns an Empty Provider for a VirtualService. This provides no routing capabilities
     * and should only be used as a placeholder
     */
    static none(mesh) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_IMesh(mesh);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.none);
            }
            throw error;
        }
        return new VirtualServiceProviderImpl(undefined, undefined, mesh);
    }
}
exports.VirtualServiceProvider = VirtualServiceProvider;
_b = JSII_RTTI_SYMBOL_1;
VirtualServiceProvider[_b] = { fqn: "@aws-cdk/aws-appmesh.VirtualServiceProvider", version: "1.153.1" };
class VirtualServiceProviderImpl extends VirtualServiceProvider {
    constructor(virtualNode, virtualRouter, mesh) {
        var _c, _d, _e, _f;
        super();
        this.virtualNode = virtualNode;
        this.virtualRouter = virtualRouter;
        const providedMesh = (_f = (_d = (_c = this.virtualNode) === null || _c === void 0 ? void 0 : _c.mesh) !== null && _d !== void 0 ? _d : (_e = this.virtualRouter) === null || _e === void 0 ? void 0 : _e.mesh) !== null && _f !== void 0 ? _f : mesh;
        this.mesh = providedMesh;
    }
    bind(_construct) {
        return {
            mesh: this.mesh,
            virtualNodeProvider: this.virtualNode
                ? {
                    virtualNodeName: this.virtualNode.virtualNodeName,
                }
                : undefined,
            virtualRouterProvider: this.virtualRouter
                ? {
                    virtualRouterName: this.virtualRouter.virtualRouterName,
                }
                : undefined,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmlydHVhbC1zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidmlydHVhbC1zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHFDQUFxQztBQUVyQywyREFBd0Q7QUFDeEQsaUNBQXFDO0FBQ3JDLDJDQUFrRDtBQWlEbEQ7Ozs7OztHQU1HO0FBQ0gsTUFBYSxjQUFlLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUEyQzlDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixZQUFZLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixJQUFJLEdBQUcsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7U0FDdkcsQ0FBQyxDQUFDOzs7Ozs7Ozs7O1FBRUgsTUFBTSxjQUFjLEdBQUcsS0FBSyxDQUFDLHNCQUFzQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMvRCxJQUFJLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxJQUFJLENBQUM7UUFFaEMsTUFBTSxHQUFHLEdBQUcsSUFBSSxxQ0FBaUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ2xELFFBQVEsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVE7WUFDNUIsU0FBUyxFQUFFLHVCQUFlLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDO1lBQ25FLGtCQUFrQixFQUFFLElBQUksQ0FBQyxZQUFZO1lBQ3JDLElBQUksRUFBRTtnQkFDSixRQUFRLEVBQUUsY0FBYyxDQUFDLG1CQUFtQixJQUFJLGNBQWMsQ0FBQyxxQkFBcUI7b0JBQ2xGLENBQUMsQ0FBQzt3QkFDQSxXQUFXLEVBQUUsY0FBYyxDQUFDLG1CQUFtQjt3QkFDL0MsYUFBYSxFQUFFLGNBQWMsQ0FBQyxxQkFBcUI7cUJBQ3BEO29CQUNELENBQUMsQ0FBQyxTQUFTO2FBQ2Q7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDLHdCQUF3QixDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUMsR0FBRyxDQUFDLEdBQUcsRUFBRTtZQUM3RCxPQUFPLEVBQUUsU0FBUztZQUNsQixRQUFRLEVBQUUsUUFBUSxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsaUJBQWlCO1lBQ3JELFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtTQUNoQyxDQUFDLENBQUM7S0FDSjtJQXRFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxpQkFBeUI7UUFDekYsT0FBTyxJQUFJLEtBQU0sU0FBUSxHQUFHLENBQUMsUUFBUTtZQUExQjs7Z0JBQ0Esc0JBQWlCLEdBQUcsaUJBQWlCLENBQUM7Z0JBQzlCLGNBQVMsR0FBRyxHQUFHLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsUUFBUSxDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxTQUFTLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxZQUFhLENBQUMsQ0FBQztnQkFDeEksdUJBQWtCLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztnQkFDdEQsU0FBSSxHQUFHLFdBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxFQUFFLE1BQU0sRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7WUFDcEYsQ0FBQztTQUFBLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0tBQ2Q7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUErQjs7Ozs7Ozs7OztRQUN0RyxPQUFPLElBQUksS0FBTSxTQUFRLEdBQUcsQ0FBQyxRQUFRO1lBQTFCOztnQkFDQSx1QkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUM7Z0JBQzlDLFNBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO2dCQUNsQixzQkFBaUIsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7b0JBQ3hELE9BQU8sRUFBRSxTQUFTO29CQUNsQixRQUFRLEVBQUUsUUFBUSxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsaUJBQWlCO29CQUN0RCxZQUFZLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtpQkFDdEMsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztTQUFBLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0tBQ2Q7O0FBMUJILHdDQXdFQzs7O0FBMkNEOztHQUVHO0FBQ0gsTUFBc0Isc0JBQXNCO0lBQzFDOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFdBQVcsQ0FBQyxXQUF5Qjs7Ozs7Ozs7OztRQUNqRCxPQUFPLElBQUksMEJBQTBCLENBQUMsV0FBVyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0tBQy9EO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsYUFBYSxDQUFDLGFBQTZCOzs7Ozs7Ozs7O1FBQ3ZELE9BQU8sSUFBSSwwQkFBMEIsQ0FBQyxTQUFTLEVBQUUsYUFBYSxDQUFDLENBQUM7S0FDakU7SUFFRDs7O09BR0c7SUFDSSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQVc7Ozs7Ozs7Ozs7UUFDNUIsT0FBTyxJQUFJLDBCQUEwQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUM7S0FDbkU7O0FBckJILHdEQTJCQzs7O0FBRUQsTUFBTSwwQkFBMkIsU0FBUSxzQkFBc0I7SUFLN0QsWUFBWSxXQUEwQixFQUFFLGFBQThCLEVBQUUsSUFBWTs7UUFDbEYsS0FBSyxFQUFFLENBQUM7UUFDUixJQUFJLENBQUMsV0FBVyxHQUFHLFdBQVcsQ0FBQztRQUMvQixJQUFJLENBQUMsYUFBYSxHQUFHLGFBQWEsQ0FBQztRQUNuQyxNQUFNLFlBQVkscUJBQUcsSUFBSSxDQUFDLFdBQVcsMENBQUUsSUFBSSx5Q0FBSSxJQUFJLENBQUMsYUFBYSwwQ0FBRSxJQUFJLG1DQUFJLElBQUssQ0FBQztRQUNqRixJQUFJLENBQUMsSUFBSSxHQUFHLFlBQVksQ0FBQztLQUMxQjtJQUVNLElBQUksQ0FBQyxVQUFxQjtRQUMvQixPQUFPO1lBQ0wsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLFdBQVc7Z0JBQ25DLENBQUMsQ0FBQztvQkFDQSxlQUFlLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxlQUFlO2lCQUNsRDtnQkFDRCxDQUFDLENBQUMsU0FBUztZQUNiLHFCQUFxQixFQUFFLElBQUksQ0FBQyxhQUFhO2dCQUN2QyxDQUFDLENBQUM7b0JBQ0EsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxpQkFBaUI7aUJBQ3hEO2dCQUNELENBQUMsQ0FBQyxTQUFTO1NBQ2QsQ0FBQztLQUNIO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmblZpcnR1YWxTZXJ2aWNlIH0gZnJvbSAnLi9hcHBtZXNoLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBJTWVzaCwgTWVzaCB9IGZyb20gJy4vbWVzaCc7XG5pbXBvcnQgeyByZW5kZXJNZXNoT3duZXIgfSBmcm9tICcuL3ByaXZhdGUvdXRpbHMnO1xuaW1wb3J0IHsgSVZpcnR1YWxOb2RlIH0gZnJvbSAnLi92aXJ0dWFsLW5vZGUnO1xuaW1wb3J0IHsgSVZpcnR1YWxSb3V0ZXIgfSBmcm9tICcuL3ZpcnR1YWwtcm91dGVyJztcblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBpbnRlcmZhY2Ugd2hpY2ggYWxsIFZpcnR1YWxTZXJ2aWNlIGJhc2VkIGNsYXNzZXMgTVVTVCBpbXBsZW1lbnRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJVmlydHVhbFNlcnZpY2UgZXh0ZW5kcyBjZGsuSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBWaXJ0dWFsU2VydmljZVxuICAgKlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSB2aXJ0dWFsU2VydmljZU5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIGZvciB0aGUgdmlydHVhbCBzZXJ2aWNlXG4gICAqXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHZpcnR1YWxTZXJ2aWNlQXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBNZXNoIHdoaWNoIHRoZSBWaXJ0dWFsU2VydmljZSBiZWxvbmdzIHRvXG4gICAqL1xuICByZWFkb25seSBtZXNoOiBJTWVzaDtcbn1cblxuLyoqXG4gKiBUaGUgcHJvcGVydGllcyBhcHBsaWVkIHRvIHRoZSBWaXJ0dWFsU2VydmljZSBiZWluZyBkZWZpbmVkXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVmlydHVhbFNlcnZpY2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgVmlydHVhbFNlcnZpY2UuXG4gICAqXG4gICAqIEl0IGlzIHJlY29tbWVuZGVkIHRoaXMgZm9sbG93cyB0aGUgZnVsbHktcXVhbGlmaWVkIGRvbWFpbiBuYW1lIGZvcm1hdCxcbiAgICogc3VjaCBhcyBcIm15LXNlcnZpY2UuZGVmYXVsdC5zdmMuY2x1c3Rlci5sb2NhbFwiLlxuICAgKlxuICAgKiBFeGFtcGxlIHZhbHVlOiBgc2VydmljZS5kb21haW4ubG9jYWxgXG4gICAqIEBkZWZhdWx0IC0gQSBuYW1lIGlzIGF1dG9tYXRpY2FsbHkgZ2VuZXJhdGVkXG4gICAqL1xuICByZWFkb25seSB2aXJ0dWFsU2VydmljZU5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBWaXJ0dWFsTm9kZSBvciBWaXJ0dWFsUm91dGVyIHdoaWNoIHRoZSBWaXJ0dWFsU2VydmljZSB1c2VzIGFzIGl0cyBwcm92aWRlclxuICAgKi9cbiAgcmVhZG9ubHkgdmlydHVhbFNlcnZpY2VQcm92aWRlcjogVmlydHVhbFNlcnZpY2VQcm92aWRlcjtcbn1cblxuLyoqXG4gKiBWaXJ0dWFsU2VydmljZSByZXByZXNlbnRzIGEgc2VydmljZSBpbnNpZGUgYW4gQXBwTWVzaFxuICpcbiAqIEl0IHJvdXRlcyB0cmFmZmljIGVpdGhlciB0byBhIFZpcnR1YWwgTm9kZSBvciB0byBhIFZpcnR1YWwgUm91dGVyLlxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcC1tZXNoL2xhdGVzdC91c2VyZ3VpZGUvdmlydHVhbF9zZXJ2aWNlcy5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBWaXJ0dWFsU2VydmljZSBleHRlbmRzIGNkay5SZXNvdXJjZSBpbXBsZW1lbnRzIElWaXJ0dWFsU2VydmljZSB7XG4gIC8qKlxuICAgKiBJbXBvcnQgYW4gZXhpc3RpbmcgVmlydHVhbFNlcnZpY2UgZ2l2ZW4gYW4gQVJOXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21WaXJ0dWFsU2VydmljZUFybihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCB2aXJ0dWFsU2VydmljZUFybjogc3RyaW5nKTogSVZpcnR1YWxTZXJ2aWNlIHtcbiAgICByZXR1cm4gbmV3IGNsYXNzIGV4dGVuZHMgY2RrLlJlc291cmNlIGltcGxlbWVudHMgSVZpcnR1YWxTZXJ2aWNlIHtcbiAgICAgIHJlYWRvbmx5IHZpcnR1YWxTZXJ2aWNlQXJuID0gdmlydHVhbFNlcnZpY2VBcm47XG4gICAgICBwcml2YXRlIHJlYWRvbmx5IHBhcnNlZEFybiA9IGNkay5Gbi5zcGxpdCgnLycsIGNkay5TdGFjay5vZihzY29wZSkuc3BsaXRBcm4odmlydHVhbFNlcnZpY2VBcm4sIGNkay5Bcm5Gb3JtYXQuU0xBU0hfUkVTT1VSQ0VfTkFNRSkucmVzb3VyY2VOYW1lISk7XG4gICAgICByZWFkb25seSB2aXJ0dWFsU2VydmljZU5hbWUgPSBjZGsuRm4uc2VsZWN0KDIsIHRoaXMucGFyc2VkQXJuKTtcbiAgICAgIHJlYWRvbmx5IG1lc2ggPSBNZXNoLmZyb21NZXNoTmFtZSh0aGlzLCAnTWVzaCcsIGNkay5Gbi5zZWxlY3QoMCwgdGhpcy5wYXJzZWRBcm4pKTtcbiAgICB9KHNjb3BlLCBpZCk7XG4gIH1cblxuICAvKipcbiAgICogSW1wb3J0IGFuIGV4aXN0aW5nIFZpcnR1YWxTZXJ2aWNlIGdpdmVuIGl0cyBhdHRyaWJ1dGVzXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21WaXJ0dWFsU2VydmljZUF0dHJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IFZpcnR1YWxTZXJ2aWNlQXR0cmlidXRlcyk6IElWaXJ0dWFsU2VydmljZSB7XG4gICAgcmV0dXJuIG5ldyBjbGFzcyBleHRlbmRzIGNkay5SZXNvdXJjZSBpbXBsZW1lbnRzIElWaXJ0dWFsU2VydmljZSB7XG4gICAgICByZWFkb25seSB2aXJ0dWFsU2VydmljZU5hbWUgPSBhdHRycy52aXJ0dWFsU2VydmljZU5hbWU7XG4gICAgICByZWFkb25seSBtZXNoID0gYXR0cnMubWVzaDtcbiAgICAgIHJlYWRvbmx5IHZpcnR1YWxTZXJ2aWNlQXJuID0gY2RrLlN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICAgIHNlcnZpY2U6ICdhcHBtZXNoJyxcbiAgICAgICAgcmVzb3VyY2U6IGBtZXNoLyR7YXR0cnMubWVzaC5tZXNoTmFtZX0vdmlydHVhbFNlcnZpY2VgLFxuICAgICAgICByZXNvdXJjZU5hbWU6IHRoaXMudmlydHVhbFNlcnZpY2VOYW1lLFxuICAgICAgfSk7XG4gICAgfShzY29wZSwgaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBWaXJ0dWFsU2VydmljZSwgaXQgaXMgcmVjb21tZW5kZWQgdGhpcyBmb2xsb3dzIHRoZSBmdWxseS1xdWFsaWZpZWQgZG9tYWluIG5hbWUgZm9ybWF0LlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHZpcnR1YWxTZXJ2aWNlTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgZm9yIHRoZSB2aXJ0dWFsIHNlcnZpY2VcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB2aXJ0dWFsU2VydmljZUFybjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgTWVzaCB3aGljaCB0aGUgVmlydHVhbFNlcnZpY2UgYmVsb25ncyB0b1xuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IG1lc2g6IElNZXNoO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBWaXJ0dWFsU2VydmljZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLnZpcnR1YWxTZXJ2aWNlTmFtZSB8fCBjZGsuTGF6eS5zdHJpbmcoeyBwcm9kdWNlOiAoKSA9PiBjZGsuTmFtZXMudW5pcXVlSWQodGhpcykgfSksXG4gICAgfSk7XG5cbiAgICBjb25zdCBwcm92aWRlckNvbmZpZyA9IHByb3BzLnZpcnR1YWxTZXJ2aWNlUHJvdmlkZXIuYmluZCh0aGlzKTtcbiAgICB0aGlzLm1lc2ggPSBwcm92aWRlckNvbmZpZy5tZXNoO1xuXG4gICAgY29uc3Qgc3ZjID0gbmV3IENmblZpcnR1YWxTZXJ2aWNlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIG1lc2hOYW1lOiB0aGlzLm1lc2gubWVzaE5hbWUsXG4gICAgICBtZXNoT3duZXI6IHJlbmRlck1lc2hPd25lcih0aGlzLmVudi5hY2NvdW50LCB0aGlzLm1lc2guZW52LmFjY291bnQpLFxuICAgICAgdmlydHVhbFNlcnZpY2VOYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICAgIHNwZWM6IHtcbiAgICAgICAgcHJvdmlkZXI6IHByb3ZpZGVyQ29uZmlnLnZpcnR1YWxOb2RlUHJvdmlkZXIgfHwgcHJvdmlkZXJDb25maWcudmlydHVhbFJvdXRlclByb3ZpZGVyXG4gICAgICAgICAgPyB7XG4gICAgICAgICAgICB2aXJ0dWFsTm9kZTogcHJvdmlkZXJDb25maWcudmlydHVhbE5vZGVQcm92aWRlcixcbiAgICAgICAgICAgIHZpcnR1YWxSb3V0ZXI6IHByb3ZpZGVyQ29uZmlnLnZpcnR1YWxSb3V0ZXJQcm92aWRlcixcbiAgICAgICAgICB9XG4gICAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgdGhpcy52aXJ0dWFsU2VydmljZU5hbWUgPSB0aGlzLmdldFJlc291cmNlTmFtZUF0dHJpYnV0ZShzdmMuYXR0clZpcnR1YWxTZXJ2aWNlTmFtZSk7XG4gICAgdGhpcy52aXJ0dWFsU2VydmljZUFybiA9IHRoaXMuZ2V0UmVzb3VyY2VBcm5BdHRyaWJ1dGUoc3ZjLnJlZiwge1xuICAgICAgc2VydmljZTogJ2FwcG1lc2gnLFxuICAgICAgcmVzb3VyY2U6IGBtZXNoLyR7dGhpcy5tZXNoLm1lc2hOYW1lfS92aXJ0dWFsU2VydmljZWAsXG4gICAgICByZXNvdXJjZU5hbWU6IHRoaXMucGh5c2ljYWxOYW1lLFxuICAgIH0pO1xuICB9XG59XG5cbi8qKlxuICogSW50ZXJmYWNlIHdpdGggcHJvcGVydGllcyBuY2VjZXNzYXJ5IHRvIGltcG9ydCBhIHJldXNhYmxlIFZpcnR1YWxTZXJ2aWNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVmlydHVhbFNlcnZpY2VBdHRyaWJ1dGVzIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBWaXJ0dWFsU2VydmljZSwgaXQgaXMgcmVjb21tZW5kZWQgdGhpcyBmb2xsb3dzIHRoZSBmdWxseS1xdWFsaWZpZWQgZG9tYWluIG5hbWUgZm9ybWF0LlxuICAgKi9cbiAgcmVhZG9ubHkgdmlydHVhbFNlcnZpY2VOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBNZXNoIHdoaWNoIHRoZSBWaXJ0dWFsU2VydmljZSBiZWxvbmdzIHRvXG4gICAqL1xuICByZWFkb25seSBtZXNoOiBJTWVzaDtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhIFZpcnR1YWxTZXJ2aWNlIHByb3ZpZGVyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVmlydHVhbFNlcnZpY2VQcm92aWRlckNvbmZpZyB7XG4gIC8qKlxuICAgKiBWaXJ0dWFsIE5vZGUgYmFzZWQgcHJvdmlkZXJcbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSB2aXJ0dWFsTm9kZVByb3ZpZGVyPzogQ2ZuVmlydHVhbFNlcnZpY2UuVmlydHVhbE5vZGVTZXJ2aWNlUHJvdmlkZXJQcm9wZXJ0eTtcblxuICAvKipcbiAgICogVmlydHVhbCBSb3V0ZXIgYmFzZWQgcHJvdmlkZXJcbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSB2aXJ0dWFsUm91dGVyUHJvdmlkZXI/OiBDZm5WaXJ0dWFsU2VydmljZS5WaXJ0dWFsUm91dGVyU2VydmljZVByb3ZpZGVyUHJvcGVydHk7XG5cbiAgLyoqXG4gICAqIE1lc2ggdGhlIFByb3ZpZGVyIGlzIHVzaW5nXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgbWVzaDogSU1lc2g7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgcHJvcGVydGllcyBuZWVkZWQgdG8gZGVmaW5lIHRoZSBwcm92aWRlciBmb3IgYSBWaXJ0dWFsU2VydmljZVxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgVmlydHVhbFNlcnZpY2VQcm92aWRlciB7XG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgVmlydHVhbE5vZGUgYmFzZWQgUHJvdmlkZXIgZm9yIGEgVmlydHVhbFNlcnZpY2VcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgdmlydHVhbE5vZGUodmlydHVhbE5vZGU6IElWaXJ0dWFsTm9kZSk6IFZpcnR1YWxTZXJ2aWNlUHJvdmlkZXIge1xuICAgIHJldHVybiBuZXcgVmlydHVhbFNlcnZpY2VQcm92aWRlckltcGwodmlydHVhbE5vZGUsIHVuZGVmaW5lZCk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIFZpcnR1YWxSb3V0ZXIgYmFzZWQgUHJvdmlkZXIgZm9yIGEgVmlydHVhbFNlcnZpY2VcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgdmlydHVhbFJvdXRlcih2aXJ0dWFsUm91dGVyOiBJVmlydHVhbFJvdXRlcik6IFZpcnR1YWxTZXJ2aWNlUHJvdmlkZXIge1xuICAgIHJldHVybiBuZXcgVmlydHVhbFNlcnZpY2VQcm92aWRlckltcGwodW5kZWZpbmVkLCB2aXJ0dWFsUm91dGVyKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGFuIEVtcHR5IFByb3ZpZGVyIGZvciBhIFZpcnR1YWxTZXJ2aWNlLiBUaGlzIHByb3ZpZGVzIG5vIHJvdXRpbmcgY2FwYWJpbGl0aWVzXG4gICAqIGFuZCBzaG91bGQgb25seSBiZSB1c2VkIGFzIGEgcGxhY2Vob2xkZXJcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgbm9uZShtZXNoOiBJTWVzaCk6IFZpcnR1YWxTZXJ2aWNlUHJvdmlkZXIge1xuICAgIHJldHVybiBuZXcgVmlydHVhbFNlcnZpY2VQcm92aWRlckltcGwodW5kZWZpbmVkLCB1bmRlZmluZWQsIG1lc2gpO1xuICB9XG5cbiAgLyoqXG4gICAqIEVuZm9yY2VzIG11dHVhbCBleGNsdXNpdml0eSBmb3IgVmlydHVhbFNlcnZpY2UgcHJvdmlkZXIgdHlwZXMuXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgYmluZChfY29uc3RydWN0OiBDb25zdHJ1Y3QpOiBWaXJ0dWFsU2VydmljZVByb3ZpZGVyQ29uZmlnO1xufVxuXG5jbGFzcyBWaXJ0dWFsU2VydmljZVByb3ZpZGVySW1wbCBleHRlbmRzIFZpcnR1YWxTZXJ2aWNlUHJvdmlkZXIge1xuICBwcml2YXRlIHJlYWRvbmx5IHZpcnR1YWxOb2RlPzogSVZpcnR1YWxOb2RlO1xuICBwcml2YXRlIHJlYWRvbmx5IHZpcnR1YWxSb3V0ZXI/OiBJVmlydHVhbFJvdXRlcjtcbiAgcHJpdmF0ZSByZWFkb25seSBtZXNoOiBJTWVzaDtcblxuICBjb25zdHJ1Y3Rvcih2aXJ0dWFsTm9kZT86IElWaXJ0dWFsTm9kZSwgdmlydHVhbFJvdXRlcj86IElWaXJ0dWFsUm91dGVyLCBtZXNoPzogSU1lc2gpIHtcbiAgICBzdXBlcigpO1xuICAgIHRoaXMudmlydHVhbE5vZGUgPSB2aXJ0dWFsTm9kZTtcbiAgICB0aGlzLnZpcnR1YWxSb3V0ZXIgPSB2aXJ0dWFsUm91dGVyO1xuICAgIGNvbnN0IHByb3ZpZGVkTWVzaCA9IHRoaXMudmlydHVhbE5vZGU/Lm1lc2ggPz8gdGhpcy52aXJ0dWFsUm91dGVyPy5tZXNoID8/IG1lc2ghO1xuICAgIHRoaXMubWVzaCA9IHByb3ZpZGVkTWVzaDtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF9jb25zdHJ1Y3Q6IENvbnN0cnVjdCk6IFZpcnR1YWxTZXJ2aWNlUHJvdmlkZXJDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBtZXNoOiB0aGlzLm1lc2gsXG4gICAgICB2aXJ0dWFsTm9kZVByb3ZpZGVyOiB0aGlzLnZpcnR1YWxOb2RlXG4gICAgICAgID8ge1xuICAgICAgICAgIHZpcnR1YWxOb2RlTmFtZTogdGhpcy52aXJ0dWFsTm9kZS52aXJ0dWFsTm9kZU5hbWUsXG4gICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICB2aXJ0dWFsUm91dGVyUHJvdmlkZXI6IHRoaXMudmlydHVhbFJvdXRlclxuICAgICAgICA/IHtcbiAgICAgICAgICB2aXJ0dWFsUm91dGVyTmFtZTogdGhpcy52aXJ0dWFsUm91dGVyLnZpcnR1YWxSb3V0ZXJOYW1lLFxuICAgICAgICB9XG4gICAgICAgIDogdW5kZWZpbmVkLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==