"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Backend = exports.AccessLog = exports.Protocol = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
/**
 * Enum of supported AppMesh protocols
 *
 * @deprecated not for use outside package
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "http";
    Protocol["TCP"] = "tcp";
    Protocol["HTTP2"] = "http2";
    Protocol["GRPC"] = "grpc";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Configuration for Envoy Access logs for mesh endpoints
 */
class AccessLog {
    /**
     * Path to a file to write access logs to
     *
     * @default - no file based access logging
     */
    static fromFilePath(filePath) {
        return new FileAccessLog(filePath);
    }
}
exports.AccessLog = AccessLog;
_a = JSII_RTTI_SYMBOL_1;
AccessLog[_a] = { fqn: "@aws-cdk/aws-appmesh.AccessLog", version: "1.153.1" };
/**
 * Configuration for Envoy Access logs for mesh endpoints
 */
class FileAccessLog extends AccessLog {
    constructor(filePath) {
        super();
        this.filePath = filePath;
    }
    bind(_scope) {
        return {
            virtualNodeAccessLog: {
                file: {
                    path: this.filePath,
                },
            },
            virtualGatewayAccessLog: {
                file: {
                    path: this.filePath,
                },
            },
        };
    }
}
/**
 * Contains static factory methods to create backends
 */
class Backend {
    /**
     * Construct a Virtual Service backend
     */
    static virtualService(virtualService, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_IVirtualService(virtualService);
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_VirtualServiceBackendOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.virtualService);
            }
            throw error;
        }
        return new VirtualServiceBackend(virtualService, props.tlsClientPolicy);
    }
}
exports.Backend = Backend;
_b = JSII_RTTI_SYMBOL_1;
Backend[_b] = { fqn: "@aws-cdk/aws-appmesh.Backend", version: "1.153.1" };
/**
 * Represents the properties needed to define a Virtual Service backend
 */
class VirtualServiceBackend extends Backend {
    constructor(virtualService, tlsClientPolicy) {
        super();
        this.virtualService = virtualService;
        this.tlsClientPolicy = tlsClientPolicy;
    }
    /**
     * Return config for a Virtual Service backend
     */
    bind(scope) {
        return {
            virtualServiceBackend: {
                virtualService: {
                    /**
                     * We want to use the name of the Virtual Service here directly instead of
                     * a `{ 'Fn::GetAtt' }` CFN expression. This avoids a circular dependency in
                     * the case where this Virtual Node is the Virtual Service's provider.
                     */
                    virtualServiceName: cdk.Token.isUnresolved(this.virtualService.virtualServiceName)
                        ? this.virtualService.physicalName
                        : this.virtualService.virtualServiceName,
                    clientPolicy: this.tlsClientPolicy
                        ? {
                            tls: utils_1.renderTlsClientPolicy(scope, this.tlsClientPolicy),
                        }
                        : undefined,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2hhcmVkLWludGVyZmFjZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzaGFyZWQtaW50ZXJmYWNlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxxQ0FBcUM7QUFFckMsMkNBQXdEO0FBMER4RDs7OztHQUlHO0FBQ0gsSUFBWSxRQUtYO0FBTEQsV0FBWSxRQUFRO0lBQ2xCLHlCQUFhLENBQUE7SUFDYix1QkFBVyxDQUFBO0lBQ1gsMkJBQWUsQ0FBQTtJQUNmLHlCQUFhLENBQUE7QUFDZixDQUFDLEVBTFcsUUFBUSxHQUFSLGdCQUFRLEtBQVIsZ0JBQVEsUUFLbkI7QUFnREQ7O0dBRUc7QUFDSCxNQUFzQixTQUFTO0lBQzdCOzs7O09BSUc7SUFDSSxNQUFNLENBQUMsWUFBWSxDQUFDLFFBQWdCO1FBQ3pDLE9BQU8sSUFBSSxhQUFhLENBQUMsUUFBUSxDQUFDLENBQUM7S0FDcEM7O0FBUkgsOEJBZUM7OztBQUVEOztHQUVHO0FBQ0gsTUFBTSxhQUFjLFNBQVEsU0FBUztJQVFuQyxZQUFZLFFBQWdCO1FBQzFCLEtBQUssRUFBRSxDQUFDO1FBQ1IsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7S0FDMUI7SUFFTSxJQUFJLENBQUMsTUFBaUI7UUFDM0IsT0FBTztZQUNMLG9CQUFvQixFQUFFO2dCQUNwQixJQUFJLEVBQUU7b0JBQ0osSUFBSSxFQUFFLElBQUksQ0FBQyxRQUFRO2lCQUNwQjthQUNGO1lBQ0QsdUJBQXVCLEVBQUU7Z0JBQ3ZCLElBQUksRUFBRTtvQkFDSixJQUFJLEVBQUUsSUFBSSxDQUFDLFFBQVE7aUJBQ3BCO2FBQ0Y7U0FDRixDQUFDO0tBQ0g7Q0FDRjtBQXNDRDs7R0FFRztBQUNILE1BQXNCLE9BQU87SUFDM0I7O09BRUc7SUFDSSxNQUFNLENBQUMsY0FBYyxDQUFDLGNBQStCLEVBQUUsUUFBc0MsRUFBRTs7Ozs7Ozs7Ozs7UUFDcEcsT0FBTyxJQUFJLHFCQUFxQixDQUFDLGNBQWMsRUFBRSxLQUFLLENBQUMsZUFBZSxDQUFDLENBQUM7S0FDekU7O0FBTkgsMEJBWUM7OztBQUVEOztHQUVHO0FBQ0gsTUFBTSxxQkFBc0IsU0FBUSxPQUFPO0lBRXpDLFlBQThCLGNBQStCLEVBQzFDLGVBQTRDO1FBQzdELEtBQUssRUFBRSxDQUFDO1FBRm9CLG1CQUFjLEdBQWQsY0FBYyxDQUFpQjtRQUMxQyxvQkFBZSxHQUFmLGVBQWUsQ0FBNkI7S0FFOUQ7SUFFRDs7T0FFRztJQUNJLElBQUksQ0FBQyxLQUFnQjtRQUMxQixPQUFPO1lBQ0wscUJBQXFCLEVBQUU7Z0JBQ3JCLGNBQWMsRUFBRTtvQkFDZDs7Ozt1QkFJRztvQkFDSCxrQkFBa0IsRUFBRSxHQUFHLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUFDO3dCQUNoRixDQUFDLENBQUUsSUFBSSxDQUFDLGNBQXNCLENBQUMsWUFBWTt3QkFDM0MsQ0FBQyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsa0JBQWtCO29CQUMxQyxZQUFZLEVBQUUsSUFBSSxDQUFDLGVBQWU7d0JBQ2hDLENBQUMsQ0FBQzs0QkFDQSxHQUFHLEVBQUUsNkJBQXFCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUM7eUJBQ3hEO3dCQUNELENBQUMsQ0FBQyxTQUFTO2lCQUNkO2FBQ0Y7U0FDRixDQUFDO0tBQ0g7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENmblZpcnR1YWxHYXRld2F5LCBDZm5WaXJ0dWFsTm9kZSB9IGZyb20gJy4vYXBwbWVzaC5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgcmVuZGVyVGxzQ2xpZW50UG9saWN5IH0gZnJvbSAnLi9wcml2YXRlL3V0aWxzJztcbmltcG9ydCB7IFRsc0NsaWVudFBvbGljeSB9IGZyb20gJy4vdGxzLWNsaWVudC1wb2xpY3knO1xuaW1wb3J0IHsgSVZpcnR1YWxTZXJ2aWNlIH0gZnJvbSAnLi92aXJ0dWFsLXNlcnZpY2UnO1xuXG4vLyBrZWVwIHRoaXMgaW1wb3J0IHNlcGFyYXRlIGZyb20gb3RoZXIgaW1wb3J0cyB0byByZWR1Y2UgY2hhbmNlIGZvciBtZXJnZSBjb25mbGljdHMgd2l0aCB2Mi1tYWluXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tZHVwbGljYXRlLWltcG9ydHMsIGltcG9ydC9vcmRlclxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aW1lb3V0cyBmb3IgSFRUUCBwcm90b2NvbHMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSHR0cFRpbWVvdXQge1xuICAvKipcbiAgICogUmVwcmVzZW50cyBhbiBpZGxlIHRpbWVvdXQuIFRoZSBhbW91bnQgb2YgdGltZSB0aGF0IGEgY29ubmVjdGlvbiBtYXkgYmUgaWRsZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBpZGxlPzogY2RrLkR1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBSZXByZXNlbnRzIHBlciByZXF1ZXN0IHRpbWVvdXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gMTUgc1xuICAgKi9cbiAgcmVhZG9ubHkgcGVyUmVxdWVzdD86IGNkay5EdXJhdGlvbjtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRpbWVvdXRzIGZvciBHUlBDIHByb3RvY29scy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBHcnBjVGltZW91dCB7XG4gIC8qKlxuICAgKiBSZXByZXNlbnRzIGFuIGlkbGUgdGltZW91dC4gVGhlIGFtb3VudCBvZiB0aW1lIHRoYXQgYSBjb25uZWN0aW9uIG1heSBiZSBpZGxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGlkbGU/OiBjZGsuRHVyYXRpb247XG5cbiAgLyoqXG4gICAqIFJlcHJlc2VudHMgcGVyIHJlcXVlc3QgdGltZW91dC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSAxNSBzXG4gICAqL1xuICByZWFkb25seSBwZXJSZXF1ZXN0PzogY2RrLkR1cmF0aW9uO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgdGltZW91dHMgZm9yIFRDUCBwcm90b2NvbHMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVGNwVGltZW91dCB7XG4gIC8qKlxuICAgKiBSZXByZXNlbnRzIGFuIGlkbGUgdGltZW91dC4gVGhlIGFtb3VudCBvZiB0aW1lIHRoYXQgYSBjb25uZWN0aW9uIG1heSBiZSBpZGxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGlkbGU/OiBjZGsuRHVyYXRpb247XG59XG5cbi8qKlxuICogRW51bSBvZiBzdXBwb3J0ZWQgQXBwTWVzaCBwcm90b2NvbHNcbiAqXG4gKiBAZGVwcmVjYXRlZCBub3QgZm9yIHVzZSBvdXRzaWRlIHBhY2thZ2VcbiAqL1xuZXhwb3J0IGVudW0gUHJvdG9jb2wge1xuICBIVFRQID0gJ2h0dHAnLFxuICBUQ1AgPSAndGNwJyxcbiAgSFRUUDIgPSAnaHR0cDInLFxuICBHUlBDID0gJ2dycGMnLFxufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIG91dGxpZXIgZGV0ZWN0aW9uIGZvciBhIGxpc3RlbmVyLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIE91dGxpZXJEZXRlY3Rpb24ge1xuICAvKipcbiAgICogVGhlIGJhc2UgYW1vdW50IG9mIHRpbWUgZm9yIHdoaWNoIGEgaG9zdCBpcyBlamVjdGVkLlxuICAgKi9cbiAgcmVhZG9ubHkgYmFzZUVqZWN0aW9uRHVyYXRpb246IGNkay5EdXJhdGlvbjtcblxuICAvKipcbiAgICogVGhlIHRpbWUgaW50ZXJ2YWwgYmV0d2VlbiBlamVjdGlvbiBzd2VlcCBhbmFseXNpcy5cbiAgICovXG4gIHJlYWRvbmx5IGludGVydmFsOiBjZGsuRHVyYXRpb247XG5cbiAgLyoqXG4gICAqIE1heGltdW0gcGVyY2VudGFnZSBvZiBob3N0cyBpbiBsb2FkIGJhbGFuY2luZyBwb29sIGZvciB1cHN0cmVhbSBzZXJ2aWNlIHRoYXQgY2FuIGJlIGVqZWN0ZWQuIFdpbGwgZWplY3QgYXRcbiAgICogbGVhc3Qgb25lIGhvc3QgcmVnYXJkbGVzcyBvZiB0aGUgdmFsdWUuXG4gICAqL1xuICByZWFkb25seSBtYXhFamVjdGlvblBlcmNlbnQ6IG51bWJlcjtcblxuICAvKipcbiAgICogTnVtYmVyIG9mIGNvbnNlY3V0aXZlIDV4eCBlcnJvcnMgcmVxdWlyZWQgZm9yIGVqZWN0aW9uLlxuICAgKi9cbiAgcmVhZG9ubHkgbWF4U2VydmVyRXJyb3JzOiBudW1iZXI7XG59XG5cbi8qKlxuICogQWxsIFByb3BlcnRpZXMgZm9yIEVudm95IEFjY2VzcyBsb2dzIGZvciBtZXNoIGVuZHBvaW50c1xuICovXG5leHBvcnQgaW50ZXJmYWNlIEFjY2Vzc0xvZ0NvbmZpZyB7XG5cbiAgLyoqXG4gICAqIFZpcnR1YWxOb2RlIENGTiBjb25maWd1cmF0aW9uIGZvciBBY2Nlc3MgTG9nZ2luZ1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGFjY2VzcyBsb2dnaW5nXG4gICAqL1xuICByZWFkb25seSB2aXJ0dWFsTm9kZUFjY2Vzc0xvZz86IENmblZpcnR1YWxOb2RlLkFjY2Vzc0xvZ1Byb3BlcnR5O1xuXG4gIC8qKlxuICAgKiBWaXJ0dWFsR2F0ZXdheSBDRk4gY29uZmlndXJhdGlvbiBmb3IgQWNjZXNzIExvZ2dpbmdcbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBhY2Nlc3MgbG9nZ2luZ1xuICAgKi9cbiAgcmVhZG9ubHkgdmlydHVhbEdhdGV3YXlBY2Nlc3NMb2c/OiBDZm5WaXJ0dWFsR2F0ZXdheS5WaXJ0dWFsR2F0ZXdheUFjY2Vzc0xvZ1Byb3BlcnR5O1xufVxuXG4vKipcbiAqIENvbmZpZ3VyYXRpb24gZm9yIEVudm95IEFjY2VzcyBsb2dzIGZvciBtZXNoIGVuZHBvaW50c1xuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQWNjZXNzTG9nIHtcbiAgLyoqXG4gICAqIFBhdGggdG8gYSBmaWxlIHRvIHdyaXRlIGFjY2VzcyBsb2dzIHRvXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gZmlsZSBiYXNlZCBhY2Nlc3MgbG9nZ2luZ1xuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tRmlsZVBhdGgoZmlsZVBhdGg6IHN0cmluZyk6IEFjY2Vzc0xvZyB7XG4gICAgcmV0dXJuIG5ldyBGaWxlQWNjZXNzTG9nKGZpbGVQYXRoKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDYWxsZWQgd2hlbiB0aGUgQWNjZXNzTG9nIHR5cGUgaXMgaW5pdGlhbGl6ZWQuIENhbiBiZSB1c2VkIHRvIGVuZm9yY2VcbiAgICogbXV0dWFsIGV4Y2x1c2l2aXR5IHdpdGggZnV0dXJlIHByb3BlcnRpZXNcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QpOiBBY2Nlc3NMb2dDb25maWc7XG59XG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBmb3IgRW52b3kgQWNjZXNzIGxvZ3MgZm9yIG1lc2ggZW5kcG9pbnRzXG4gKi9cbmNsYXNzIEZpbGVBY2Nlc3NMb2cgZXh0ZW5kcyBBY2Nlc3NMb2cge1xuICAvKipcbiAgICogUGF0aCB0byBhIGZpbGUgdG8gd3JpdGUgYWNjZXNzIGxvZ3MgdG9cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBmaWxlIGJhc2VkIGFjY2VzcyBsb2dnaW5nXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgZmlsZVBhdGg6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihmaWxlUGF0aDogc3RyaW5nKSB7XG4gICAgc3VwZXIoKTtcbiAgICB0aGlzLmZpbGVQYXRoID0gZmlsZVBhdGg7XG4gIH1cblxuICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IEFjY2Vzc0xvZ0NvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHZpcnR1YWxOb2RlQWNjZXNzTG9nOiB7XG4gICAgICAgIGZpbGU6IHtcbiAgICAgICAgICBwYXRoOiB0aGlzLmZpbGVQYXRoLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIHZpcnR1YWxHYXRld2F5QWNjZXNzTG9nOiB7XG4gICAgICAgIGZpbGU6IHtcbiAgICAgICAgICBwYXRoOiB0aGlzLmZpbGVQYXRoLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgcHJvcGVydGllcyBuZWVkZWQgdG8gZGVmaW5lIGJhY2tlbmQgZGVmYXVsdHNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBCYWNrZW5kRGVmYXVsdHMge1xuICAvKipcbiAgICogVExTIHByb3BlcnRpZXMgZm9yIENsaWVudCBwb2xpY3kgZm9yIGJhY2tlbmQgZGVmYXVsdHNcbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSB0bHNDbGllbnRQb2xpY3k/OiBUbHNDbGllbnRQb2xpY3k7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgcHJvcGVydGllcyBuZWVkZWQgdG8gZGVmaW5lIGEgVmlydHVhbCBTZXJ2aWNlIGJhY2tlbmRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBWaXJ0dWFsU2VydmljZUJhY2tlbmRPcHRpb25zIHtcblxuICAvKipcbiAgICogVExTIHByb3BlcnRpZXMgZm9yICBDbGllbnQgcG9saWN5IGZvciB0aGUgYmFja2VuZFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHRsc0NsaWVudFBvbGljeT86IFRsc0NsaWVudFBvbGljeTtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhIGJhY2tlbmRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBCYWNrZW5kQ29uZmlnIHtcbiAgLyoqXG4gICAqIENvbmZpZyBmb3IgYSBWaXJ0dWFsIFNlcnZpY2UgYmFja2VuZFxuICAgKi9cbiAgcmVhZG9ubHkgdmlydHVhbFNlcnZpY2VCYWNrZW5kOiBDZm5WaXJ0dWFsTm9kZS5CYWNrZW5kUHJvcGVydHk7XG59XG5cblxuLyoqXG4gKiBDb250YWlucyBzdGF0aWMgZmFjdG9yeSBtZXRob2RzIHRvIGNyZWF0ZSBiYWNrZW5kc1xuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQmFja2VuZCB7XG4gIC8qKlxuICAgKiBDb25zdHJ1Y3QgYSBWaXJ0dWFsIFNlcnZpY2UgYmFja2VuZFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyB2aXJ0dWFsU2VydmljZSh2aXJ0dWFsU2VydmljZTogSVZpcnR1YWxTZXJ2aWNlLCBwcm9wczogVmlydHVhbFNlcnZpY2VCYWNrZW5kT3B0aW9ucyA9IHt9KTogQmFja2VuZCB7XG4gICAgcmV0dXJuIG5ldyBWaXJ0dWFsU2VydmljZUJhY2tlbmQodmlydHVhbFNlcnZpY2UsIHByb3BzLnRsc0NsaWVudFBvbGljeSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJuIGJhY2tlbmQgY29uZmlnXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IEJhY2tlbmRDb25maWc7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgcHJvcGVydGllcyBuZWVkZWQgdG8gZGVmaW5lIGEgVmlydHVhbCBTZXJ2aWNlIGJhY2tlbmRcbiAqL1xuY2xhc3MgVmlydHVhbFNlcnZpY2VCYWNrZW5kIGV4dGVuZHMgQmFja2VuZCB7XG5cbiAgY29uc3RydWN0b3IgKHByaXZhdGUgcmVhZG9ubHkgdmlydHVhbFNlcnZpY2U6IElWaXJ0dWFsU2VydmljZSxcbiAgICBwcml2YXRlIHJlYWRvbmx5IHRsc0NsaWVudFBvbGljeTogVGxzQ2xpZW50UG9saWN5IHwgdW5kZWZpbmVkKSB7XG4gICAgc3VwZXIoKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm4gY29uZmlnIGZvciBhIFZpcnR1YWwgU2VydmljZSBiYWNrZW5kXG4gICAqL1xuICBwdWJsaWMgYmluZChzY29wZTogQ29uc3RydWN0KTogQmFja2VuZENvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHZpcnR1YWxTZXJ2aWNlQmFja2VuZDoge1xuICAgICAgICB2aXJ0dWFsU2VydmljZToge1xuICAgICAgICAgIC8qKlxuICAgICAgICAgICAqIFdlIHdhbnQgdG8gdXNlIHRoZSBuYW1lIG9mIHRoZSBWaXJ0dWFsIFNlcnZpY2UgaGVyZSBkaXJlY3RseSBpbnN0ZWFkIG9mXG4gICAgICAgICAgICogYSBgeyAnRm46OkdldEF0dCcgfWAgQ0ZOIGV4cHJlc3Npb24uIFRoaXMgYXZvaWRzIGEgY2lyY3VsYXIgZGVwZW5kZW5jeSBpblxuICAgICAgICAgICAqIHRoZSBjYXNlIHdoZXJlIHRoaXMgVmlydHVhbCBOb2RlIGlzIHRoZSBWaXJ0dWFsIFNlcnZpY2UncyBwcm92aWRlci5cbiAgICAgICAgICAgKi9cbiAgICAgICAgICB2aXJ0dWFsU2VydmljZU5hbWU6IGNkay5Ub2tlbi5pc1VucmVzb2x2ZWQodGhpcy52aXJ0dWFsU2VydmljZS52aXJ0dWFsU2VydmljZU5hbWUpXG4gICAgICAgICAgICA/ICh0aGlzLnZpcnR1YWxTZXJ2aWNlIGFzIGFueSkucGh5c2ljYWxOYW1lXG4gICAgICAgICAgICA6IHRoaXMudmlydHVhbFNlcnZpY2UudmlydHVhbFNlcnZpY2VOYW1lLFxuICAgICAgICAgIGNsaWVudFBvbGljeTogdGhpcy50bHNDbGllbnRQb2xpY3lcbiAgICAgICAgICAgID8ge1xuICAgICAgICAgICAgICB0bHM6IHJlbmRlclRsc0NsaWVudFBvbGljeShzY29wZSwgdGhpcy50bHNDbGllbnRQb2xpY3kpLFxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBDb25uZWN0aW9uIHBvb2wgcHJvcGVydGllcyBmb3IgSFRUUCBsaXN0ZW5lcnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIdHRwQ29ubmVjdGlvblBvb2wge1xuICAvKipcbiAgICogVGhlIG1heGltdW0gY29ubmVjdGlvbnMgaW4gdGhlIHBvb2xcbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBtYXhDb25uZWN0aW9uczogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgbWF4aW11bSBwZW5kaW5nIHJlcXVlc3RzIGluIHRoZSBwb29sXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgbWF4UGVuZGluZ1JlcXVlc3RzOiBudW1iZXI7XG59XG5cbi8qKlxuICogQ29ubmVjdGlvbiBwb29sIHByb3BlcnRpZXMgZm9yIFRDUCBsaXN0ZW5lcnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBUY3BDb25uZWN0aW9uUG9vbCB7XG4gIC8qKlxuICAgKiBUaGUgbWF4aW11bSBjb25uZWN0aW9ucyBpbiB0aGUgcG9vbFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IG1heENvbm5lY3Rpb25zOiBudW1iZXI7XG59XG5cbi8qKlxuICogQ29ubmVjdGlvbiBwb29sIHByb3BlcnRpZXMgZm9yIGdSUEMgbGlzdGVuZXJzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgR3JwY0Nvbm5lY3Rpb25Qb29sIHtcbiAgLyoqXG4gICAqIFRoZSBtYXhpbXVtIHJlcXVlc3RzIGluIHRoZSBwb29sXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgbWF4UmVxdWVzdHM6IG51bWJlcjtcbn1cblxuLyoqXG4gKiBDb25uZWN0aW9uIHBvb2wgcHJvcGVydGllcyBmb3IgSFRUUDIgbGlzdGVuZXJzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSHR0cDJDb25uZWN0aW9uUG9vbCB7XG4gIC8qKlxuICAgKiBUaGUgbWF4aW11bSByZXF1ZXN0cyBpbiB0aGUgcG9vbFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IG1heFJlcXVlc3RzOiBudW1iZXI7XG59Il19