"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRoute = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const utils_1 = require("./private/utils");
const virtual_gateway_1 = require("./virtual-gateway");
/**
 * GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 */
class GatewayRoute extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.gatewayRouteName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GatewayRouteProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.virtualGateway = props.virtualGateway;
        const routeSpecConfig = props.routeSpec.bind(this);
        const gatewayRoute = new appmesh_generated_1.CfnGatewayRoute(this, 'Resource', {
            gatewayRouteName: this.physicalName,
            meshName: props.virtualGateway.mesh.meshName,
            meshOwner: utils_1.renderMeshOwner(this.env.account, this.virtualGateway.mesh.env.account),
            spec: {
                httpRoute: routeSpecConfig.httpSpecConfig,
                http2Route: routeSpecConfig.http2SpecConfig,
                grpcRoute: routeSpecConfig.grpcSpecConfig,
                priority: routeSpecConfig.priority,
            },
            virtualGatewayName: this.virtualGateway.virtualGatewayName,
        });
        this.gatewayRouteName = this.getResourceNameAttribute(gatewayRoute.attrGatewayRouteName);
        this.gatewayRouteArn = this.getResourceArnAttribute(gatewayRoute.ref, {
            service: 'appmesh',
            resource: `mesh/${props.virtualGateway.mesh.meshName}/virtualRouter/${this.virtualGateway.virtualGatewayName}/gatewayRoute`,
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing GatewayRoute given an ARN
     */
    static fromGatewayRouteArn(scope, id, gatewayRouteArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteArn = gatewayRouteArn;
                this.gatewayRouteName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).splitArn(gatewayRouteArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName));
                this.virtualGateway = virtual_gateway_1.VirtualGateway.fromVirtualGatewayArn(this, 'virtualGateway', gatewayRouteArn);
            }
        }(scope, id);
    }
    /**
     * Import an existing GatewayRoute given attributes
     */
    static fromGatewayRouteAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GatewayRouteAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGatewayRouteAttributes);
            }
            throw error;
        }
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteName = attrs.gatewayRouteName;
                this.gatewayRouteArn = cdk.Stack.of(scope).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.virtualGateway.mesh.meshName}/virtualGateway/${attrs.virtualGateway.virtualGatewayName}/gatewayRoute`,
                    resourceName: this.gatewayRouteName,
                });
                this.virtualGateway = attrs.virtualGateway;
            }
        }(scope, id);
    }
}
exports.GatewayRoute = GatewayRoute;
_a = JSII_RTTI_SYMBOL_1;
GatewayRoute[_a] = { fqn: "@aws-cdk/aws-appmesh.GatewayRoute", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,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