"""
This type stub file was generated by pyright.
"""

import typing as t
from contextvars import ContextVar
from starlette.types import ASGIApp, Receive, Scope, Send
from connexion.middleware.abstract import AbstractRoutingAPI, SpecMiddleware
from connexion.operations import AbstractOperation
from connexion.resolver import Resolver
from connexion.spec import Specification

_scope: ContextVar[dict] = ...
class RoutingOperation:
    def __init__(self, operation_id: t.Optional[str], next_app: ASGIApp) -> None:
        ...
    
    @classmethod
    def from_operation(cls, operation: AbstractOperation, next_app: ASGIApp): # -> Self:
        ...
    
    async def __call__(self, scope: Scope, receive: Receive, send: Send) -> None:
        """Attach operation to scope and pass it to the next app"""
        ...
    


class RoutingAPI(AbstractRoutingAPI):
    def __init__(self, specification: Specification, *, next_app: ASGIApp, base_path: t.Optional[str] = ..., arguments: t.Optional[dict] = ..., resolver: t.Optional[Resolver] = ..., resolver_error_handler: t.Optional[t.Callable] = ..., debug: bool = ..., **kwargs) -> None:
        """API implementation on top of Starlette Router for Connexion middleware."""
        ...
    
    def make_operation(self, operation: AbstractOperation) -> RoutingOperation:
        ...
    


class RoutingMiddleware(SpecMiddleware):
    def __init__(self, app: ASGIApp) -> None:
        """Middleware that resolves the Operation for an incoming request and attaches it to the
        scope.

        :param app: app to wrap in middleware.
        """
        ...
    
    def add_api(self, specification: Specification, base_path: t.Optional[str] = ..., arguments: t.Optional[dict] = ..., **kwargs) -> None:
        """Add an API to the router based on a OpenAPI spec.

        :param specification: OpenAPI spec.
        :param base_path: Base path where to add this API.
        :param arguments: Jinja arguments to replace in the spec.
        """
        ...
    
    async def __call__(self, scope: Scope, receive: Receive, send: Send) -> None:
        """Route request to matching operation, and attach it to the scope before calling the
        next app."""
        ...
    


