# `Ligare`

A collection of Python libraries for creating Python applications quickly.

The word "ligare" (pronounced "lee - gah - reh") means "to bind" or "to tie" - and that is the overall intent of the Ligare framework. Ligare "ties together" many disparate Python functionalities into a single framework from which a variety of applications can be developed. The name is inspired by the Connexion framework, whose own names stems from the word "connection." Ligare supports web applications, console applications, database connectivity, development libraries and tools, and more - all with a common core architecture.

# Quick Starts

**🚩** `Ligare` has a minimum Python version requirement of `>= 3.10`.

* Create a Ligare [web application](src/web/README.md)
* Contribute to [Ligare Development](https://github.com/uclahs-cds/Ligare/wiki/Ligare-Development). Run `make` to get started!


# Available Libraries

Following are each of the libraries in this repository.

They can be used in Python under the `Ligare` namespace. For example, to use the database libraries you would import from `Ligare.database`.

To use these packages during development of `Ligare` itself, please refer to [Development](#development).

## AWS [ `Ligare.aws` ]
Libraries for working with AWS.

Review the `Ligare.AWS` [readme](src/AWS/README.md)

#### PyPI Package Name
`ligare.aws`

#### Git VCS URL
`ligare-aws@ git+ssh://git@github.com/uclahs-cds/Ligare.git@main#subdirectory=src/AWS`

## Database [ `Ligare.database` ]
Libraries for working with SQLite and PostgreSQL databases.

Review the `Ligare.database` [readme](src/database/README.md)

#### PyPI Package Name
`ligare.database`

#### Git VCS URL
`ligare-database@ git+ssh://git@github.com/uclahs-cds/Ligare.git@main#subdirectory=src/database`

## Development [ `Ligare.development` ]
Utilities and tools for assisting in development of software.

Review the `Ligare.development` [readme](src/development/README.md)

#### PyPI Package Name
`ligare.development`

#### Git VCS URL
`ligare-development@ git+ssh://git@github.com/uclahs-cds/Ligare.git@main#subdirectory=src/development`

## Development [ `Ligare.GitHub` ]
Utilities for working with the GitHub HTTP API. Uses `PyGithub` under the hood.

Review the `Ligare.GitHub` [readme](src/GitHub/README.md)

#### PyPI Package Name
`ligare.github`

#### Git VCS URL
`ligare-github@ git+ssh://git@github.com/uclahs-cds/Ligare.git@main#subdirectory=src/GitHub`

## Platform [ `Ligare.platform` ]
Libraries for PaaS offerings such as tools for altering application configurations.

Review the `Ligare.platform` [readme](src/platform/README.md)

#### PyPI Package Name
`ligare.platform`

#### Git VCS URL
`ligare-platform@ git+ssh://git@github.com/uclahs-cds/Ligare.git@main#subdirectory=src/platform`

## Programming [ `Ligare.programming` ]
Libraries used for writing software, such as pattern implementations so wheels don't need to be reinvented.

Review the `Ligare.programming` [readme](src/programming/README.md)

#### PyPI Package Name
`ligare.programming`

#### Git VCS URL
`ligare-programming@ git+ssh://git@github.com/uclahs-cds/Ligare.git@main#subdirectory=src/programming`

## Testing [ `Ligare.testing` ]
Libraries used to aid in automated testing.

Review the `Ligare.testing` [readme](src/testing/README.md)

#### PyPI Package Name
`ligare.testing`

#### Git VCS URL
`ligare-testing@ git+ssh://git@github.com/uclahs-cds/Ligare.git@main#subdirectory=src/testing`

## Web [ `Ligare.web` ]
Libraries used to building web applications.

Review the `Ligare.web` [readme](src/web/README.md)

#### PyPI Package Name
`ligare.web`

#### Git VCS URL
`ligare-web@ git+ssh://git@github.com/uclahs-cds/Ligare.git@main#subdirectory=src/web`

# Development

Review [Ligare Development](https://github.com/uclahs-cds/Ligare/wiki/Ligare-Development) for detailed information.
