"""initial tables

Peek Plugin Database Migration Script

Revision ID: c1d2d5475c64
Revises: 
Create Date: 2018-06-21 22:49:45.976813

"""

# revision identifiers, used by Alembic.
revision = "c1d2d5475c64"
down_revision = None
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "DocDbModelSet",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("comment", sa.String(), nullable=True),
        sa.Column("propsJson", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("key"),
        sa.UniqueConstraint("name"),
        schema="core_docdb",
    )
    op.create_table(
        "Setting",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        schema="core_docdb",
    )
    op.create_table(
        "DocDbChunkQueue",
        sa.Column("id", sa.Integer(), nullable=False, autoincrement=True),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("chunkKey", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["core_docdb.DocDbModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id", "chunkKey"),
        schema="core_docdb",
    )
    op.create_table(
        "DocDbDocumentType",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["core_docdb.DocDbModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="core_docdb",
    )
    op.create_index(
        "idx_DocType_model_name",
        "DocDbDocumentType",
        ["modelSetId", "name"],
        unique=True,
        schema="core_docdb",
    )
    op.create_index(
        "idx_DocType_model_title",
        "DocDbDocumentType",
        ["modelSetId", "title"],
        unique=True,
        schema="core_docdb",
    )
    op.create_table(
        "DocDbEncodedChunkTuple",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("chunkKey", sa.String(), nullable=False),
        sa.Column("encodedData", sa.LargeBinary(), nullable=False),
        sa.Column("encodedHash", sa.String(), nullable=False),
        sa.Column("lastUpdate", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["core_docdb.DocDbModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="core_docdb",
    )
    op.create_index(
        "idx_Chunk_modelSetId_chunkKey",
        "DocDbEncodedChunkTuple",
        ["modelSetId", "chunkKey"],
        unique=False,
        schema="core_docdb",
    )
    op.create_table(
        "DocDbProperty",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("order", sa.Integer(), server_default="0", nullable=False),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["core_docdb.DocDbModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="core_docdb",
    )
    op.create_index(
        "idx_DocDbProp_model_name",
        "DocDbProperty",
        ["modelSetId", "name"],
        unique=True,
        schema="core_docdb",
    )
    op.create_index(
        "idx_DocDbProp_model_title",
        "DocDbProperty",
        ["modelSetId", "title"],
        unique=True,
        schema="core_docdb",
    )
    op.create_table(
        "SettingProperty",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("settingId", sa.Integer(), nullable=False),
        sa.Column("key", sa.String(length=50), nullable=False),
        sa.Column("type", sa.String(length=16), nullable=True),
        sa.Column("int_value", sa.Integer(), nullable=True),
        sa.Column("char_value", sa.String(), nullable=True),
        sa.Column("boolean_value", sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(
            ["settingId"],
            ["core_docdb.Setting.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="core_docdb",
    )
    op.create_index(
        "idx_SettingProperty_settingId",
        "SettingProperty",
        ["settingId"],
        unique=False,
        schema="core_docdb",
    )
    op.create_table(
        "DocDbDocument",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("documentTypeId", sa.Integer(), nullable=False),
        sa.Column("importGroupHash", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("chunkKey", sa.String(), nullable=False),
        sa.Column("documentJson", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["documentTypeId"], ["core_docdb.DocDbDocumentType.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["core_docdb.DocDbModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="core_docdb",
    )
    op.create_index(
        "idx_Document_documentType",
        "DocDbDocument",
        ["documentTypeId"],
        unique=False,
        schema="core_docdb",
    )
    op.create_index(
        "idx_Document_gridKey",
        "DocDbDocument",
        ["chunkKey"],
        unique=False,
        schema="core_docdb",
    )
    op.create_index(
        "idx_Document_importGroupHash",
        "DocDbDocument",
        ["importGroupHash"],
        unique=False,
        schema="core_docdb",
    )
    op.create_index(
        "idx_Document_key",
        "DocDbDocument",
        ["modelSetId", "key"],
        unique=True,
        schema="core_docdb",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("idx_Document_key", table_name="DocDbDocument", schema="core_docdb")
    op.drop_index(
        "idx_Document_importGroupHash", table_name="DocDbDocument", schema="core_docdb"
    )
    op.drop_index(
        "idx_Document_gridKey", table_name="DocDbDocument", schema="core_docdb"
    )
    op.drop_index(
        "idx_Document_documentType", table_name="DocDbDocument", schema="core_docdb"
    )
    op.drop_table("DocDbDocument", schema="core_docdb")
    op.drop_index(
        "idx_SettingProperty_settingId",
        table_name="SettingProperty",
        schema="core_docdb",
    )
    op.drop_table("SettingProperty", schema="core_docdb")
    op.drop_index(
        "idx_DocDbProp_model_title", table_name="DocDbProperty", schema="core_docdb"
    )
    op.drop_index(
        "idx_DocDbProp_model_name", table_name="DocDbProperty", schema="core_docdb"
    )
    op.drop_table("DocDbProperty", schema="core_docdb")
    op.drop_index(
        "idx_Chunk_modelSetId_chunkKey",
        table_name="DocDbEncodedChunkTuple",
        schema="core_docdb",
    )
    op.drop_table("DocDbEncodedChunkTuple", schema="core_docdb")
    op.drop_index(
        "idx_DocType_model_title", table_name="DocDbDocumentType", schema="core_docdb"
    )
    op.drop_index(
        "idx_DocType_model_name", table_name="DocDbDocumentType", schema="core_docdb"
    )
    op.drop_table("DocDbDocumentType", schema="core_docdb")
    op.drop_table("DocDbChunkQueue", schema="core_docdb")
    op.drop_table("Setting", schema="core_docdb")
    op.drop_table("DocDbModelSet", schema="core_docdb")
    # ### end Alembic commands ###
