from typing import Any, Iterable, List, Optional, Union

from com.inductiveautomation.ignition.common import QualifiedPath
from com.inductiveautomation.ignition.common.config import (
    BasicProperty,
    Property,
    PropertySet,
    PropertyValue,
)
from com.inductiveautomation.ignition.common.user.schedule import ScheduleAdjustment
from java.lang import Object, String
from java.util import Date

class ContactInfo(Object):
    contactType: String
    value: String
    def __init__(self, *args: Any) -> None: ...
    def getContactType(self) -> String: ...
    def getValue(self) -> String: ...
    def setContactType(self, contactType: String) -> None: ...
    def setValue(self, value: String) -> None: ...

class User:
    Badge: BasicProperty
    DEFAULT_SCHEDULE_NAME: str
    FirstName: BasicProperty
    Language: BasicProperty
    LastName: BasicProperty
    Notes: BasicProperty
    Password: BasicProperty
    Schedule: BasicProperty
    Username: BasicProperty
    USERNAME_PATTERN: str
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getId(self) -> Any: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> String: ...
    def getRoles(self) -> List[String]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...

class BasicUser(User):
    contactInfo: Optional[List[ContactInfo]]
    id: Any
    profileName: String
    roles: List[String]
    scheduleAdjustments: List[ScheduleAdjustment]
    def __init__(
        self,
        profileName: String,
        id_: Any,
        roles: List[String],
        contactInfo: Optional[List[ContactInfo]] = ...,
    ) -> None: ...
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getId(self) -> Any: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> String: ...
    def getRoles(self) -> List[String]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...

class PyUser(User):
    def __init__(self, user: Optional[User] = ...) -> None: ...
    def addContactInfo(self, *args: Any) -> None: ...
    def addRole(self, role: String) -> None: ...
    def addRoles(self, roles: List[String]) -> None: ...
    def addScheduleAdjustment(
        self, start: Date, end: Date, available: bool, note: String
    ) -> None: ...
    def addScheduleAdjustments(
        self, scheduleAdjustments: List[ScheduleAdjustment]
    ) -> None: ...
    def contains(self, prop: Property) -> bool: ...
    def get(self, propertyName: Union[Property, String]) -> Any: ...
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getCount(self) -> int: ...
    def getId(self) -> Any: ...
    def getOrDefault(self, prop: Property) -> Any: ...
    def getOrElse(self, property: Property, value: Any) -> Any: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> String: ...
    def getProperties(self) -> List[Property]: ...
    def getRoles(self) -> List[String]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...
    def getValues(self) -> List[PropertyValue]: ...
    def isExtended(self, prop: Property) -> bool: ...
    def isInherited(self, prop: Property) -> bool: ...
    def iterator(self) -> Iterable[Property]: ...
    def merge(self, other: PropertySet, localOnly: bool) -> None: ...
    def remove(self, prop: Property) -> None: ...
    def removeContactInfo(self, contactType: String, value: String) -> None: ...
    def removeRole(self, role: String) -> None: ...
    def removeScheduleAdjustment(
        self, start: Date, end: Date, available: bool, note: String
    ) -> None: ...
    def set(self, *args: Any) -> None: ...
    def setContactInfo(self, contactInfo: List[ContactInfo]) -> None: ...
    def setRoles(self, roles: List[String]) -> None: ...
    def setScheduleAdjustments(
        self, scheduleAdjustments: List[ScheduleAdjustment]
    ) -> None: ...

class UserSourceMeta(Object):
    description: String
    name: String
    type: String
    def __init__(self, name: String, description: String, type_: String) -> None: ...
    def getName(self) -> String: ...
    def getDescription(self) -> String: ...
    def getType(self) -> String: ...
