from typing import Any, List

from java.lang import Class, Enum, Object, String

class OPCBrowseElement:
    def getDataType(self) -> Class: ...
    def getDescription(self) -> String: ...
    def getDisplayName(self) -> String: ...
    def getElementType(self) -> BrowseElementType: ...
    def getServerNodeId(self) -> ServerNodeId: ...

class ServerNodeId:
    def getNodeId(self) -> String: ...
    def getServerName(self) -> String: ...

class BasicOPCBrowseElement(Object, OPCBrowseElement):
    def __init__(self, *args: Any) -> None: ...
    def getDataType(self) -> Class: ...
    def getDescription(self) -> String: ...
    def getDisplayName(self) -> String: ...
    def getElementType(self) -> BrowseElementType: ...
    def getServerNodeId(self) -> ServerNodeId: ...

class BasicServerNodeId(Object, ServerNodeId):
    nodeId: String
    serverName: String
    def __init__(self, serverName: String, nodeId: String) -> None: ...
    def getNodeId(self) -> String: ...
    def getServerName(self) -> String: ...

class BrowseElementType(Enum):
    DATAVARIABLE: BrowseElementType
    DEVICE: BrowseElementType
    FOLDER: BrowseElementType
    METHOD: BrowseElementType
    OBJECT: BrowseElementType
    PROPERTY: BrowseElementType
    SERVER: BrowseElementType
    VIEW: BrowseElementType
    def isSubscribable(self) -> bool: ...
    @staticmethod
    def values() -> List[BrowseElementType]: ...

class ServerBrowseElement(Object, OPCBrowseElement):
    nodeId: ServerNodeId
    def __init__(self, serverName: String) -> None: ...
    def getDataType(self) -> Class: ...
    def getDescription(self) -> String: ...
    def getDisplayName(self) -> String: ...
    def getElementType(self) -> BrowseElementType: ...
    def getServerNodeId(self) -> ServerNodeId: ...
