# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class VipRouting(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        VipRouting - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'vip_call_media_settings': 'VipCallMediaSettings',
            'vip_email_media_settings': 'VipMediaSettings',
            'vip_message_media_settings': 'VipMediaSettings',
            'vip_max_ownership_time_seconds': 'int',
            'vip_backup': 'VipBackup'
        }

        self.attribute_map = {
            'vip_call_media_settings': 'vipCallMediaSettings',
            'vip_email_media_settings': 'vipEmailMediaSettings',
            'vip_message_media_settings': 'vipMessageMediaSettings',
            'vip_max_ownership_time_seconds': 'vipMaxOwnershipTimeSeconds',
            'vip_backup': 'vipBackup'
        }

        self._vip_call_media_settings = None
        self._vip_email_media_settings = None
        self._vip_message_media_settings = None
        self._vip_max_ownership_time_seconds = None
        self._vip_backup = None

    @property
    def vip_call_media_settings(self):
        """
        Gets the vip_call_media_settings of this VipRouting.
        VIP Settings specific to Call media.

        :return: The vip_call_media_settings of this VipRouting.
        :rtype: VipCallMediaSettings
        """
        return self._vip_call_media_settings

    @vip_call_media_settings.setter
    def vip_call_media_settings(self, vip_call_media_settings):
        """
        Sets the vip_call_media_settings of this VipRouting.
        VIP Settings specific to Call media.

        :param vip_call_media_settings: The vip_call_media_settings of this VipRouting.
        :type: VipCallMediaSettings
        """
        

        self._vip_call_media_settings = vip_call_media_settings

    @property
    def vip_email_media_settings(self):
        """
        Gets the vip_email_media_settings of this VipRouting.
        VIP Settings specific to Email media.

        :return: The vip_email_media_settings of this VipRouting.
        :rtype: VipMediaSettings
        """
        return self._vip_email_media_settings

    @vip_email_media_settings.setter
    def vip_email_media_settings(self, vip_email_media_settings):
        """
        Sets the vip_email_media_settings of this VipRouting.
        VIP Settings specific to Email media.

        :param vip_email_media_settings: The vip_email_media_settings of this VipRouting.
        :type: VipMediaSettings
        """
        

        self._vip_email_media_settings = vip_email_media_settings

    @property
    def vip_message_media_settings(self):
        """
        Gets the vip_message_media_settings of this VipRouting.
        VIP Settings specific to Message media.

        :return: The vip_message_media_settings of this VipRouting.
        :rtype: VipMediaSettings
        """
        return self._vip_message_media_settings

    @vip_message_media_settings.setter
    def vip_message_media_settings(self, vip_message_media_settings):
        """
        Sets the vip_message_media_settings of this VipRouting.
        VIP Settings specific to Message media.

        :param vip_message_media_settings: The vip_message_media_settings of this VipRouting.
        :type: VipMediaSettings
        """
        

        self._vip_message_media_settings = vip_message_media_settings

    @property
    def vip_max_ownership_time_seconds(self):
        """
        Gets the vip_max_ownership_time_seconds of this VipRouting.
        The max amount of time a VIP interaction will wait for the VIP user before going to the selected backup option (in seconds). Allowable range 10 seconds - 864000 seconds (ten days).

        :return: The vip_max_ownership_time_seconds of this VipRouting.
        :rtype: int
        """
        return self._vip_max_ownership_time_seconds

    @vip_max_ownership_time_seconds.setter
    def vip_max_ownership_time_seconds(self, vip_max_ownership_time_seconds):
        """
        Sets the vip_max_ownership_time_seconds of this VipRouting.
        The max amount of time a VIP interaction will wait for the VIP user before going to the selected backup option (in seconds). Allowable range 10 seconds - 864000 seconds (ten days).

        :param vip_max_ownership_time_seconds: The vip_max_ownership_time_seconds of this VipRouting.
        :type: int
        """
        

        self._vip_max_ownership_time_seconds = vip_max_ownership_time_seconds

    @property
    def vip_backup(self):
        """
        Gets the vip_backup of this VipRouting.
        VIP queue default VIP Backup settings for unanswered VIP interactions to fallback to. VIP Backup set for a specific VIP user has preference before queue default.

        :return: The vip_backup of this VipRouting.
        :rtype: VipBackup
        """
        return self._vip_backup

    @vip_backup.setter
    def vip_backup(self, vip_backup):
        """
        Sets the vip_backup of this VipRouting.
        VIP queue default VIP Backup settings for unanswered VIP interactions to fallback to. VIP Backup set for a specific VIP user has preference before queue default.

        :param vip_backup: The vip_backup of this VipRouting.
        :type: VipBackup
        """
        

        self._vip_backup = vip_backup

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

