# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UserScheduleFullDayTimeOffMarker(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UserScheduleFullDayTimeOffMarker - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'management_unit_date': 'str',
            'activity_code_id': 'str',
            'is_paid': 'bool',
            'length_in_minutes': 'int',
            'description': 'str',
            'delete': 'bool'
        }

        self.attribute_map = {
            'management_unit_date': 'managementUnitDate',
            'activity_code_id': 'activityCodeId',
            'is_paid': 'isPaid',
            'length_in_minutes': 'lengthInMinutes',
            'description': 'description',
            'delete': 'delete'
        }

        self._management_unit_date = None
        self._activity_code_id = None
        self._is_paid = None
        self._length_in_minutes = None
        self._description = None
        self._delete = None

    @property
    def management_unit_date(self):
        """
        Gets the management_unit_date of this UserScheduleFullDayTimeOffMarker.
        The date associated with the time off request that this marker corresponds to.  Date only, in ISO-8601 format.

        :return: The management_unit_date of this UserScheduleFullDayTimeOffMarker.
        :rtype: str
        """
        return self._management_unit_date

    @management_unit_date.setter
    def management_unit_date(self, management_unit_date):
        """
        Sets the management_unit_date of this UserScheduleFullDayTimeOffMarker.
        The date associated with the time off request that this marker corresponds to.  Date only, in ISO-8601 format.

        :param management_unit_date: The management_unit_date of this UserScheduleFullDayTimeOffMarker.
        :type: str
        """
        

        self._management_unit_date = management_unit_date

    @property
    def activity_code_id(self):
        """
        Gets the activity_code_id of this UserScheduleFullDayTimeOffMarker.
        The id for the activity code.  Look up a map of activity codes with the activities route

        :return: The activity_code_id of this UserScheduleFullDayTimeOffMarker.
        :rtype: str
        """
        return self._activity_code_id

    @activity_code_id.setter
    def activity_code_id(self, activity_code_id):
        """
        Sets the activity_code_id of this UserScheduleFullDayTimeOffMarker.
        The id for the activity code.  Look up a map of activity codes with the activities route

        :param activity_code_id: The activity_code_id of this UserScheduleFullDayTimeOffMarker.
        :type: str
        """
        

        self._activity_code_id = activity_code_id

    @property
    def is_paid(self):
        """
        Gets the is_paid of this UserScheduleFullDayTimeOffMarker.
        Whether this is paid time off

        :return: The is_paid of this UserScheduleFullDayTimeOffMarker.
        :rtype: bool
        """
        return self._is_paid

    @is_paid.setter
    def is_paid(self, is_paid):
        """
        Sets the is_paid of this UserScheduleFullDayTimeOffMarker.
        Whether this is paid time off

        :param is_paid: The is_paid of this UserScheduleFullDayTimeOffMarker.
        :type: bool
        """
        

        self._is_paid = is_paid

    @property
    def length_in_minutes(self):
        """
        Gets the length_in_minutes of this UserScheduleFullDayTimeOffMarker.
        The length in minutes of this time off marker

        :return: The length_in_minutes of this UserScheduleFullDayTimeOffMarker.
        :rtype: int
        """
        return self._length_in_minutes

    @length_in_minutes.setter
    def length_in_minutes(self, length_in_minutes):
        """
        Sets the length_in_minutes of this UserScheduleFullDayTimeOffMarker.
        The length in minutes of this time off marker

        :param length_in_minutes: The length_in_minutes of this UserScheduleFullDayTimeOffMarker.
        :type: int
        """
        

        self._length_in_minutes = length_in_minutes

    @property
    def description(self):
        """
        Gets the description of this UserScheduleFullDayTimeOffMarker.
        The description associated with the time off request that this marker corresponds to

        :return: The description of this UserScheduleFullDayTimeOffMarker.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UserScheduleFullDayTimeOffMarker.
        The description associated with the time off request that this marker corresponds to

        :param description: The description of this UserScheduleFullDayTimeOffMarker.
        :type: str
        """
        

        self._description = description

    @property
    def delete(self):
        """
        Gets the delete of this UserScheduleFullDayTimeOffMarker.
        If marked true for updating an existing full day time off marker, it will be deleted

        :return: The delete of this UserScheduleFullDayTimeOffMarker.
        :rtype: bool
        """
        return self._delete

    @delete.setter
    def delete(self, delete):
        """
        Sets the delete of this UserScheduleFullDayTimeOffMarker.
        If marked true for updating an existing full day time off marker, it will be deleted

        :param delete: The delete of this UserScheduleFullDayTimeOffMarker.
        :type: bool
        """
        

        self._delete = delete

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

