# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class MessagingCampaign(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        MessagingCampaign - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'division': 'DomainEntityRef',
            'campaign_status': 'str',
            'callable_time_set': 'DomainEntityRef',
            'contact_list': 'DomainEntityRef',
            'dnc_lists': 'list[DomainEntityRef]',
            'always_running': 'bool',
            'contact_sorts': 'list[ContactSort]',
            'messages_per_minute': 'int',
            'contact_list_filters': 'list[DomainEntityRef]',
            'errors': 'list[RestErrorDetail]',
            'email_config': 'EmailConfig',
            'sms_config': 'SmsConfig',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'division': 'division',
            'campaign_status': 'campaignStatus',
            'callable_time_set': 'callableTimeSet',
            'contact_list': 'contactList',
            'dnc_lists': 'dncLists',
            'always_running': 'alwaysRunning',
            'contact_sorts': 'contactSorts',
            'messages_per_minute': 'messagesPerMinute',
            'contact_list_filters': 'contactListFilters',
            'errors': 'errors',
            'email_config': 'emailConfig',
            'sms_config': 'smsConfig',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._division = None
        self._campaign_status = None
        self._callable_time_set = None
        self._contact_list = None
        self._dnc_lists = None
        self._always_running = None
        self._contact_sorts = None
        self._messages_per_minute = None
        self._contact_list_filters = None
        self._errors = None
        self._email_config = None
        self._sms_config = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this MessagingCampaign.
        The globally unique identifier for the object.

        :return: The id of this MessagingCampaign.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MessagingCampaign.
        The globally unique identifier for the object.

        :param id: The id of this MessagingCampaign.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this MessagingCampaign.


        :return: The name of this MessagingCampaign.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MessagingCampaign.


        :param name: The name of this MessagingCampaign.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this MessagingCampaign.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this MessagingCampaign.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this MessagingCampaign.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this MessagingCampaign.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this MessagingCampaign.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this MessagingCampaign.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this MessagingCampaign.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this MessagingCampaign.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self):
        """
        Gets the version of this MessagingCampaign.
        Required for updates, must match the version number of the most recent update

        :return: The version of this MessagingCampaign.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this MessagingCampaign.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this MessagingCampaign.
        :type: int
        """
        

        self._version = version

    @property
    def division(self):
        """
        Gets the division of this MessagingCampaign.
        The division this entity belongs to.

        :return: The division of this MessagingCampaign.
        :rtype: DomainEntityRef
        """
        return self._division

    @division.setter
    def division(self, division):
        """
        Sets the division of this MessagingCampaign.
        The division this entity belongs to.

        :param division: The division of this MessagingCampaign.
        :type: DomainEntityRef
        """
        

        self._division = division

    @property
    def campaign_status(self):
        """
        Gets the campaign_status of this MessagingCampaign.
        The current status of the messaging campaign. A messaging campaign may be turned 'on' or 'off'.

        :return: The campaign_status of this MessagingCampaign.
        :rtype: str
        """
        return self._campaign_status

    @campaign_status.setter
    def campaign_status(self, campaign_status):
        """
        Sets the campaign_status of this MessagingCampaign.
        The current status of the messaging campaign. A messaging campaign may be turned 'on' or 'off'.

        :param campaign_status: The campaign_status of this MessagingCampaign.
        :type: str
        """
        allowed_values = ["on", "stopping", "off", "complete", "invalid"]
        if campaign_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for campaign_status -> " + campaign_status)
            self._campaign_status = "outdated_sdk_version"
        else:
            self._campaign_status = campaign_status

    @property
    def callable_time_set(self):
        """
        Gets the callable_time_set of this MessagingCampaign.
        The callable time set for this messaging campaign.

        :return: The callable_time_set of this MessagingCampaign.
        :rtype: DomainEntityRef
        """
        return self._callable_time_set

    @callable_time_set.setter
    def callable_time_set(self, callable_time_set):
        """
        Sets the callable_time_set of this MessagingCampaign.
        The callable time set for this messaging campaign.

        :param callable_time_set: The callable_time_set of this MessagingCampaign.
        :type: DomainEntityRef
        """
        

        self._callable_time_set = callable_time_set

    @property
    def contact_list(self):
        """
        Gets the contact_list of this MessagingCampaign.
        The contact list that this messaging campaign will send messages for.

        :return: The contact_list of this MessagingCampaign.
        :rtype: DomainEntityRef
        """
        return self._contact_list

    @contact_list.setter
    def contact_list(self, contact_list):
        """
        Sets the contact_list of this MessagingCampaign.
        The contact list that this messaging campaign will send messages for.

        :param contact_list: The contact_list of this MessagingCampaign.
        :type: DomainEntityRef
        """
        

        self._contact_list = contact_list

    @property
    def dnc_lists(self):
        """
        Gets the dnc_lists of this MessagingCampaign.
        The dnc lists to check before sending a message for this messaging campaign.

        :return: The dnc_lists of this MessagingCampaign.
        :rtype: list[DomainEntityRef]
        """
        return self._dnc_lists

    @dnc_lists.setter
    def dnc_lists(self, dnc_lists):
        """
        Sets the dnc_lists of this MessagingCampaign.
        The dnc lists to check before sending a message for this messaging campaign.

        :param dnc_lists: The dnc_lists of this MessagingCampaign.
        :type: list[DomainEntityRef]
        """
        

        self._dnc_lists = dnc_lists

    @property
    def always_running(self):
        """
        Gets the always_running of this MessagingCampaign.
        Whether this messaging campaign is always running

        :return: The always_running of this MessagingCampaign.
        :rtype: bool
        """
        return self._always_running

    @always_running.setter
    def always_running(self, always_running):
        """
        Sets the always_running of this MessagingCampaign.
        Whether this messaging campaign is always running

        :param always_running: The always_running of this MessagingCampaign.
        :type: bool
        """
        

        self._always_running = always_running

    @property
    def contact_sorts(self):
        """
        Gets the contact_sorts of this MessagingCampaign.
        The order in which to sort contacts for dialing, based on up to four columns.

        :return: The contact_sorts of this MessagingCampaign.
        :rtype: list[ContactSort]
        """
        return self._contact_sorts

    @contact_sorts.setter
    def contact_sorts(self, contact_sorts):
        """
        Sets the contact_sorts of this MessagingCampaign.
        The order in which to sort contacts for dialing, based on up to four columns.

        :param contact_sorts: The contact_sorts of this MessagingCampaign.
        :type: list[ContactSort]
        """
        

        self._contact_sorts = contact_sorts

    @property
    def messages_per_minute(self):
        """
        Gets the messages_per_minute of this MessagingCampaign.
        How many messages this messaging campaign will send per minute.

        :return: The messages_per_minute of this MessagingCampaign.
        :rtype: int
        """
        return self._messages_per_minute

    @messages_per_minute.setter
    def messages_per_minute(self, messages_per_minute):
        """
        Sets the messages_per_minute of this MessagingCampaign.
        How many messages this messaging campaign will send per minute.

        :param messages_per_minute: The messages_per_minute of this MessagingCampaign.
        :type: int
        """
        

        self._messages_per_minute = messages_per_minute

    @property
    def contact_list_filters(self):
        """
        Gets the contact_list_filters of this MessagingCampaign.
        The contact list filter to check before sending a message for this messaging campaign.

        :return: The contact_list_filters of this MessagingCampaign.
        :rtype: list[DomainEntityRef]
        """
        return self._contact_list_filters

    @contact_list_filters.setter
    def contact_list_filters(self, contact_list_filters):
        """
        Sets the contact_list_filters of this MessagingCampaign.
        The contact list filter to check before sending a message for this messaging campaign.

        :param contact_list_filters: The contact_list_filters of this MessagingCampaign.
        :type: list[DomainEntityRef]
        """
        

        self._contact_list_filters = contact_list_filters

    @property
    def errors(self):
        """
        Gets the errors of this MessagingCampaign.
        A list of current error conditions associated with this messaging campaign.

        :return: The errors of this MessagingCampaign.
        :rtype: list[RestErrorDetail]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """
        Sets the errors of this MessagingCampaign.
        A list of current error conditions associated with this messaging campaign.

        :param errors: The errors of this MessagingCampaign.
        :type: list[RestErrorDetail]
        """
        

        self._errors = errors

    @property
    def email_config(self):
        """
        Gets the email_config of this MessagingCampaign.
        Configuration for this messaging campaign to send Email messages.

        :return: The email_config of this MessagingCampaign.
        :rtype: EmailConfig
        """
        return self._email_config

    @email_config.setter
    def email_config(self, email_config):
        """
        Sets the email_config of this MessagingCampaign.
        Configuration for this messaging campaign to send Email messages.

        :param email_config: The email_config of this MessagingCampaign.
        :type: EmailConfig
        """
        

        self._email_config = email_config

    @property
    def sms_config(self):
        """
        Gets the sms_config of this MessagingCampaign.
        Configuration for this messaging campaign to send SMS messages.

        :return: The sms_config of this MessagingCampaign.
        :rtype: SmsConfig
        """
        return self._sms_config

    @sms_config.setter
    def sms_config(self, sms_config):
        """
        Sets the sms_config of this MessagingCampaign.
        Configuration for this messaging campaign to send SMS messages.

        :param sms_config: The sms_config of this MessagingCampaign.
        :type: SmsConfig
        """
        

        self._sms_config = sms_config

    @property
    def self_uri(self):
        """
        Gets the self_uri of this MessagingCampaign.
        The URI for this object

        :return: The self_uri of this MessagingCampaign.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this MessagingCampaign.
        The URI for this object

        :param self_uri: The self_uri of this MessagingCampaign.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

