# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ConversationEncryptionConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ConversationEncryptionConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'url': 'str',
            'key_configuration_type': 'str',
            'last_error': 'ErrorBody',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'url': 'url',
            'key_configuration_type': 'keyConfigurationType',
            'last_error': 'lastError',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._url = None
        self._key_configuration_type = None
        self._last_error = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ConversationEncryptionConfiguration.
        The globally unique identifier for the object.

        :return: The id of this ConversationEncryptionConfiguration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ConversationEncryptionConfiguration.
        The globally unique identifier for the object.

        :param id: The id of this ConversationEncryptionConfiguration.
        :type: str
        """
        

        self._id = id

    @property
    def url(self):
        """
        Gets the url of this ConversationEncryptionConfiguration.
        keyConfigurationType is always KmsSymmetric, and should be the arn to the key alias for the master key

        :return: The url of this ConversationEncryptionConfiguration.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this ConversationEncryptionConfiguration.
        keyConfigurationType is always KmsSymmetric, and should be the arn to the key alias for the master key

        :param url: The url of this ConversationEncryptionConfiguration.
        :type: str
        """
        

        self._url = url

    @property
    def key_configuration_type(self):
        """
        Gets the key_configuration_type of this ConversationEncryptionConfiguration.
        Type should be 'KmsSymmetric' when create or update Key configurations, 'None' to disable configuration.

        :return: The key_configuration_type of this ConversationEncryptionConfiguration.
        :rtype: str
        """
        return self._key_configuration_type

    @key_configuration_type.setter
    def key_configuration_type(self, key_configuration_type):
        """
        Sets the key_configuration_type of this ConversationEncryptionConfiguration.
        Type should be 'KmsSymmetric' when create or update Key configurations, 'None' to disable configuration.

        :param key_configuration_type: The key_configuration_type of this ConversationEncryptionConfiguration.
        :type: str
        """
        allowed_values = ["KmsSymmetric", "LocalKeyManager", "Native", "None"]
        if key_configuration_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for key_configuration_type -> " + key_configuration_type)
            self._key_configuration_type = "outdated_sdk_version"
        else:
            self._key_configuration_type = key_configuration_type

    @property
    def last_error(self):
        """
        Gets the last_error of this ConversationEncryptionConfiguration.
        The error message related to the configuration

        :return: The last_error of this ConversationEncryptionConfiguration.
        :rtype: ErrorBody
        """
        return self._last_error

    @last_error.setter
    def last_error(self, last_error):
        """
        Sets the last_error of this ConversationEncryptionConfiguration.
        The error message related to the configuration

        :param last_error: The last_error of this ConversationEncryptionConfiguration.
        :type: ErrorBody
        """
        

        self._last_error = last_error

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ConversationEncryptionConfiguration.
        The URI for this object

        :return: The self_uri of this ConversationEncryptionConfiguration.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ConversationEncryptionConfiguration.
        The URI for this object

        :param self_uri: The self_uri of this ConversationEncryptionConfiguration.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

