# coding: utf-8

"""
JourneyApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class JourneyApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_journey_actionmap(self, action_map_id, **kwargs):
        """
        Delete single action map.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_actionmap(action_map_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_map_id: ID of the action map. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_map_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_actionmap" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_map_id' is set
        if ('action_map_id' not in params) or (params['action_map_id'] is None):
            raise ValueError("Missing the required parameter `action_map_id` when calling `delete_journey_actionmap`")


        resource_path = '/api/v2/journey/actionmaps/{actionMapId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_map_id' in params:
            path_params['actionMapId'] = params['action_map_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_journey_actiontemplate(self, action_template_id, **kwargs):
        """
        Delete a single action template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_actiontemplate(action_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_template_id: ID of the action template. (required)
        :param bool hard_delete: Determines whether Action Template should be soft-deleted (have it's state set to deleted) or hard-deleted (permanently removed). Set to false (soft-delete) by default.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_template_id', 'hard_delete']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_actiontemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_template_id' is set
        if ('action_template_id' not in params) or (params['action_template_id'] is None):
            raise ValueError("Missing the required parameter `action_template_id` when calling `delete_journey_actiontemplate`")


        resource_path = '/api/v2/journey/actiontemplates/{actionTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_template_id' in params:
            path_params['actionTemplateId'] = params['action_template_id']

        query_params = {}
        if 'hard_delete' in params:
            query_params['hardDelete'] = params['hard_delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_journey_outcome(self, outcome_id, **kwargs):
        """
        Delete an outcome.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_outcome(outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str outcome_id: ID of the outcome. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outcome_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `delete_journey_outcome`")


        resource_path = '/api/v2/journey/outcomes/{outcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'outcome_id' in params:
            path_params['outcomeId'] = params['outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_journey_segment(self, segment_id, **kwargs):
        """
        Delete a segment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_segment(segment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str segment_id: ID of the segment. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_segment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params) or (params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `delete_journey_segment`")


        resource_path = '/api/v2/journey/segments/{segmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'segment_id' in params:
            path_params['segmentId'] = params['segment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actionmap(self, action_map_id, **kwargs):
        """
        Retrieve a single action map.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actionmap(action_map_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_map_id: ID of the action map. (required)
        :return: ActionMap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_map_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actionmap" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_map_id' is set
        if ('action_map_id' not in params) or (params['action_map_id'] is None):
            raise ValueError("Missing the required parameter `action_map_id` when calling `get_journey_actionmap`")


        resource_path = '/api/v2/journey/actionmaps/{actionMapId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_map_id' in params:
            path_params['actionMapId'] = params['action_map_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actionmaps(self, **kwargs):
        """
        Retrieve all action maps.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actionmaps(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Field(s) to sort by. Prefix with '-' for descending (e.g. sortBy=displayName,-createdDate).
        :param str filter_field: Field to filter by (e.g. filterField=weight or filterField=action.actionTemplate.id). Requires 'filterField' to also be set.
        :param str filter_value: Value to filter by. Requires 'filterValue' to also be set.
        :param list[str] action_map_ids: IDs of action maps to return. Use of this parameter is not compatible with pagination, filtering, sorting or querying. A maximum of 100 action maps are allowed per request.
        :param list[str] query_fields: Action Map field(s) to query on. Requires 'queryValue' to also be set.
        :param str query_value: Value to query on. Requires 'queryFields' to also be set.
        :return: ActionMapListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'filter_field', 'filter_value', 'action_map_ids', 'query_fields', 'query_value']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actionmaps" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actionmaps'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'filter_field' in params:
            query_params['filterField'] = params['filter_field']
        if 'filter_value' in params:
            query_params['filterValue'] = params['filter_value']
        if 'action_map_ids' in params:
            query_params['actionMapIds'] = params['action_map_ids']
        if 'query_fields' in params:
            query_params['queryFields'] = params['query_fields']
        if 'query_value' in params:
            query_params['queryValue'] = params['query_value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMapListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actionmaps_estimates_job(self, job_id, **kwargs):
        """
        Get status of job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actionmaps_estimates_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: ID of the job. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actionmaps_estimates_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_journey_actionmaps_estimates_job`")


        resource_path = '/api/v2/journey/actionmaps/estimates/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actionmaps_estimates_job_results(self, job_id, **kwargs):
        """
        Get estimates from completed job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actionmaps_estimates_job_results(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: ID of the job. (required)
        :return: ActionMapEstimateResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actionmaps_estimates_job_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_journey_actionmaps_estimates_job_results`")


        resource_path = '/api/v2/journey/actionmaps/estimates/jobs/{jobId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMapEstimateResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actiontarget(self, action_target_id, **kwargs):
        """
        Retrieve a single action target.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actiontarget(action_target_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_target_id: ID of the action target. (required)
        :return: ActionTarget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_target_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actiontarget" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_target_id' is set
        if ('action_target_id' not in params) or (params['action_target_id'] is None):
            raise ValueError("Missing the required parameter `action_target_id` when calling `get_journey_actiontarget`")


        resource_path = '/api/v2/journey/actiontargets/{actionTargetId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_target_id' in params:
            path_params['actionTargetId'] = params['action_target_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTarget',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actiontargets(self, **kwargs):
        """
        Retrieve all action targets.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actiontargets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: ActionTargetListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actiontargets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actiontargets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTargetListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actiontemplate(self, action_template_id, **kwargs):
        """
        Retrieve a single action template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actiontemplate(action_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_template_id: ID of the action template. (required)
        :return: ActionTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actiontemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_template_id' is set
        if ('action_template_id' not in params) or (params['action_template_id'] is None):
            raise ValueError("Missing the required parameter `action_template_id` when calling `get_journey_actiontemplate`")


        resource_path = '/api/v2/journey/actiontemplates/{actionTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_template_id' in params:
            path_params['actionTemplateId'] = params['action_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actiontemplates(self, **kwargs):
        """
        Retrieve all action templates.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actiontemplates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Field(s) to sort by. Prefix with '-' for descending (e.g. sortBy=name,-createdDate).
        :param str media_type: Media type
        :param str state: Action template state.
        :param list[str] query_fields: ActionTemplate field(s) to query on. Requires 'queryValue' to also be set.
        :param str query_value: Value to query on. Requires 'queryFields' to also be set.
        :return: ActionTemplateListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'media_type', 'state', 'query_fields', 'query_value']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actiontemplates" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actiontemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'media_type' in params:
            query_params['mediaType'] = params['media_type']
        if 'state' in params:
            query_params['state'] = params['state']
        if 'query_fields' in params:
            query_params['queryFields'] = params['query_fields']
        if 'query_value' in params:
            query_params['queryValue'] = params['query_value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTemplateListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_outcome(self, outcome_id, **kwargs):
        """
        Retrieve a single outcome.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_outcome(outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str outcome_id: ID of the outcome. (required)
        :return: Outcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outcome_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `get_journey_outcome`")


        resource_path = '/api/v2/journey/outcomes/{outcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'outcome_id' in params:
            path_params['outcomeId'] = params['outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Outcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_outcomes(self, **kwargs):
        """
        Retrieve all outcomes.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_outcomes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Field(s) to sort by. The response can be sorted by any first level property on the Outcome response. Prefix with '-' for descending (e.g. sortBy=displayName,-createdDate).
        :param list[str] outcome_ids: IDs of outcomes to return. Use of this parameter is not compatible with pagination, sorting or querying. A maximum of 20 outcomes are allowed per request.
        :param list[str] query_fields: Outcome field(s) to query on. Requires 'queryValue' to also be set.
        :param str query_value: Value to query on. Requires 'queryFields' to also be set.
        :return: OutcomeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'outcome_ids', 'query_fields', 'query_value']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_outcomes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/outcomes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'outcome_ids' in params:
            query_params['outcomeIds'] = params['outcome_ids']
        if 'query_fields' in params:
            query_params['queryFields'] = params['query_fields']
        if 'query_value' in params:
            query_params['queryValue'] = params['query_value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_segment(self, segment_id, **kwargs):
        """
        Retrieve a single segment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_segment(segment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str segment_id: ID of the segment. (required)
        :return: JourneySegment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_segment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params) or (params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `get_journey_segment`")


        resource_path = '/api/v2/journey/segments/{segmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'segment_id' in params:
            path_params['segmentId'] = params['segment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneySegment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_segments(self, **kwargs):
        """
        Retrieve all segments.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_segments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sort_by: Field(s) to sort by. The response can be sorted by any first level property on the Outcome response. Prefix with '-' for descending (e.g. sortBy=displayName,-createdDate).
        :param int page_size: Page size
        :param int page_number: Page number
        :param bool is_active: Determines whether or not to show only active segments.
        :param list[str] segment_ids: IDs of segments to return. Use of this parameter is not compatible with pagination, sorting or querying. A maximum of 100 segments are allowed per request.
        :param list[str] query_fields: Segment field(s) to query on. Requires 'queryValue' to also be set.
        :param str query_value: Value to query on. Requires 'queryFields' to also be set.
        :return: SegmentListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort_by', 'page_size', 'page_number', 'is_active', 'segment_ids', 'query_fields', 'query_value']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_segments" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/segments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'is_active' in params:
            query_params['isActive'] = params['is_active']
        if 'segment_ids' in params:
            query_params['segmentIds'] = params['segment_ids']
        if 'query_fields' in params:
            query_params['queryFields'] = params['query_fields']
        if 'query_value' in params:
            query_params['queryValue'] = params['query_value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SegmentListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_session(self, session_id, **kwargs):
        """
        Retrieve a single session.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_session(session_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str session_id: ID of the session. (required)
        :return: Session
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['session_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_session" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'session_id' is set
        if ('session_id' not in params) or (params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_journey_session`")


        resource_path = '/api/v2/journey/sessions/{sessionId}'.replace('{format}', 'json')
        path_params = {}
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Session',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_session_outcomescores(self, session_id, **kwargs):
        """
        Retrieve latest outcome score associated with a session for all outcomes.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_session_outcomescores(session_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str session_id: ID of the session. (required)
        :return: OutcomeScoresResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['session_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_session_outcomescores" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'session_id' is set
        if ('session_id' not in params) or (params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_journey_session_outcomescores`")


        resource_path = '/api/v2/journey/sessions/{sessionId}/outcomescores'.replace('{format}', 'json')
        path_params = {}
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeScoresResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_actionmap(self, action_map_id, **kwargs):
        """
        Update single action map.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_actionmap(action_map_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_map_id: ID of the action map. (required)
        :param PatchActionMap body: 
        :return: ActionMap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_map_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_actionmap" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_map_id' is set
        if ('action_map_id' not in params) or (params['action_map_id'] is None):
            raise ValueError("Missing the required parameter `action_map_id` when calling `patch_journey_actionmap`")


        resource_path = '/api/v2/journey/actionmaps/{actionMapId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_map_id' in params:
            path_params['actionMapId'] = params['action_map_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_actiontarget(self, action_target_id, **kwargs):
        """
        Update a single action target.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_actiontarget(action_target_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_target_id: ID of the action target. (required)
        :param PatchActionTarget body: 
        :return: ActionTarget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_target_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_actiontarget" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_target_id' is set
        if ('action_target_id' not in params) or (params['action_target_id'] is None):
            raise ValueError("Missing the required parameter `action_target_id` when calling `patch_journey_actiontarget`")


        resource_path = '/api/v2/journey/actiontargets/{actionTargetId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_target_id' in params:
            path_params['actionTargetId'] = params['action_target_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTarget',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_actiontemplate(self, action_template_id, **kwargs):
        """
        Update a single action template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_actiontemplate(action_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_template_id: ID of the action template. (required)
        :param PatchActionTemplate body: 
        :return: ActionTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_template_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_actiontemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_template_id' is set
        if ('action_template_id' not in params) or (params['action_template_id'] is None):
            raise ValueError("Missing the required parameter `action_template_id` when calling `patch_journey_actiontemplate`")


        resource_path = '/api/v2/journey/actiontemplates/{actionTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_template_id' in params:
            path_params['actionTemplateId'] = params['action_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_outcome(self, outcome_id, **kwargs):
        """
        Update an outcome.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_outcome(outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str outcome_id: ID of the outcome. (required)
        :param PatchOutcome body: 
        :return: Outcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outcome_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `patch_journey_outcome`")


        resource_path = '/api/v2/journey/outcomes/{outcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'outcome_id' in params:
            path_params['outcomeId'] = params['outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Outcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_segment(self, segment_id, **kwargs):
        """
        Update a segment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_segment(segment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str segment_id: ID of the segment. (required)
        :param PatchSegment body: 
        :return: JourneySegment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_segment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params) or (params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `patch_journey_segment`")


        resource_path = '/api/v2/journey/segments/{segmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'segment_id' in params:
            path_params['segmentId'] = params['segment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneySegment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_analytics_journeys_aggregates_query(self, body, **kwargs):
        """
        Query for journey aggregates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_analytics_journeys_aggregates_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param JourneyAggregationQuery body: query (required)
        :return: JourneyAggregateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_analytics_journeys_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_analytics_journeys_aggregates_query`")


        resource_path = '/api/v2/analytics/journeys/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyAggregateQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_actionmaps(self, **kwargs):
        """
        Create an action map.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_actionmaps(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ActionMap body: 
        :return: ActionMap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_actionmaps" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actionmaps'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_actionmaps_estimates_jobs(self, body, **kwargs):
        """
        Query for estimates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_actionmaps_estimates_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ActionMapEstimateRequest body: audience estimator request (required)
        :return: EstimateJobAsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_actionmaps_estimates_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_journey_actionmaps_estimates_jobs`")


        resource_path = '/api/v2/journey/actionmaps/estimates/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EstimateJobAsyncResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_actiontemplates(self, **kwargs):
        """
        Create a single action template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_actiontemplates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ActionTemplate body: 
        :return: ActionTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_actiontemplates" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actiontemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_outcomes(self, **kwargs):
        """
        Create an outcome.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_outcomes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Outcome body: 
        :return: Outcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_outcomes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/outcomes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Outcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_segments(self, **kwargs):
        """
        Create a segment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_segments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param JourneySegment body: 
        :return: JourneySegment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_segments" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/segments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneySegment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
