# Generated by Django 5.2.5 on 2025-11-09 20:49

import django.core.serializers.json
import django.db.models.deletion
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('raw_message', models.JSONField(verbose_name='raw message')),
                ('error', models.TextField(blank=True, null=True, verbose_name='error')),
            ],
            options={
                'verbose_name': 'message',
                'verbose_name_plural': 'messages',
            },
        ),
        migrations.CreateModel(
            name='TelegramSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('chat_id', models.IntegerField(unique=True, verbose_name='chat id')),
                ('data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder, verbose_name='data')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'telegram setting',
                'verbose_name_plural': 'telegram settings',
                'swappable': 'TELEGRAM_SETTINGS_MODEL',
            },
        ),
        migrations.CreateModel(
            name='CallbackData',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.UUIDField(db_index=True, default=uuid.uuid4, unique=True, verbose_name='token')),
                ('command', models.CharField(max_length=255, verbose_name='command')),
                ('step', models.CharField(max_length=255, verbose_name='step')),
                ('action', models.CharField(help_text='Name of a function on the command', max_length=99, verbose_name='action')),
                ('data', models.JSONField(default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder, verbose_name='callback data')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
            ],
            options={
                'verbose_name': 'callback data',
                'verbose_name_plural': 'callback data',
                'indexes': [models.Index(models.F('data__correlation_key'), name='callback_correlation_key_idx')],
            },
        ),
    ]
