<h1 align="center">
  Django Telegram App
</h1>

<p align="center">
  <img src="docs/assets/banner.png" alt="django-telegram-app logo" width="480">
</p>

<p align="center">
  <i>A Django app to integrate Telegram bots into your project.</i>
</p>

---

<p align="center">
<a href="https://github.com/astral-sh/ruff" target="_blank"><img src="https://img.shields.io/badge/style-ruff-8b5000" alt="Style: ruff"/></a>
<a href="https://github.com/RobertCraigie/pyright-python" target="_blank"><img src="https://img.shields.io/badge/typing-pyright-725a42" alt="Typing: pyright"/></a>
<a href="https://github.com/pylint-dev/pylint" target="_blank"><img src="https://img.shields.io/badge/linting-pylint-755147" alt="Linting: pylint"/></a>
<a href="https://docs.djangoproject.com/en/5.2/" target="_blank"><img src="https://img.shields.io/badge/framework-django-727242" alt="Framework: Django" /></a>
<a href="https://opensource.org/license/mit" target="_blank"><img src="https://img.shields.io/github/license/mashape/apistatus.svg" alt="License" /></a>
<a href="https://github.com/shifqu/django-telegram-app/actions/workflows/ci.yml" target="_blank"><img src="https://github.com/shifqu/django-telegram-app/actions/workflows/ci.yml/badge.svg" alt="Status: CI Validation" /></a>
</p>

---

**Documentation**: [https://shifqu.github.io/django-telegram-app/](https://shifqu.github.io/django-telegram-app/)

**Source code**: [https://github.com/shifqu/django-telegram-app/](https://github.com/shifqu/django-telegram-app/)

---

## Features

- 🧩 Command-based bot architecture with step-based flow
- 🔄 Swappable `TelegramSettings` model
- ⚙️ Optional admin integration for Telegram settings
- 📦 Extensible: add bot-commands per app via auto-discovery
- 🛡️ Built-in system checks for misconfiguration
- 🗄️ Django ORM integration (no direct API handling required)
- 🧪 Easy to test (includes custom `TelegramTestCase`)

## Requirements

- Python **3.10+**
- Django **5.2+**

## Getting started

To set up your bot, follow the step-by-step guide in  
➡️ [Getting started](https://shifqu.github.io/django-telegram-app/getting-started)

## Support

See our issue tracker at: [https://github.com/shifqu/django-telegram-app/issues](https://github.com/shifqu/django-telegram-app/issues)

## License

This project is licensed under the MIT License — see the [`LICENSE`](https://github.com/shifqu/django-telegram-app/blob/main/LICENSE) file for details.

## About the Mascot

The project’s mascot is a robotic pigeon — inspired by the historical use of carrier pigeons to deliver messages reliably over long distances.  
The robotic design reflects the robustness and sturdiness of the Django framework, while symbolizing automation and modern messaging flows.  
Together, it represents a blend of tradition and technology: a dependable messenger for the world of Telegram bots.