/* Copyright 2018 ETH Zurich and University of Bologna.
 * Copyright and related rights are licensed under the Solderpad Hardware
 * License, Version 0.51 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://solderpad.org/licenses/SHL-0.51. Unless required by applicable law
 * or agreed to in writing, software, hardware and materials distributed under
 * this License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * File: $filename.v
 *
 * Description: Auto-generated bootrom
 */

// Auto-generated code
module bootrom_64 (
   input  logic         clk_i,
   input  logic         req_i,
   input  logic [63:0]  addr_i,
   output logic [63:0]  rdata_o
);
    localparam int RomSize = 895;

    const logic [RomSize-1:0][63:0] mem = {
        64'h00000000_00000000,
        64'h0a0d2165_6e6f6420,
        64'h00000000_00206567,
        64'h616d6920_746f6f62,
        64'h20676e69_79706f63,
        64'h00000000_00000009,
        64'h3a656d61_6e090a0d,
        64'h00093a73_65747562,
        64'h69727474_61090a0d,
        64'h00000009_3a61626c,
        64'h20747361_6c090a0d,
        64'h0000093a_61626c20,
        64'h74737269_66090a0d,
        64'h00000000_00000000,
        64'h09202020_20203a64,
        64'h69756720_6e6f6974,
        64'h69747261_70090a0d,
        64'h00000000_00000000,
        64'h093a6469_75672065,
        64'h70797420_6e6f6974,
        64'h69747261_70090a0d,
        64'h00000000_20797274,
        64'h6e65206e_6f697469,
        64'h74726170_20747067,
        64'h00000009_20203a73,
        64'h65697274_6e65206e,
        64'h6f697469_74726170,
        64'h20657a69_73090a0d,
        64'h00000009_3a736569,
        64'h72746e65_206e6f69,
        64'h74697472_61702072,
        64'h65626d75_6e090a0d,
        64'h00000009_2020203a,
        64'h61626c20_73656972,
        64'h746e6520_6e6f6974,
        64'h69747261_70090a0d,
        64'h00093a61_646c2070,
        64'h756b6361_62090a0d,
        64'h00000000_00000000,
        64'h093a6162_6c20746e,
        64'h65727275_63090a0d,
        64'h00000009_3a646576,
        64'h72657365_72090a0d,
        64'h00093a72_65646165,
        64'h685f6372_63090a0d,
        64'h00000000_00000909,
        64'h3a657a69_73090a0d,
        64'h00000009_3a6e6f69,
        64'h73697665_72090a0d,
        64'h0000093a_65727574,
        64'h616e6769_73090a0d,
        64'h00000000_003a7265,
        64'h64616568_20656c62,
        64'h6174206e_6f697469,
        64'h74726170_20747067,
        64'h0000203a_65756c61,
        64'h76206e72_75746572,
        64'h2079706f_63206473,
        64'h00000000_0000000a,
        64'h0d216465_6c696166,
        64'h20647261_63204453,
        64'h00000000_0000000a,
        64'h0d216465_7a696c61,
        64'h6974696e_69206473,
        64'h00000000_0a0d676e,
        64'h69746978_65202e2e,
        64'h2e647320_657a696c,
        64'h61697469_6e692074,
        64'h6f6e2064_6c756f63,
        64'h00000000_0000002e,
        64'h00000000_0000000a,
        64'h0d6b636f_6c622044,
        64'h53206461_65722074,
        64'h6f6e2064_6c756f63,
        64'h0000000a_0d202e2e,
        64'h2e445320_676e697a,
        64'h696c6169_74696e69,
        64'h00000031_34646d63,
        64'h00000035_35646d63,
        64'h00000000_30646d63,
        64'h00000020_3a206573,
        64'h6e6f7073_65720920,
        64'h00000000_0020646e,
        64'h616d6d6f_63204453,
        64'h00000000_203f3f79,
        64'h74706d65_20746f6e,
        64'h206f6669_66207872,
        64'h00000000_00000a0d,
        64'h2164657a_696c6169,
        64'h74696e69_20495053,
        64'h00000000_00007830,
        64'h203a7375_74617473,
        64'h00000000_00000a0d,
        64'h49505320_74696e69,
        64'h00000a0d_21646c72,
        64'h6f57206f_6c6c6548,
        64'h00000000_00000032,
        64'h2d746c75_61666564,
        64'h2d697274_2c786e6c,
        64'h7800746c_75616665,
        64'h642d6972_742c786e,
        64'h6c78006c_6175642d,
        64'h73692c78_6e6c7800,
        64'h746e6573_6572702d,
        64'h74707572_7265746e,
        64'h692c786e_6c780068,
        64'h74646977_2d326f69,
        64'h70672c78_6e6c7800,
        64'h68746469_772d6f69,
        64'h70672c78_6e6c7800,
        64'h322d746c_75616665,
        64'h642d7475_6f642c78,
        64'h6e6c7800_746c7561,
        64'h6665642d_74756f64,
        64'h2c786e6c_7800322d,
        64'h73747570_6e692d6c,
        64'h6c612c78_6e6c7800,
        64'h73747570_6e692d6c,
        64'h6c612c78_6e6c7800,
        64'h72656c6c_6f72746e,
        64'h6f632d6f_69706700,
        64'h736c6c65_632d6f69,
        64'h70672300_73736572,
        64'h6464612d_63616d2d,
        64'h6c61636f_6c007077,
        64'h2d656c62_61736964,
        64'h00736567_6e61722d,
        64'h65676174_6c6f7600,
        64'h79636e65_75716572,
        64'h662d7861_6d2d6970,
        64'h73006f69_7461722d,
        64'h6b63732c_786e6c78,
        64'h00737469_622d7265,
        64'h66736e61_72742d6d,
        64'h756e2c78_6e6c7800,
        64'h73746962_2d73732d,
        64'h6d756e2c_786e6c78,
        64'h00747369_78652d6f,
        64'h6669662c_786e6c78,
        64'h00796c69_6d61662c,
        64'h786e6c78_00687464,
        64'h69772d6f_692d6765,
        64'h72007466_6968732d,
        64'h67657200_73747075,
        64'h72726574_6e690074,
        64'h6e657261_702d7470,
        64'h75727265_746e6900,
        64'h64656570_732d746e,
        64'h65727275_63007665,
        64'h646e2c76_63736972,
        64'h00797469_726f6972,
        64'h702d7861_6d2c7663,
        64'h73697200_73656d61,
        64'h6e2d6765_72006465,
        64'h646e6574_78652d73,
        64'h74707572_7265746e,
        64'h69007365_676e6172,
        64'h00646564_6e657073,
        64'h75732d65_74617473,
        64'h2d6e6961_74657200,
        64'h72656767_6972742d,
        64'h746c7561_6665642c,
        64'h78756e69_6c00736f,
        64'h69706700_656c646e,
        64'h61687000_72656c6c,
        64'h6f72746e_6f632d74,
        64'h70757272_65746e69,
        64'h00736c6c_65632d74,
        64'h70757272_65746e69,
        64'h23007469_6c70732d,
        64'h626c7400_65707974,
        64'h2d756d6d_00617369,
        64'h2c766373_69720073,
        64'h75746174_73006765,
        64'h72006570_79745f65,
        64'h63697665_64007963,
        64'h6e657571_6572662d,
        64'h6b636f6c_63007963,
        64'h6e657571_6572662d,
        64'h65736162_656d6974,
        64'h00687461_702d7475,
        64'h6f647473_006c6564,
        64'h6f6d0065_6c626974,
        64'h61706d6f_6300736c,
        64'h6c65632d_657a6973,
        64'h2300736c_6c65632d,
        64'h73736572_64646123,
        64'h09000000_02000000,
        64'h02000000_02000000,
        64'h01000000_b5000000,
        64'h04000000_03000000,
        64'hffffffff_bf020000,
        64'h04000000_03000000,
        64'hffffffff_ae020000,
        64'h04000000_03000000,
        64'h01000000_a1020000,
        64'h04000000_03000000,
        64'h00000000_8a020000,
        64'h04000000_03000000,
        64'h08000000_79020000,
        64'h04000000_03000000,
        64'h08000000_69020000,
        64'h04000000_03000000,
        64'h00000000_55020000,
        64'h04000000_03000000,
        64'h00000000_43020000,
        64'h04000000_03000000,
        64'h00000000_31020000,
        64'h04000000_03000000,
        64'h00000000_21020000,
        64'h04000000_03000000,
        64'h00000100_00000000,
        64'h00000040_00000000,
        64'h67000000_10000000,
        64'h03000000_11020000,
        64'h00000000_03000000,
        64'h00000000_612e3030,
        64'h2e312d6f_6970672d,
        64'h7370782c_786e6c78,
        64'h1b000000_15000000,
        64'h03000000_02000000,
        64'h05020000_04000000,
        64'h03000000_00000030,
        64'h30303030_30303440,
        64'h6f697067_01000000,
        64'h02000000_00800000,
        64'h00000000_00000030,
        64'h00000000_67000000,
        64'h10000000_03000000,
        64'h00007fe3_023e1800,
        64'hf3010000_06000000,
        64'h03000000_00000000,
        64'h03000000_52010000,
        64'h08000000_03000000,
        64'h03000000_41010000,
        64'h04000000_03000000,
        64'h006b726f_7774656e,
        64'h5b000000_08000000,
        64'h03000000_00687465,
        64'h2d637369_72776f6c,
        64'h1b000000_0c000000,
        64'h03000000_00000000,
        64'h30303030_30303033,
        64'h40687465_2d637369,
        64'h72776f6c_01000000,
        64'h02000000_02000000,
        64'he8010000_00000000,
        64'h03000000_e40c0000,
        64'he40c0000_d9010000,
        64'h08000000_03000000,
        64'h20bcbe00_c7010000,
        64'h04000000_03000000,
        64'h00000000_67000000,
        64'h04000000_03000000,
        64'h00000000_746f6c73,
        64'h2d697073_2d636d6d,
        64'h1b000000_0d000000,
        64'h03000000_00000030,
        64'h40636d6d_01000000,
        64'h04000000_b8010000,
        64'h04000000_03000000,
        64'h08000000_a1010000,
        64'h04000000_03000000,
        64'h01000000_90010000,
        64'h04000000_03000000,
        64'h01000000_80010000,
        64'h04000000_03000000,
        64'h00377865_746e696b,
        64'h74010000_08000000,
        64'h03000000_00100000,
        64'h00000000_00000020,
        64'h00000000_67000000,
        64'h10000000_03000000,
        64'h02000000_02000000,
        64'h52010000_08000000,
        64'h03000000_03000000,
        64'h41010000_04000000,
        64'h03000000_00000000,
        64'h0f000000_04000000,
        64'h03000000_01000000,
        64'h00000000_04000000,
        64'h03000000_00612e30,
        64'h302e322d_6970732d,
        64'h7370782c_786e6c78,
        64'h00622e30_302e322d,
        64'h6970732d_7370782c,
        64'h786e6c78_1b000000,
        64'h28000000_03000000,
        64'h00000000_30303030,
        64'h30303032_40697073,
        64'h2d737078_01000000,
        64'h02000000_006c6f72,
        64'h746e6f63_0b010000,
        64'h08000000_03000000,
        64'h03000000_41010000,
        64'h04000000_03000000,
        64'h00100000_00000000,
        64'h00000018_00000000,
        64'h67000000_10000000,
        64'h03000000_07000000,
        64'h06000000_05000000,
        64'h04000000_52010000,
        64'h10000000_03000000,
        64'h00007265_6d69745f,
        64'h6270612c_706c7570,
        64'h1b000000_0f000000,
        64'h03000000_00003030,
        64'h30303030_38314072,
        64'h656d6974_01000000,
        64'h02000000_04000000,
        64'h67010000_04000000,
        64'h03000000_02000000,
        64'h5d010000_04000000,
        64'h03000000_01000000,
        64'h52010000_04000000,
        64'h03000000_03000000,
        64'h41010000_04000000,
        64'h03000000_00c20100,
        64'h33010000_04000000,
        64'h03000000_80f0fa02,
        64'h4b000000_04000000,
        64'h03000000_00100000,
        64'h00000000_00000010,
        64'h00000000_67000000,
        64'h10000000_03000000,
        64'h00000000_61303535,
        64'h3631736e_1b000000,
        64'h09000000_03000000,
        64'h00000030_30303030,
        64'h30303140_74726175,
        64'h01000000_02000000,
        64'h03000000_b5000000,
        64'h04000000_03000000,
        64'h1e000000_28010000,
        64'h04000000_03000000,
        64'h07000000_15010000,
        64'h04000000_03000000,
        64'h00000004_00000000,
        64'h0000000c_00000000,
        64'h67000000_10000000,
        64'h03000000_09000000,
        64'h02000000_0b000000,
        64'h02000000_f7000000,
        64'h10000000_03000000,
        64'ha0000000_00000000,
        64'h03000000_00306369,
        64'h6c702c76_63736972,
        64'h1b000000_0c000000,
        64'h03000000_01000000,
        64'h8f000000_04000000,
        64'h03000000_00000000,
        64'h00000000_04000000,
        64'h03000000_00000000,
        64'h30303030_30306340,
        64'h72656c6c_6f72746e,
        64'h6f632d74_70757272,
        64'h65746e69_01000000,
        64'h02000000_006c6f72,
        64'h746e6f63_0b010000,
        64'h08000000_03000000,
        64'h00000c00_00000000,
        64'h00000002_00000000,
        64'h67000000_10000000,
        64'h03000000_07000000,
        64'h02000000_03000000,
        64'h02000000_f7000000,
        64'h10000000_03000000,
        64'h00000000_30746e69,
        64'h6c632c76_63736972,
        64'h1b000000_0d000000,
        64'h03000000_00000030,
        64'h30303030_30324074,
        64'h6e696c63_01000000,
        64'hf0000000_00000000,
        64'h03000000_00007375,
        64'h622d656c_706d6973,
        64'h00636f73_2d657261,
        64'h622d656e_61697261,
        64'h2c687465_1b000000,
        64'h1f000000_03000000,
        64'h02000000_0f000000,
        64'h04000000_03000000,
        64'h02000000_00000000,
        64'h04000000_03000000,
        64'h00636f73_01000000,
        64'h02000000_02000000,
        64'hd9000000_00000000,
        64'h03000000_00000074,
        64'h61656274_72616568,
        64'hc3000000_0a000000,
        64'h03000000_00000000,
        64'h01000000_01000000,
        64'hbd000000_0c000000,
        64'h03000000_00000064,
        64'h656c2d74_61656274,
        64'h72616568_01000000,
        64'h00000073_64656c2d,
        64'h6f697067_1b000000,
        64'h0a000000_03000000,
        64'h00000000_7364656c,
        64'h01000000_02000000,
        64'h00000040_00000000,
        64'h00000080_00000000,
        64'h67000000_10000000,
        64'h03000000_00007972,
        64'h6f6d656d_5b000000,
        64'h07000000_03000000,
        64'h00303030_30303030,
        64'h38407972_6f6d656d,
        64'h01000000_02000000,
        64'h02000000_02000000,
        64'h02000000_b5000000,
        64'h04000000_03000000,
        64'h00006374_6e692d75,
        64'h70632c76_63736972,
        64'h1b000000_0f000000,
        64'h03000000_a0000000,
        64'h00000000_03000000,
        64'h01000000_8f000000,
        64'h04000000_03000000,
        64'h00000000_72656c6c,
        64'h6f72746e_6f632d74,
        64'h70757272_65746e69,
        64'h01000000_85000000,
        64'h00000000_03000000,
        64'h00003933_76732c76,
        64'h63736972_7c000000,
        64'h0b000000_03000000,
        64'h00006364_66616d69,
        64'h34367672_72000000,
        64'h0b000000_03000000,
        64'h00000076_63736972,
        64'h00656e61_69726120,
        64'h2c687465_1b000000,
        64'h12000000_03000000,
        64'h00000000_79616b6f,
        64'h6b000000_05000000,
        64'h03000000_00000000,
        64'h67000000_04000000,
        64'h03000000_00757063,
        64'h5b000000_04000000,
        64'h03000000_80f0fa02,
        64'h4b000000_04000000,
        64'h03000000_00000030,
        64'h40757063_01000000,
        64'h40787d01_38000000,
        64'h04000000_03000000,
        64'h00000000_0f000000,
        64'h04000000_03000000,
        64'h01000000_00000000,
        64'h04000000_03000000,
        64'h00000000_73757063,
        64'h01000000_02000000,
        64'h00000030_30323531,
        64'h313a3030_30303030,
        64'h30314074_7261752f,
        64'h636f732f_2c000000,
        64'h1a000000_03000000,
        64'h00006e65_736f6863,
        64'h01000000_00657261,
        64'h622d656e_61697261,
        64'h2c687465_26000000,
        64'h10000000_03000000,
        64'h00766564_2d657261,
        64'h622d656e_61697261,
        64'h2c687465_1b000000,
        64'h14000000_03000000,
        64'h02000000_0f000000,
        64'h04000000_03000000,
        64'h02000000_00000000,
        64'h04000000_03000000,
        64'h00000000_01000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'he8080000_d2020000,
        64'h00000000_10000000,
        64'h11000000_28000000,
        64'h20090000_38000000,
        64'hf20b0000_edfe0dd0,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h46454443_42413938,
        64'h37363534_33323130,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h0000a001_84021ae5,
        64'h85930000_0597047e,
        64'h0010041b_e909c6bf,
        64'hf0ef057e_65a14505,
        64'he38ff0ef_dc450513,
        64'h00001517_e00ff0ef,
        64'he4060805_05132005,
        64'h85931141_02faf537,
        64'h65f1b79d_f8c371e3,
        64'h963e8f1d_17c18096,
        64'hfa2680e7_82869696,
        64'h00000297_00279693,
        64'hb7598dd5_02059693,
        64'h8dd50105_96938dd5,
        64'h00859693_0ff5f593,
        64'h808200b7_002300b7,
        64'h00a300b7_012300b7,
        64'h01a300b7_022300b7,
        64'h02a300b7_032300b7,
        64'h03a300b7_042300b7,
        64'h04a300b7_052300b7,
        64'h05a300b7_062300b7,
        64'h06a300b7_072300a6,
        64'h80679696_00000297,
        64'h068a40c3_06b38082,
        64'he211fed7_6de30741,
        64'he70ce30c_96ba8a3d,
        64'hff067693_e1bde3c1,
        64'h00f77793_02c37163,
        64'h872a433d_b3b5f06f,
        64'hf0ef1825_05130000,
        64'h1517bbf1_edc50513,
        64'h00001517_f9eff0ef,
        64'h854af22f_f0effde5,
        64'h05130000_1517f2ef,
        64'hf0effd25_05130000,
        64'h1517b511_f0450513,
        64'h00001517_fc6ff0ef,
        64'h8526f4af_f0ef0065,
        64'h05130000_1517f56f,
        64'hf0efffa5_05130000,
        64'h1517c929_84aac5bf,
        64'hf0ef9e0d_26058552,
        64'h020aa583_028ab603,
        64'hf78ff0ef_1dc50513,
        64'h00001517_f56910e3,
        64'h08048493_f8cff0ef,
        64'h2905f5a5_05130000,
        64'h1517ff89_9be3863f,
        64'hf0ef0985_0009c503,
        64'hfa8ff0ef_1fc50513,
        64'h00001517_837ff0ef,
        64'h6888fbaf_f0ef1fe5,
        64'h05130000_1517849f,
        64'hf0ef6488_fccff0ef,
        64'h20050513_00001517,
        64'h85bff0ef_06048c13,
        64'h01848993_6088fe6f,
        64'hf0ef20a5_05130000,
        64'h1517ff34_9be38bbf,
        64'hf0ef0985_0009c503,
        64'hff048993_805ff0ef,
        64'h20850513_00001517,
        64'hff7999e3_8d9ff0ef,
        64'h09850007_c503013c,
        64'h07b34981_825ff0ef,
        64'hfe048c13_20c50513,
        64'h00001517_8f9ff0ef,
        64'h0ff97513_83dff0ef,
        64'h20850513_00001517,
        64'h4b114bc1_10051b63,
        64'h1004892a_8a8ad4bf,
        64'hf0ef850a_46057101,
        64'h04892583_865ff0ef,
        64'h03050513_00001517,
        64'h8b3ff0ef_4556877f,
        64'hf0ef2225_05130000,
        64'h15178c5f_f0ef4546,
        64'h889ff0ef_21450513,
        64'h00001517_917ff0ef,
        64'h652689bf_f0ef2065,
        64'h05130000_1517929f,
        64'hf0ef7502_8adff0ef,
        64'h20850513_00001517,
        64'h93bff0ef_65628bff,
        64'hf0ef2025_05130000,
        64'h151790df_f0ef4552,
        64'h8d1ff0ef_20450513,
        64'h00001517_91fff0ef,
        64'h45428e3f_f0ef2065,
        64'h05130000_1517931f,
        64'hf0ef4532_8f5ff0ef,
        64'h20850513_00001517,
        64'h943ff0ef_4522907f,
        64'hf0ef20a5_05130000,
        64'h1517995f_f0ef6502,
        64'h919ff0ef_20c50513,
        64'h00001517_925ff0ef,
        64'h1f850513_00001517,
        64'hbf6154f9_935ff0ef,
        64'h10050513_00001517,
        64'h9c3ff0ef_8526947f,
        64'hf0ef2025_05130000,
        64'h1517953f_f0ef1f65,
        64'h05130000_1517c905,
        64'h84aa890a_e59ff0ef,
        64'h850a4585_46057101,
        64'h971ff0ef_1fc50513,
        64'h00001517_80826161,
        64'h6c026ba2_6b426ae2,
        64'h7a0279a2_794274e2,
        64'h64068526_60a6fb04,
        64'h011354fd_99dff0ef,
        64'h20050513_00001517,
        64'hc51de01f_f0ef8a2a,
        64'h0880e062_e45ee85a,
        64'hec56f44e_f84afc26,
        64'he486f052_e0a2715d,
        64'hb7655479_80826169,
        64'h6baa6b4a_6aea7a0a,
        64'h79aa794a_74ea640e,
        64'h852260ae_547d9e7f,
        64'hf0ef2225_05130000,
        64'h1517c6bf_f0efc6ff,
        64'hf0efc73f_f0efc77f,
        64'hf0efc7bf_f0efc7ff,
        64'hf0efc83f_f0efc87f,
        64'hf0efa805_c8dff0ef,
        64'hc97ff0ef_45314581,
        64'h46054401_f92047e3,
        64'h197da2bf_f0ef2865,
        64'h05130000_1517e799,
        64'h034967b3_06941a63,
        64'h24819041_14428c49,
        64'hcc1ff0ef_90411442,
        64'h0085141b_8aa2ccff,
        64'hf0effd64_1ae30404,
        64'h0413ff7a_97e384aa,
        64'hf25ff0ef_0a858526,
        64'h0007c583_015407b3,
        64'h04000b93_4a81c73f,
        64'hf0ef850a_04000593,
        64'h8622200a_8b134481,
        64'h8456ff35_1ee3d0ff,
        64'hf0ef3e80_0a130fe0,
        64'h09930209_5913e959,
        64'hd27ff0ef_454985a2,
        64'h0ff67613_00166613,
        64'h0015161b_f57ff0ef,
        64'h0ff47593_f5fff0ef,
        64'h0ff5f593_0084559b,
        64'hf6bff0ef_0ff5f593,
        64'h0104559b_f77ff0ef,
        64'h45010184_559b3e60,
        64'h00efe55e_e95af152,
        64'hf54efd26_e5860800,
        64'h0613850a_02061913,
        64'h8aaa0ff0_0593ed56,
        64'h842ef94a_e1a27155,
        64'h80829141_15428d3d,
        64'h8ff91781_0057171b,
        64'h67890107_571b0105,
        64'h171b8d3d_00c5179b,
        64'h8d2d893d_0045d51b,
        64'h8dbd93c1_17c28fc9,
        64'h0085551b_0085179b,
        64'h808207f5_75138d3d,
        64'h0ff7f793_0045179b,
        64'h8d2d0ff5_75138d3d,
        64'h0045d51b_0075d79b,
        64'h8de98082_0141853e,
        64'h640260a2_57f5e111,
        64'h4781f89f_f0efc511,
        64'h57f9efdf_f0efc911,
        64'h57fdeb9f_f0effc6d,
        64'he09ff0ef_347d4429,
        64'hb99ff0ef_3bc50513,
        64'h00001517_c8dff0ef,
        64'he022e406_11418082,
        64'h61050015_351364a2,
        64'h64420004_051b60e2,
        64'hfc940ce3_e3dff0ef,
        64'heb5ff0ef_3e450513,
        64'h00001517_85aa842a,
        64'he57ff0ef_02900513,
        64'h400005b7_07700613,
        64'hfbdff0ef_4485e822,
        64'hec06e426_11018082,
        64'h01410015_3513157d,
        64'h64020004_051b60a2,
        64'hef5ff0ef_41e50513,
        64'h85a20000_1517e8ff,
        64'hf0ef842a_e9bff0ef,
        64'he022e406_03700513,
        64'h45810650_06131141,
        64'h80826105_690264a2,
        64'h644260e2_00143513,
        64'hf5640413_24010124,
        64'h976388bd_00f91a63,
        64'h45014785_ecdff0ef,
        64'hed1ff0ef_842aed7f,
        64'hf0ef84aa_eddff0ef,
        64'hee1ff0ef_ee5ff0ef,
        64'h892aef1f_f0efe04a,
        64'he426e822_ec064521,
        64'h1aa00593_08700613,
        64'h1101bfcd_45018082,
        64'h61056902_64a26442,
        64'h60e24505_f89ff0ef,
        64'h45854aa5_05130000,
        64'h1517ff24_95e3c00d,
        64'hf29ff0ef_84aa347d,
        64'hf37ff0ef_45014581,
        64'h09500613_49057104,
        64'h0413e426_ec06e04a,
        64'h6409e822_1101b9d1,
        64'h61054a25_05130000,
        64'h151764a2_60e26442,
        64'hdadff0ef_8522ceff,
        64'hf0ef4ea5_05130000,
        64'h1517cfbf_f0ef8526,
        64'hd01ff0ef_842ee822,
        64'hec064f25_05130000,
        64'h151784aa_e4261101,
        64'h80826105_690264a2,
        64'h644260e2_f47d147d,
        64'h0007d463_4187d79b,
        64'h0185179b_fadff0ef,
        64'h06400413_ebbff0ef,
        64'h8526ec1f_f0ef0ff4,
        64'h7513ec9f_f0ef0ff5,
        64'h75130084_551bed5f,
        64'hf0ef0ff5_75130104,
        64'h551bee1f_f0ef0184,
        64'h551bee9f_f0ef0409,
        64'h6513febf_f0ef892a,
        64'he04a84b2_842ee426,
        64'he822ec06_1101b709,
        64'h0ff00513_8082557d,
        64'hb7d900d7_00230785,
        64'h00f60733_06c82683,
        64'hff698b05_5178b77d,
        64'hd6b80785_00074703,
        64'h00f50733_80824501,
        64'hd3b84719_dbb8577d,
        64'h200007b7_02b6e163,
        64'h0007869b_20000837,
        64'h20000537_fff58b85,
        64'h537c2000_0737d3b8,
        64'h200007b7_10600713,
        64'hfff537fd_00010320,
        64'h079304b7_61630007,
        64'h871b4781_200006b7,
        64'hdbb85779_200007b7,
        64'h06b7ee63_10000793,
        64'h80826105_64a2d3b8,
        64'h4719dbb8_64420ff4,
        64'h7513577d_200007b7,
        64'h60e2e2bf_f0ef5f65,
        64'h05130000_1517eb9f,
        64'hf0ef9101_15024088,
        64'he41ff0ef_61450513,
        64'h00001517_e3958b85,
        64'h240153fc_57e0ff65,
        64'h8b050647_849353f8,
        64'hd3b81060_07132000,
        64'h07b7fff5_37fd0001,
        64'h06400793_d7a8dbb8,
        64'h5779e426_e822ec06,
        64'h200007b7_1101b551,
        64'h61056425_05130000,
        64'h151764a2_60e26442,
        64'hd03c4799_e9dff0ef,
        64'h66850513_00001517,
        64'hf2bff0ef_91010204,
        64'h95132481_eb5ff0ef,
        64'h66050513_00001517,
        64'h5064d03c_16600793,
        64'hec9ff0ef_69450513,
        64'h00001517_f57ff0ef,
        64'h91010204_95132481,
        64'hee1ff0ef_68c50513,
        64'h00001517_5064d03c,
        64'h10400793_20000437,
        64'hfff537fd_000147a9,
        64'hc3b84729_200007b7,
        64'hf09ff0ef_e426e822,
        64'hec066ac5_05131101,
        64'h00001517_80824108,
        64'h8082c10c_b5e96105,
        64'h60e20091_4503ed7f,
        64'hf0ef0081_4503f55f,
        64'hf0efec06_002c1101,
        64'h80826145_694264e2,
        64'h740270a2_ff2410e3,
        64'hef9ff0ef_00914503,
        64'hf01ff0ef_34610081,
        64'h4503f81f_f0ef0ff5,
        64'h7513002c_0084d533,
        64'h59610380_041384aa,
        64'hf406e84a_ec26f022,
        64'h71798082_61456942,
        64'h64e27402_70a2ff24,
        64'h10e3f3bf_f0ef0091,
        64'h4503f43f_f0ef3461,
        64'h00814503_fc3ff0ef,
        64'h0ff57513_002c0084,
        64'hd53b5961_446184aa,
        64'hf406e84a_ec26f022,
        64'h71798082_00f58023,
        64'h0007c783_00e580a3,
        64'h97aa8111_00074703,
        64'h973e00f5_7713a6e7,
        64'h87930000_1797b7f5,
        64'h0405f93f_f0ef8082,
        64'h01416402_60a2e509,
        64'h00044503_842ae406,
        64'he0221141_808200e7,
        64'h88230200_071300e7,
        64'h8423fc70_071300e7,
        64'h8623470d_00a78223,
        64'h0ff57513_00e78023,
        64'h0085551b_0ff57713,
        64'h00e78623_f8000713,
        64'h00078223_100007b7,
        64'h02b5553b_0045959b,
        64'h808200a7_0023dfe5,
        64'h0207f793_01474783,
        64'h10000737_80820205,
        64'h75130147_c5031000,
        64'h07b78082_00054503,
        64'h808200b5_00238082,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00048067_01f49493,
        64'h0010049b_c8458593,
        64'h00001597_f1402573,
        64'hff24c6e3_4009091b,
        64'h02000937_00448493,
        64'hfe091ee3_0004a903,
        64'h00092023_00990933,
        64'h00291913_f1402973,
        64'h020004b7_fe090ae3,
        64'h00897913_34402973,
        64'h10500073_ff24c6e3,
        64'h4009091b_02000937,
        64'h00448493_0124a023,
        64'h00100913_020004b7,
        64'h303000ef_01a11113,
        64'h0210011b_03249663,
        64'hf1402973_00000493,
        64'h30491073_00800913
    };

    logic [$clog2(RomSize)-1:0] addr_q;

    always_ff @(posedge clk_i) begin
        if (req_i) begin
            addr_q <= addr_i[$clog2(RomSize)-1+3:3];
        end
    end

    // this prevents spurious Xes from propagating into
    // the speculative fetch stage of the core
    assign rdata_o = (addr_q < RomSize) ? mem[addr_q] : '0;
endmodule
