from ai_core_sdk.ai_core_v2_client import AICoreV2Client
from hdbcli import dbapi

from .config.config import Config
from .aicore.aicore import AICore
from .hanadb.hanadb import HANADb
from .exceptions.exceptions import GenAIWrapperException
from .data_objects.chat_object import ChatObject
from .data_objects.vector_object import HANAVectorObject
from .comm.chat import Chat 
from .comm.embed import Embeddings


central_config: dict = None
ai_core_client: AICoreV2Client = None
hana_db_client: dbapi = None

__all__ = [
    "central_config",    
    "ai_core_client",

    "GenAIWrapperException",

    "Config",
    "AICore",
    "HANADb",
    "Chat",
    "Embeddings",
    "ChatObject",
    "HANAVectorObject"
]

'''

ai-api-client-sdk==2.1.4
ai-core-sdk==2.3.11
hdbcli==2.21.28
'''