# Contributor's Agreement
This code is licensed under the Affero GPL, version 3.0 or later [LICENSE](../LICENSE).

The Affero GPL is a Copyleft license, meaning that it aims to ensure 
that free and open software remains perpetually free and open by requiring 
users of it to license their improvements under the same terms as the original.

If you make changes to the software and make the modified software available
to users within your organization (for example, students at a university)
via a network, this is considered propogation (not conveyance) and you 
do not need to share your modifications. if you transfer copies of the 
software to others, this **is** considered a conveyance.

# Contributing

When contributing to Python Puzzles, it is 
important to properly communicate the gist of the contribution. 
If it is a simple code or editorial fix, simply explaining this 
within the GitHub Pull Request (PR) will suffice. But if this is a larger 
fix or Enhancement, it should be first discussed with the project
leader or developers.

Please note we have a code of conduct, described below. Please follow it in
all your interactions with the project members and users.

## Pull Request Process

1. Bug fix PRs should be sent to both the master and development branches.
   Feature enhancements should only be submitted against the development
   branch.
2. Follow the existing code style precedent. This does not need to be strictly
   defined as there are many thousands of lines of examples. Note the lack
   of tabs anywhere in the project, parentheses and spacing, documentation
   style, source code layout, variable scoping, and follow the project's
   standards.
3. Test your PR locally, and provide the steps necessary to test for the
   reviewers.
4. The project's default copyright and header have been included in any new
   source files.
5. All (major) changes to Python Puzzles must be documented in
   [docs](docs). If your PR changes a core functionality, please 
   include clear description of the changes in your PR so that the docs 
   can be updated, or better, submit another PR to update the docs directly.
6. If necessary, update the README.md.
7. The pull request will be reviewed by others, and the final merge must be
   done by the project lead, @vsoch (or approved by her).


# Code of Conduct

See the [code of conduct](CODE_OF_CONDUCT.md) 
