"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AclTraffic = exports.AclCidr = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Either an IPv4 or an IPv6 CIDR
 *
 *
 */
class AclCidr {
    /**
     * An IP network range in CIDR notation (for example, 172.16.0.0/24).
     */
    static ipv4(ipv4Cidr) {
        return new AclCidrImpl({
            cidrBlock: ipv4Cidr,
        });
    }
    /**
     * The CIDR containing all IPv4 addresses (i.e., 0.0.0.0/0)
     */
    static anyIpv4() {
        return AclCidr.ipv4('0.0.0.0/0');
    }
    /**
     * An IPv6 network range in CIDR notation (for example, 2001:db8::/48)
     */
    static ipv6(ipv6Cidr) {
        return new AclCidrImpl({
            ipv6CidrBlock: ipv6Cidr,
        });
    }
    /**
     * The CIDR containing all IPv6 addresses (i.e., ::/0)
     */
    static anyIpv6() {
        return AclCidr.ipv6('::/0');
    }
}
exports.AclCidr = AclCidr;
_a = JSII_RTTI_SYMBOL_1;
AclCidr[_a] = { fqn: "@aws-cdk/aws-ec2.AclCidr", version: "1.152.0" };
class AclCidrImpl extends AclCidr {
    constructor(config) {
        super();
        this.config = config;
    }
    toCidrConfig() {
        return this.config;
    }
}
/**
 * The traffic that is configured using a Network ACL entry
 *
 *
 */
class AclTraffic {
    /**
     * Apply the ACL entry to all traffic
     */
    static allTraffic() {
        return new AclTrafficImpl({
            protocol: -1,
        });
    }
    /**
     * Apply the ACL entry to ICMP traffic of given type and code
     */
    static icmp(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_AclIcmp(props);
        return new AclTrafficImpl({
            protocol: 1,
            icmp: props,
        });
    }
    /**
     * Apply the ACL entry to ICMPv6 traffic of given type and code
     *
     * Requires an IPv6 CIDR block.
     */
    static icmpv6(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_AclIcmp(props);
        return new AclTrafficImpl({
            protocol: 58,
            icmp: props,
        });
    }
    /**
     * Apply the ACL entry to TCP traffic on a given port
     */
    static tcpPort(port) {
        return new AclTrafficImpl({
            protocol: 6,
            portRange: {
                from: port,
                to: port,
            },
        });
    }
    /**
     * Apply the ACL entry to TCP traffic on a given port range
     */
    static tcpPortRange(startPort, endPort) {
        return new AclTrafficImpl({
            protocol: 6,
            portRange: {
                from: startPort,
                to: endPort,
            },
        });
    }
    /**
     * Apply the ACL entry to UDP traffic on a given port
     */
    static udpPort(port) {
        return new AclTrafficImpl({
            protocol: 17,
            portRange: {
                from: port,
                to: port,
            },
        });
    }
    /**
     * Apply the ACL entry to UDP traffic on a given port range
     */
    static udpPortRange(startPort, endPort) {
        return new AclTrafficImpl({
            protocol: 17,
            portRange: {
                from: startPort,
                to: endPort,
            },
        });
    }
}
exports.AclTraffic = AclTraffic;
_b = JSII_RTTI_SYMBOL_1;
AclTraffic[_b] = { fqn: "@aws-cdk/aws-ec2.AclTraffic", version: "1.152.0" };
class AclTrafficImpl extends AclTraffic {
    constructor(config) {
        super();
        this.config = config;
    }
    toTrafficConfig() {
        return this.config;
    }
}
//# sourceMappingURL=data:application/json;base64,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